/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public class TypesCtr
implements Types {
    private final ConcurrentMap<Class, ConcurrentMap<String, TypeProxy<Type>>> storage = new ConcurrentHashMap<Class, ConcurrentMap<String, TypeProxy<Type>>>();
    private final Stack<TypeProxy> nonVisited = new Stack();

    @Override
    public Type getBy(String name) {
        for (ConcurrentMap map : this.storage.values()) {
            TypeProxy proxy = (TypeProxy)map.get(name);
            if (proxy == null) continue;
            return proxy.get();
        }
        return null;
    }

    @Override
    public <T extends Type> T getBy(Class<T> type, String name) {
        Type t = this.getBy(name);
        try {
            return (T)((Type)type.cast(t));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <T extends Type> TypeProxy<Type> getHolder(String name, Class<T> type) {
        TypeProxy old;
        TypeProxy typeProxy;
        ConcurrentMap old2;
        ConcurrentMap<String, TypeProxy<Object>> typeStorage = (ConcurrentHashMap)this.storage.get(type);
        if (typeStorage == null && (old2 = (ConcurrentMap)this.storage.putIfAbsent(type, typeStorage = new ConcurrentHashMap())) != null) {
            typeStorage = old2;
        }
        if ((typeProxy = (TypeProxy)typeStorage.get(name)) == null && (old = typeStorage.putIfAbsent(name, typeProxy = new TypeProxy(null, name))) == null) {
            this.nonVisited.push(typeProxy);
        }
        return typeProxy;
    }

    public void onNotVisitedEntries(ProxyTask proxyTask) {
        while (!this.nonVisited.isEmpty()) {
            TypeProxy proxy = this.nonVisited.pop();
            if (proxy.isVisited()) continue;
            proxyTask.on(proxy);
        }
    }

    @Override
    public Collection<Type> getAllTypes() {
        ArrayList<Type> allTypes = new ArrayList<Type>();
        for (ConcurrentMap map : this.storage.values()) {
            for (TypeProxy typeProxy : map.values()) {
                if (typeProxy.get() == null) continue;
                allTypes.add((Type)typeProxy.get());
            }
        }
        return allTypes;
    }

    public static interface ProxyTask {
        public void on(TypeProxy<?> var1);
    }
}

