/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;

public class DirectoryArchive
implements ArchiveAdapter {
    public final File directory;
    private ArrayList<InputStream> inputStreams = new ArrayList();
    public final List<ArchiveAdapter.Entry> entries = new ArrayList<ArchiveAdapter.Entry>();

    public DirectoryArchive(File directory) {
        this.directory = directory;
        this.parse(directory);
    }

    @Override
    public String getName() {
        return this.directory.getName();
    }

    @Override
    public InputStream getInputStream(String entry) throws IOException {
        File source = new File(this.directory, this.unmangle(entry));
        if (source.exists()) {
            InputStream is = Channels.newInputStream(new FileInputStream(source).getChannel());
            this.inputStreams.add(is);
            return is;
        }
        throw new IOException("Cannot find entry getName " + entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        File manifest = new File(this.directory, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifest));
            try {
                Manifest manifest2 = new Manifest(is);
                return manifest2;
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return null;
    }

    @Override
    public Iterator<ArchiveAdapter.Entry> iterator() {
        return this.entries.iterator();
    }

    private void parse(File dir) {
        for (File f : dir.listFiles()) {
            this.entries.add(new ArchiveAdapter.Entry(this.mangle(f), f.length(), f.isDirectory()));
            if (!f.isDirectory()) continue;
            this.parse(f);
        }
    }

    private String mangle(File f) {
        String relativePath = f.getAbsolutePath().substring(this.directory.getAbsolutePath().length() + 1);
        return relativePath.replace(File.separatorChar, '/');
    }

    private String unmangle(String name) {
        return name.replace('/', File.separatorChar);
    }

    @Override
    public void close() throws IOException {
        for (InputStream is : this.inputStreams) {
            is.close();
        }
        this.inputStreams.clear();
    }
}

