/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jvnet.hk2.Lexer;
import org.jvnet.hk2.Named;
import org.jvnet.hk2.OSGiConstants;

public class ExportedPackage
extends Named
implements Comparable<ExportedPackage> {
    public final Set<String> uses;
    public final String include;
    public final String version;

    ExportedPackage(Lexer sc) {
        super(sc);
        if (sc.at(OSGiConstants.INCLUDE)) {
            sc.read(OSGiConstants.INCLUDE);
            this.include = sc.readUntil(';');
        } else {
            this.include = null;
        }
        if (sc.at(OSGiConstants.USES)) {
            sc.read(OSGiConstants.USES);
            this.uses = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(sc.readUntil('\"').split(","))));
            sc.readUntil(';');
        } else {
            this.uses = Collections.emptySet();
        }
        if (sc.at(OSGiConstants.VERSION)) {
            sc.read(OSGiConstants.VERSION);
            this.version = ExportedPackage.unquote(sc.read(OSGiConstants.POSSIBLY_QUOTED_TOKEN));
        } else {
            this.version = null;
        }
        if (sc.at(',')) {
            sc.consume(",");
        }
    }

    @Override
    public int compareTo(ExportedPackage that) {
        return this.name.compareTo(that.name);
    }
}

