/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpserver.nonblockinghandler;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.io.NIOReader;
import org.glassfish.grizzly.http.io.NIOWriter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;

public class NonBlockingHttpHandlerSample {
    private static final Logger LOGGER = Grizzly.logger(NonBlockingHttpHandlerSample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HttpServer server = HttpServer.createSimpleServer();
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new NonBlockingEchoHandler(), new String[]{"/echo"});
        try {
            server.start();
            Client client = new Client();
            client.run();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
        }
        finally {
            server.shutdownNow();
        }
    }

    private static class NonBlockingEchoHandler
    extends HttpHandler {
        private NonBlockingEchoHandler() {
        }

        public void service(Request request, final Response response) throws Exception {
            final char[] buf = new char[128];
            final NIOReader in = request.getNIOReader();
            final NIOWriter out = response.getNIOWriter();
            response.suspend();
            in.notifyAvailable(new ReadHandler(){

                public void onDataAvailable() throws Exception {
                    System.out.printf("[onDataAvailable] echoing %d bytes\n", in.readyData());
                    this.echoAvailableData(in, out, buf);
                    in.notifyAvailable((ReadHandler)this);
                }

                public void onError(Throwable t) {
                    System.out.println("[onError]" + t);
                    response.resume();
                }

                public void onAllDataRead() throws Exception {
                    System.out.printf("[onAllDataRead] length: %d\n", in.readyData());
                    try {
                        this.echoAvailableData(in, out, buf);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        response.resume();
                    }
                }
            });
        }

        private void echoAvailableData(NIOReader in, NIOWriter out, char[] buf) throws IOException {
            while (in.isReady()) {
                int len = in.read(buf);
                out.write(buf, 0, len);
            }
        }
    }

    private static final class Client {
        private static final String HOST = "localhost";
        private static final int PORT = 8080;

        private Client() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            SafeFutureImpl completeFuture = SafeFutureImpl.create();
            FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
            clientFilterChainBuilder.add((Filter)new TransportFilter());
            clientFilterChainBuilder.add((Filter)new HttpClientFilter());
            clientFilterChainBuilder.add((Filter)new ClientFilter((FutureImpl<String>)completeFuture));
            TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
            transport.setProcessor((Processor)clientFilterChainBuilder.build());
            try {
                transport.start();
                Connection connection = null;
                GrizzlyFuture connectFuture = transport.connect(HOST, 8080);
                try {
                    connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
                    String result = (String)completeFuture.get(30L, TimeUnit.SECONDS);
                    System.out.println("\nEchoed POST Data: " + result + "\n");
                }
                catch (Exception e) {
                    if (connection == null) {
                        LOGGER.log(Level.WARNING, "Connection failed.  Server is not listening.");
                    } else {
                        LOGGER.log(Level.WARNING, "Unexpected error communicating with the server.");
                    }
                }
                finally {
                    if (connection != null) {
                        connection.closeSilently();
                    }
                }
            }
            finally {
                transport.shutdownNow();
            }
        }

        private static final class ClientFilter
        extends BaseFilter {
            private static final HeaderValue HOST_HEADER_VALUE = HeaderValue.newHeaderValue((String)"localhost:8080").prepare();
            private static final String[] CONTENT = new String[]{"contentA-", "contentB-", "contentC-", "contentD"};
            private final FutureImpl<String> future;
            private final StringBuilder sb = new StringBuilder();

            private ClientFilter(FutureImpl<String> future) {
                this.future = future;
            }

            public NextAction handleConnect(FilterChainContext ctx) throws IOException {
                System.out.println("\nClient connected!\n");
                HttpRequestPacket request = this.createRequest();
                System.out.println("Writing request:\n");
                System.out.println(request.toString());
                ctx.write((Object)request);
                MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
                int len = CONTENT.length;
                for (int i = 0; i < len; ++i) {
                    HttpContent.Builder contentBuilder = request.httpContentBuilder();
                    Buffer b = Buffers.wrap((MemoryManager)mm, (String)CONTENT[i]);
                    contentBuilder.content(b);
                    HttpContent content = contentBuilder.build();
                    System.out.printf("(Client writing: %s)\n", b.toStringContent());
                    ctx.write((Object)content);
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ctx.write((Object)request.httpTrailerBuilder().build());
                System.out.println("\n");
                return ctx.getStopAction();
            }

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                HttpContent c = (HttpContent)ctx.getMessage();
                Buffer b = c.getContent();
                if (b.hasRemaining()) {
                    this.sb.append(b.toStringContent());
                }
                if (c.isLast()) {
                    this.future.result((Object)this.sb.toString());
                }
                return ctx.getStopAction();
            }

            private HttpRequestPacket createRequest() {
                HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
                builder.method("POST");
                builder.protocol("HTTP/1.1");
                builder.uri("/echo");
                builder.chunked(true);
                HttpRequestPacket packet = builder.build();
                packet.addHeader(Header.Host, HOST_HEADER_VALUE);
                return packet;
            }
        }
    }
}

