/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.osgi.httpservice.OSGiCleanMapper;
import org.glassfish.grizzly.osgi.httpservice.OSGiFilterConfig;
import org.glassfish.grizzly.osgi.httpservice.OSGiHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiResourceHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletContext;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletHandler;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class OSGiMainHandler
extends HttpHandler
implements OSGiHandler {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Logger logger;
    private final Bundle bundle;
    private final OSGiCleanMapper mapper;

    public OSGiMainHandler(Logger logger, Bundle bundle) {
        this.logger = logger;
        this.bundle = bundle;
        this.mapper = new OSGiCleanMapper(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) throws Exception {
        String alias;
        boolean invoked = false;
        String originalAlias = alias = request.getDecodedRequestURI();
        this.logger.debug("Serviceing URI: " + alias);
        boolean cutOff = false;
        while (true) {
            this.logger.debug("CutOff: " + cutOff + ", alias: " + alias);
            alias = OSGiCleanMapper.map(alias, cutOff);
            if (alias == null) {
                if (cutOff) break;
                this.logger.debug("Swithcing to reducing mapping mode.");
                cutOff = true;
                alias = originalAlias;
                continue;
            }
            HttpHandler httpHandler = OSGiCleanMapper.getHttpHandler(alias);
            ((OSGiHandler)httpHandler).getProcessingLock().lock();
            try {
                this.updateMappingInfo(request, alias, originalAlias);
                httpHandler.service(request, response);
            }
            finally {
                ((OSGiHandler)httpHandler).getProcessingLock().unlock();
            }
            invoked = true;
            if (response.getStatus() != 404 || "/".equals(alias)) break;
            if (cutOff) continue;
            cutOff = true;
        }
        if (!invoked) {
            try {
                response.sendError(404);
            }
            catch (Exception e) {
                this.logger.warn("Failed to commit 404 status.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServletHandler(String alias, Servlet servlet, Dictionary initparams, HttpContext context, HttpService httpService) throws NamespaceException, ServletException {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            this.validateAlias4RegOk(alias);
            this.validateServlet4RegOk(servlet);
            if (context == null) {
                this.logger.debug("No HttpContext provided, creating default");
                context = httpService.createDefaultHttpContext();
            }
            OSGiServletHandler servletHandler = this.findOrCreateOSGiServletHandler(servlet, context, initparams);
            servletHandler.setServletPath(alias);
            this.logger.debug("Initializing Servlet been registered");
            servletHandler.startServlet();
            this.mapper.addHttpHandler(alias, (HttpHandler)servletHandler);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFilter(Filter filter, String urlPattern, Dictionary initparams, HttpContext context, HttpService httpService) throws ServletException {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            OSGiServletContext servletContext;
            if (context == null) {
                this.logger.debug("No HttpContext provided, creating default");
                context = httpService.createDefaultHttpContext();
            }
            if ((servletContext = this.mapper.getServletContext(context)) == null) {
                this.mapper.addContext(context, null);
                servletContext = this.mapper.getServletContext(context);
            }
            FilterRegistration registration = servletContext.addFilter(Integer.toString(filter.hashCode()), filter);
            registration.addMappingForUrlPatterns(null, new String[]{urlPattern});
            filter.init((FilterConfig)((Object)new OSGiFilterConfig(servletContext)));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceHandler(String alias, HttpContext context, String internalPrefix, HttpService httpService) throws NamespaceException {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            OSGiServletContext servletContext;
            this.validateAlias4RegOk(alias);
            if (context == null) {
                this.logger.debug("No HttpContext provided, creating default");
                context = httpService.createDefaultHttpContext();
            }
            if (internalPrefix == null) {
                internalPrefix = "";
            }
            if ((servletContext = this.mapper.getServletContext(context)) == null) {
                this.mapper.addContext(context, null);
                servletContext = this.mapper.getServletContext(context);
            }
            this.mapper.addHttpHandler(alias, new OSGiResourceHandler(alias, internalPrefix, context, servletContext, this.logger));
        }
        finally {
            lock.unlock();
        }
    }

    public void unregisterAlias(String alias) {
        block4: {
            ReentrantLock lock = OSGiCleanMapper.getLock();
            lock.lock();
            try {
                if (this.mapper.isLocalyRegisteredAlias(alias)) {
                    this.mapper.doUnregister(alias, true);
                    break block4;
                }
                this.logger.warn("Bundle: " + this.bundle + " tried to unregister not owned alias '" + alias + "'");
                throw new IllegalArgumentException("Alias '" + alias + "' was not registered by you.");
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFilter(Filter filter) {
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            for (OSGiServletContext servletContext : this.mapper.httpContextToServletContextMap.values()) {
                servletContext.unregisterFilter(filter);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uregisterAllLocal() {
        this.logger.info("Unregistering all aliases registered by owning bundle");
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            for (String alias : this.mapper.getLocalAliases()) {
                this.logger.debug("Unregistering '" + alias + "'");
                this.mapper.doUnregister(alias, false);
                for (OSGiServletContext servletContext : this.mapper.httpContextToServletContextMap.values()) {
                    servletContext.unregisterAllFilters();
                }
                this.mapper.httpContextToServletContextMap.clear();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        this.logger.info("Unregistering all registered aliases");
        ReentrantLock lock = OSGiCleanMapper.getLock();
        lock.lock();
        try {
            Set<String> aliases = OSGiCleanMapper.getAllAliases();
            while (!aliases.isEmpty()) {
                String alias = (String)((TreeSet)aliases).first();
                this.logger.debug("Unregistering '" + alias + "'");
                this.mapper.doUnregister(alias, false);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getProcessingLock() {
        return this.lock.readLock();
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getRemovalLock() {
        return this.lock.writeLock();
    }

    private void validateAlias4RegOk(String alias) throws NamespaceException {
        if (!alias.startsWith("/")) {
            String msg = "Invalid alias '" + alias + "', have to start with '/'.";
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            String msg = "Alias '" + alias + "' can't and with '/' with exception to alias '/'.";
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
        if (OSGiCleanMapper.containsAlias(alias)) {
            String msg = "Alias: '" + alias + "', already registered";
            this.logger.warn(msg);
            throw new NamespaceException(msg);
        }
    }

    private void validateServlet4RegOk(Servlet servlet) throws ServletException {
        if (OSGiCleanMapper.containsServlet(servlet)) {
            String msg = "Servlet: '" + servlet + "', already registered.";
            this.logger.warn(msg);
            throw new ServletException(msg);
        }
    }

    private OSGiServletHandler findOrCreateOSGiServletHandler(Servlet servlet, HttpContext httpContext, Dictionary initparams) {
        OSGiServletHandler osgiServletHandler;
        List<OSGiServletHandler> servletHandlers = this.mapper.getContext(httpContext);
        if (servletHandlers != null) {
            this.logger.debug("Reusing ServletHandler");
            osgiServletHandler = servletHandlers.get(0).newServletHandler(servlet);
            servletHandlers.add(osgiServletHandler);
        } else {
            HashMap<String, String> params;
            this.logger.debug("Creating new ServletHandler");
            if (initparams != null) {
                params = new HashMap(initparams.size());
                Enumeration names = initparams.keys();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    params.put(name, (String)initparams.get(name));
                }
            } else {
                params = new HashMap<String, String>(0);
            }
            servletHandlers = new ArrayList<OSGiServletHandler>(1);
            this.mapper.addContext(httpContext, this.mapper.getServletContext(httpContext), servletHandlers);
            OSGiServletContext servletContext = this.mapper.getServletContext(httpContext);
            assert (servletContext != null);
            osgiServletHandler = new OSGiServletHandler(servlet, httpContext, servletContext, params, this.logger);
            servletHandlers.add(osgiServletHandler);
            osgiServletHandler.setFilterChainFactory(servletContext.getFilterChainFactory());
        }
        return osgiServletHandler;
    }

    private void updateMappingInfo(Request request, String alias, String originalAlias) {
        MappingData mappingData = request.obtainMappingData();
        mappingData.contextPath.setString("");
        if (alias.equals("/")) {
            mappingData.wrapperPath.setString("");
        } else {
            mappingData.wrapperPath.setString(alias);
        }
        if (alias.length() != originalAlias.length()) {
            Object pathInfo = originalAlias.substring(alias.length());
            if (((String)pathInfo).charAt(0) != '/') {
                pathInfo = "/" + (String)pathInfo;
            }
            mappingData.pathInfo.setString((String)pathInfo);
        }
        OSGiMainHandler.updatePaths((Request)request, (MappingData)mappingData);
    }
}

