/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public final class Acl {
    public static final int GET = 1;
    public static final int ADD = 2;
    public static final int REPLACE = 4;
    public static final int DELETE = 8;
    public static final int EXEC = 16;
    public static final int ALL_PERMISSION = 31;
    private static final int[] PERMISSION_CODES = new int[]{2, 8, 16, 1, 4};
    private static final String[] PERMISSION_NAMES = new String[]{"Add", "Delete", "Exec", "Get", "Replace"};
    private static final String ALL_PRINCIPALS = "*";
    private final TreeMap principalPermissions;
    private final int globalPermissions;

    public Acl(String acl) {
        if (acl == null || acl.equals("")) {
            this.principalPermissions = new TreeMap();
            this.globalPermissions = 0;
            return;
        }
        TreeMap<String, Integer> tempPrincipalPermissions = new TreeMap<String, Integer>();
        int tempGlobalPermissions = 0;
        String[] aclEntries = Acl.split(acl, '&', -1);
        for (int i = 0; i < aclEntries.length; ++i) {
            if (aclEntries[i].length() == 0) {
                throw new IllegalArgumentException("Invalid ACL string: empty ACL entry.");
            }
            String[] entryParts = Acl.split(aclEntries[i], '=', 2);
            if (entryParts.length == 1) {
                throw new IllegalArgumentException("Invalid ACL string: no '=' in ACL entry.");
            }
            if (entryParts[1].length() == 0) {
                throw new IllegalArgumentException("Invalid ACL string: no server identifiers in ACL entry.");
            }
            int command = Acl.parseCommand(entryParts[0]);
            String[] serverIds = Acl.split(entryParts[1], '+', -1);
            for (int j = 0; j < serverIds.length; ++j) {
                if (serverIds[j].length() == 0) {
                    throw new IllegalArgumentException("Invalid ACL string: empty server identifier.");
                }
                if (serverIds[j].equals(ALL_PRINCIPALS)) {
                    tempGlobalPermissions |= command;
                    continue;
                }
                Acl.checkServerId(serverIds[j], "Invalid ACL string: server ID contains illegal character");
                Integer n = (Integer)tempPrincipalPermissions.get(serverIds[j]);
                int oldPermission = n != null ? n : 0;
                tempPrincipalPermissions.put(serverIds[j], new Integer(oldPermission | command));
            }
        }
        this.principalPermissions = tempPrincipalPermissions;
        this.globalPermissions = tempGlobalPermissions;
    }

    public Acl(String[] principals, int[] permissions) {
        if (principals.length != permissions.length) {
            throw new IllegalArgumentException("The lengths of the principal and permission arrays are not the same.");
        }
        TreeMap<String, Integer> tempPrincipalPermissions = new TreeMap<String, Integer>();
        int tempGlobalPermissions = 0;
        for (int i = 0; i < principals.length; ++i) {
            if (!ALL_PRINCIPALS.equals(principals[i])) {
                Acl.checkPrincipal(principals[i]);
            }
            Acl.checkPermissions(permissions[i]);
            Integer permInt = new Integer(permissions[i]);
            Integer old = tempPrincipalPermissions.put(principals[i], permInt);
            if (old == null) continue;
            throw new IllegalArgumentException("Principal '" + principals[i] + "' appears multiple times in the principal array.");
        }
        Object globalPermObj = tempPrincipalPermissions.remove(ALL_PRINCIPALS);
        if (globalPermObj != null) {
            tempGlobalPermissions = (Integer)globalPermObj;
        }
        this.principalPermissions = tempPrincipalPermissions;
        this.globalPermissions = tempGlobalPermissions;
    }

    private Acl(Acl base, String principal, int permissions) {
        TreeMap tempPrincipalPermissions = (TreeMap)base.principalPermissions.clone();
        int tempGlobalPermissions = base.globalPermissions;
        int deletedGlobalPerm = tempGlobalPermissions & ~permissions;
        if (ALL_PRINCIPALS.equals(principal)) {
            Acl.deleteFromAll(tempPrincipalPermissions, deletedGlobalPerm);
            tempGlobalPermissions = permissions;
        } else {
            Acl.checkPrincipal(principal);
            if (deletedGlobalPerm != 0) {
                throw new IllegalArgumentException("Cannot revoke globally set permissions (" + Acl.writeCommands(deletedGlobalPerm) + ") from a specific principal (" + principal + ").");
            }
            Acl.setPrincipalPermission(tempPrincipalPermissions, principal, permissions);
        }
        this.principalPermissions = tempPrincipalPermissions;
        this.globalPermissions = tempGlobalPermissions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Acl)) {
            return false;
        }
        Acl other = (Acl)obj;
        if (this.globalPermissions != other.globalPermissions || this.principalPermissions.size() != other.principalPermissions.size()) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public synchronized Acl addPermission(String principal, int permissions) {
        Acl.checkPermissions(permissions);
        int oldPermissions = this.getPermissions(principal);
        return this.setPermission(principal, oldPermissions | permissions);
    }

    public synchronized Acl deletePermission(String principal, int permissions) {
        Acl.checkPermissions(permissions);
        int oldPermissions = this.getPermissions(principal);
        return this.setPermission(principal, oldPermissions & ~permissions);
    }

    public synchronized int getPermissions(String principal) {
        int permissions = 0;
        if (!ALL_PRINCIPALS.equals(principal)) {
            Acl.checkPrincipal(principal);
            Object po = this.principalPermissions.get(principal);
            if (po != null) {
                permissions = (Integer)po;
            }
        }
        return permissions | this.globalPermissions;
    }

    public synchronized boolean isPermitted(String principal, int permissions) {
        Acl.checkPermissions(permissions);
        int hasPermissions = this.getPermissions(principal);
        return (permissions & hasPermissions) == permissions;
    }

    public synchronized Acl setPermission(String principal, int permissions) {
        Acl.checkPermissions(permissions);
        Acl newPermission = new Acl(this, principal, permissions);
        return newPermission;
    }

    public String[] getPrincipals() {
        return this.principalPermissions.keySet().toArray(new String[0]);
    }

    public synchronized String toString() {
        String acl = null;
        for (int i = 0; i < PERMISSION_CODES.length; ++i) {
            acl = this.writeEntry(PERMISSION_CODES[i], acl);
        }
        return acl != null ? acl : "";
    }

    private String writeEntry(int command, String acl) {
        String aclEntry = null;
        if ((command & this.globalPermissions) > 0) {
            aclEntry = ALL_PRINCIPALS;
        } else {
            for (Map.Entry entry : this.principalPermissions.entrySet()) {
                if ((command & (Integer)entry.getValue()) <= 0) continue;
                aclEntry = Acl.appendEntry(aclEntry, '+', (String)entry.getKey());
            }
        }
        if (aclEntry == null) {
            return acl;
        }
        return Acl.appendEntry(acl, '&', Acl.writeCommands(command) + '=' + aclEntry);
    }

    private static void deleteFromAll(TreeMap principalPermissions, int perm) {
        for (Map.Entry entry : principalPermissions.entrySet()) {
            Acl.setPrincipalPermission(principalPermissions, (String)entry.getKey(), (Integer)entry.getValue() & ~perm);
        }
    }

    private static void setPrincipalPermission(TreeMap principalPermissions, String principal, int perm) {
        if (perm == 0) {
            principalPermissions.remove(principal);
        } else {
            principalPermissions.put(principal, new Integer(perm));
        }
    }

    private static String writeCommands(int command) {
        String commandStr = null;
        for (int i = 0; i < PERMISSION_CODES.length; ++i) {
            if ((command & PERMISSION_CODES[i]) == 0) continue;
            commandStr = Acl.appendEntry(commandStr, ',', PERMISSION_NAMES[i]);
        }
        return commandStr != null ? commandStr : "";
    }

    private static String appendEntry(String base, char separator, String entry) {
        return base != null ? base + separator + entry : entry;
    }

    private static int parseCommand(String command) {
        int i = Arrays.asList(PERMISSION_NAMES).indexOf(command);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid ACL string: unknown command '" + command + "'.");
        }
        return PERMISSION_CODES[i];
    }

    private static void checkPermissions(int perm) {
        if ((perm & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("Invalid ACL permission value: " + perm);
        }
    }

    private static void checkPrincipal(String principal) {
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException("Principal is null or empty.");
        }
        Acl.checkServerId(principal, "Principal name contains illegal character");
    }

    private static void checkServerId(String serverId, String errorText) {
        char[] chars = serverId.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ("*=+&".indexOf(chars[i]) == -1 && !Character.isWhitespace(chars[i])) continue;
            throw new IllegalArgumentException(errorText + " '" + chars[i] + "'.");
        }
    }

    private static String[] split(String input, char sep, int limit) {
        char ch;
        int index;
        Vector<String> v = new Vector<String>();
        boolean limited = limit > 0;
        int applied = 0;
        StringBuffer part = new StringBuffer();
        for (index = 0; index < input.length(); ++index) {
            ch = input.charAt(index);
            if (ch != sep) {
                part.append(ch);
                continue;
            }
            ++applied;
            v.add(part.toString());
            part = new StringBuffer();
            if (!limited || applied != limit - 1) continue;
            break;
        }
        while (index < input.length()) {
            ch = input.charAt(index);
            part.append(ch);
            ++index;
        }
        v.add(part.toString());
        int last = v.size();
        if (0 == limit) {
            String s;
            for (int j = v.size() - 1; j >= 0 && "".equals(s = (String)v.elementAt(j)); --j) {
                --last;
            }
        }
        String[] ret = new String[last];
        for (int i = 0; i < last; ++i) {
            ret[i] = (String)v.elementAt(i);
        }
        return ret;
    }
}

