/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.service.dmt.security.DmtPermission;

final class DmtPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -4172481774562012941L;
    private ArrayList perms = new ArrayList();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof DmtPermission)) {
            throw new IllegalArgumentException("Cannot add permission, invalid permission type: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add permission, collection is marked read-only.");
        }
        this.perms.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPermission)) {
            return false;
        }
        DmtPermission other = (DmtPermission)permission;
        int required = other.getMask();
        int available = 0;
        int needed = required;
        for (DmtPermission p : this.perms) {
            if ((needed & p.getMask()) == 0 || !p.impliesPath(other)) continue;
            if (((available |= p.getMask()) & required) == required) {
                return true;
            }
            needed = required ^ available;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

