/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.osgi.service.dmt.security.AlertPermission;

final class DmtAlertPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 2288462124510043429L;
    private ArrayList perms = new ArrayList();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof AlertPermission)) {
            throw new IllegalArgumentException("Cannot add permission, invalid permission type: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add permission, collection is marked read-only.");
        }
        if (!this.implies(permission)) {
            Iterator i = this.perms.iterator();
            while (i.hasNext()) {
                if (!permission.implies((AlertPermission)i.next())) continue;
                i.remove();
            }
            this.perms.add(permission);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof AlertPermission)) {
            return false;
        }
        AlertPermission other = (AlertPermission)permission;
        Iterator i = this.perms.iterator();
        while (i.hasNext()) {
            if (!((AlertPermission)i.next()).impliesServer(other)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

