/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.osgi.httpservice.HttpServiceImpl;
import org.glassfish.grizzly.osgi.httpservice.OSGiMainHandler;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class HttpServiceFactory
implements ServiceFactory {
    private final Logger logger;
    private final OSGiMainHandler mainHttpHandler;

    public HttpServiceFactory(HttpServer httpServer, Logger logger, Bundle bundle) {
        this.logger = logger;
        this.mainHttpHandler = new OSGiMainHandler(logger, bundle);
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)this.mainHttpHandler, new String[]{"/"});
    }

    public HttpService getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        this.logger.info("Bundle: " + bundle + ", is getting HttpService with serviceRegistration: " + serviceRegistration);
        return new HttpServiceImpl(bundle, this.logger);
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object httpServiceObj) {
        this.logger.info("Bundle: " + bundle + ", is ungetting HttpService with serviceRegistration: " + serviceRegistration);
        this.mainHttpHandler.uregisterAllLocal();
    }

    public void stop() {
        this.logger.info("Stoping main handler");
        this.mainHttpHandler.unregisterAll();
    }
}

