/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.glassfish.grizzly.comet.CometAddOn;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.osgi.httpservice.HttpServiceExtension;
import org.glassfish.grizzly.osgi.httpservice.HttpServiceFactory;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker logTracker;
    private ServiceRegistration httpServiceRegistration;
    private ServiceRegistration extServiceRegistration;
    private Logger logger;
    private HttpServer httpServer;
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String ORG_OSGI_SERVICE_HTTPS_PORT = "org.osgi.service.http.port.secure";
    private HttpServiceFactory serviceFactory;
    private static final String GRIZZLY_COMET_SUPPORT = "org.glassfish.grizzly.cometSupport";
    private static final String GRIZZLY_WEBSOCKETS_SUPPORT = "org.glassfish.grizzly.websocketsSupport";

    public void start(BundleContext bundleContext) throws Exception {
        this.logTracker = new ServiceTracker(bundleContext, LogService.class.getName(), null);
        this.logTracker.open();
        this.logger = new Logger(this.logTracker);
        this.logger.info("Starting Grizzly OSGi HttpService");
        int port = this.readProperty(bundleContext, ORG_OSGI_SERVICE_HTTP_PORT, 80);
        if (bundleContext.getProperty(ORG_OSGI_SERVICE_HTTPS_PORT) != null) {
            this.logger.warn("HTTPS not supported yet.");
        }
        boolean cometEnabled = this.readProperty(bundleContext, GRIZZLY_COMET_SUPPORT, false);
        boolean websocketsEnabled = this.readProperty(bundleContext, GRIZZLY_WEBSOCKETS_SUPPORT, false);
        this.startGrizzly(port, cometEnabled, websocketsEnabled);
        this.serviceFactory = new HttpServiceFactory(this.httpServer, this.logger, bundleContext.getBundle());
        this.httpServiceRegistration = bundleContext.registerService(HttpService.class.getName(), (Object)this.serviceFactory, (Dictionary)new Properties());
        this.extServiceRegistration = bundleContext.registerService(HttpServiceExtension.class.getName(), (Object)this.serviceFactory, (Dictionary)new Properties());
    }

    private <T> T readProperty(BundleContext ctx, String name, T defValue) {
        String value = ctx.getProperty(name);
        if (value != null) {
            if (defValue instanceof Integer) {
                try {
                    return (T)Integer.valueOf(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    this.logger.info("Couldn't parse '" + name + "' property, going to use default (" + defValue + "). " + e.getMessage());
                }
            } else if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(value));
            }
            return (T)value;
        }
        return defValue;
    }

    private void startGrizzly(int port, boolean cometEnabled, boolean websocketsEnabled) throws IOException {
        this.httpServer = new HttpServer();
        NetworkListener networkListener = new NetworkListener("osgi-listener", "0.0.0.0", port);
        System.out.println("PORT=" + port);
        if (cometEnabled) {
            this.logger.info("Enabling Comet.");
            networkListener.registerAddOn((AddOn)new CometAddOn());
        }
        if (websocketsEnabled) {
            this.logger.info("Enabling WebSockets.");
            networkListener.registerAddOn((AddOn)new WebSocketAddOn());
        }
        this.httpServer.addListener(networkListener);
        this.httpServer.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.logger.info("Stopping Grizzly OSGi HttpService");
        this.serviceFactory.stop();
        if (this.httpServiceRegistration != null) {
            this.httpServiceRegistration.unregister();
        }
        if (this.extServiceRegistration != null) {
            this.extServiceRegistration.unregister();
        }
        this.httpServer.shutdownNow();
        this.logTracker.close();
    }
}

