/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.osgi.httpservice.OSGiAuthFilter;
import org.glassfish.grizzly.osgi.httpservice.OSGiFilterConfig;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.glassfish.grizzly.servlet.FilterChainFactory;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.osgi.service.http.HttpContext;

public class OSGiServletContext
extends WebappContext {
    private final HttpContext httpContext;
    private final Logger logger;

    public OSGiServletContext(HttpContext httpContext, Logger logger) {
        this.httpContext = httpContext;
        this.logger = logger;
        this.installAuthFilter(httpContext);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        return this.httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        URL resource = this.httpContext.getResource(path);
        if (resource == null) {
            this.logger.warn(MessageFormat.format("Error getting resource ''{0}''. Message: {1}", path, "Can't locate resource."));
            return null;
        }
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            this.logger.warn(MessageFormat.format("Error getting resource ''{0}''. Message: {1}", path, e.getMessage()));
            return null;
        }
    }

    public String getMimeType(String file) {
        String mime = this.httpContext.getMimeType(file);
        if (mime == null) {
            mime = MimeType.getByFilename((String)file);
        }
        return mime;
    }

    protected EventListener[] getEventListeners() {
        return super.getEventListeners();
    }

    protected FilterChainFactory getFilterChainFactory() {
        return super.getFilterChainFactory();
    }

    protected void unregisterFilter(Filter f) {
        super.unregisterFilter(f);
    }

    protected void unregisterAllFilters() {
        super.unregisterAllFilters();
    }

    private void installAuthFilter(HttpContext httpContext) {
        OSGiAuthFilter f = new OSGiAuthFilter(httpContext);
        try {
            f.init((FilterConfig)((Object)new OSGiFilterConfig(this)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        FilterRegistration registration = this.addFilter(Integer.toString(f.hashCode()), f);
        registration.addMappingForUrlPatterns(null, new String[]{"/*"});
    }
}

