/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.osgi.httpservice.OSGiHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletContext;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.osgi.service.http.HttpContext;

public class OSGiResourceHandler
extends HttpHandler
implements OSGiHandler {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String alias;
    private final String prefix;
    private final HttpContext httpContext;
    private final OSGiServletContext servletContext;
    private final Logger logger;

    public OSGiResourceHandler(String alias, String prefix, HttpContext httpContext, OSGiServletContext servletContext, Logger logger) {
        this.alias = alias;
        this.prefix = prefix;
        this.httpContext = httpContext;
        this.servletContext = servletContext;
        this.logger = logger;
    }

    public void service(Request request, Response response) throws Exception {
        String requestURI = request.getDecodedRequestURI();
        this.logger.debug("OSGiResourceHandler requestURI: " + requestURI);
        String path = requestURI.replaceFirst(this.alias, this.prefix);
        try {
            if (!this.authenticate(request, response, this.servletContext)) {
                this.logger.debug("OSGiResourceHandler Request not authenticated (" + requestURI + ").");
                return;
            }
        }
        catch (IOException e) {
            this.logger.warn("Error while authenticating request: " + request, e);
        }
        URL resource = this.httpContext.getResource(path);
        if (resource == null) {
            this.logger.debug("OSGiResourceHandler '" + this.alias + "' Haven't found '" + path + "'.");
            response.setStatus(404);
            return;
        }
        response.setStatus(200);
        String mime = this.httpContext.getMimeType(path);
        if (mime == null) {
            mime = MimeType.getByFilename((String)path);
        }
        if (mime != null) {
            response.setContentType(mime);
        }
        try {
            int read;
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            InputStream is = urlConnection.getInputStream();
            OutputStream os = response.getOutputStream();
            byte[] buff = new byte[8192];
            int total = 0;
            while ((read = is.read(buff)) != -1) {
                total += read;
                os.write(buff, 0, read);
            }
            os.flush();
            response.finish();
            if (total != length) {
                this.logger.warn("Was supposed to send " + length + ", but sent " + total);
            }
        }
        catch (IOException e) {
            this.logger.warn("", e);
        }
    }

    private boolean authenticate(Request request, Response response, OSGiServletContext servletContext) throws IOException {
        OSGiHttpServletRequest servletRequest = new OSGiHttpServletRequest(servletContext);
        HttpServletResponseImpl servletResponse = HttpServletResponseImpl.create();
        servletResponse.initialize(response, (HttpServletRequestImpl)servletRequest);
        servletRequest.initialize(request, servletResponse, servletContext);
        return this.httpContext.handleSecurity((HttpServletRequest)((Object)servletRequest), (HttpServletResponse)servletResponse);
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getProcessingLock() {
        return this.lock.readLock();
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getRemovalLock() {
        return this.lock.writeLock();
    }

    private static class OSGiHttpServletRequest
    extends HttpServletRequestImpl {
        public OSGiHttpServletRequest(OSGiServletContext context) throws IOException {
            this.setContextImpl(context);
        }
    }
}

