/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.dmt.security.DmtPrincipalPermissionCollection;

public class DmtPrincipalPermission
extends Permission {
    private static final long serialVersionUID = 6388752177325038332L;
    private final boolean isPrefix;
    private final String principal;

    public DmtPrincipalPermission(String target) {
        super(target);
        if (target == null) {
            throw new NullPointerException("'target' parameter must not be null.");
        }
        if (target.equals("")) {
            throw new IllegalArgumentException("'target' parameter must not be empty.");
        }
        this.isPrefix = target.endsWith("*");
        this.principal = this.isPrefix ? target.substring(0, target.length() - 1) : target;
    }

    public DmtPrincipalPermission(String target, String actions) {
        this(target);
        if (actions == null) {
            throw new NullPointerException("'actions' parameter must not be null.");
        }
        if (!actions.equals("*")) {
            throw new IllegalArgumentException("'actions' parameter must be \"*\".");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission other = (DmtPrincipalPermission)obj;
        return this.isPrefix == other.isPrefix && this.principal.equals(other.principal);
    }

    @Override
    public String getActions() {
        return "*";
    }

    @Override
    public int hashCode() {
        return new Boolean(this.isPrefix).hashCode() ^ this.principal.hashCode();
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission other = (DmtPrincipalPermission)p;
        return this.impliesPrincipal(other);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DmtPrincipalPermissionCollection();
    }

    boolean impliesPrincipal(DmtPrincipalPermission p) {
        return this.isPrefix ? p.principal.startsWith(this.principal) : !p.isPrefix && p.principal.equals(this.principal);
    }
}

