/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.io.PrintStream;
import java.util.Vector;
import org.osgi.service.dmt.Uri;

public class DmtException
extends Exception {
    private static final long serialVersionUID = -63006267148118655L;
    public static final int UNAUTHORIZED = 401;
    public static final int NODE_NOT_FOUND = 404;
    public static final int COMMAND_NOT_ALLOWED = 405;
    public static final int FEATURE_NOT_SUPPORTED = 406;
    public static final int LIMIT_EXCEEDED = 413;
    public static final int URI_TOO_LONG = 414;
    public static final int NODE_ALREADY_EXISTS = 418;
    public static final int PERMISSION_DENIED = 425;
    public static final int COMMAND_FAILED = 500;
    public static final int DATA_STORE_FAILURE = 510;
    public static final int ROLLBACK_FAILED = 516;
    public static final int REMOTE_ERROR = 1;
    public static final int METADATA_MISMATCH = 2;
    public static final int INVALID_URI = 3;
    public static final int CONCURRENT_ACCESS = 4;
    public static final int ALERT_NOT_ROUTED = 5;
    public static final int TRANSACTION_ERROR = 6;
    public static final int SESSION_CREATION_TIMEOUT = 7;
    private final String uri;
    private final int code;
    private final String message;
    private final Throwable[] causes;
    private final boolean fatal;

    public DmtException(String uri, int code, String message) {
        this(uri, code, message, new Throwable[0], false);
    }

    public DmtException(String uri, int code, String message, Throwable cause) {
        Throwable[] throwableArray;
        if (cause == null) {
            throwableArray = new Throwable[]{};
        } else {
            Throwable[] throwableArray2 = new Throwable[1];
            throwableArray = throwableArray2;
            throwableArray2[0] = cause;
        }
        this(uri, code, message, throwableArray, false);
    }

    public DmtException(String uri, int code, String message, Vector causes, boolean fatal) {
        this(uri, code, message, causes == null ? new Throwable[]{} : causes.toArray(new Throwable[causes.size()]), fatal);
    }

    private DmtException(String uri, int code, String message, Throwable[] causes, boolean fatal) {
        super((Throwable)null);
        this.uri = uri;
        this.code = code;
        this.message = message;
        this.causes = causes;
        this.fatal = fatal;
    }

    public DmtException(String[] path, int code, String message) {
        this(DmtException.pathToUri(path), code, message);
    }

    public DmtException(String[] path, int code, String message, Throwable cause) {
        this(DmtException.pathToUri(path), code, message, cause);
    }

    public DmtException(String[] path, int code, String message, Vector causes, boolean fatal) {
        this(DmtException.pathToUri(path), code, message, causes, fatal);
    }

    public String getURI() {
        return this.uri;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer(DmtException.getCodeText(this.code));
        if (this.uri != null) {
            sb.append(": '").append(this.uri).append('\'');
        }
        if (this.message != null) {
            sb.append(": ").append(this.message);
        }
        return sb.toString();
    }

    @Override
    public Throwable getCause() {
        return this.causes.length == 0 ? null : this.causes[0];
    }

    public Throwable[] getCauses() {
        return (Throwable[])this.causes.clone();
    }

    public boolean isFatal() {
        return this.fatal;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        for (int i = 0; i < this.causes.length; ++i) {
            s.print("Caused by" + (String)(i > 0 ? " (" + (i + 1) + ")" : "") + ": ");
            this.causes[i].printStackTrace(s);
        }
    }

    static String pathToUri(String[] path) {
        if (path == null) {
            return null;
        }
        return Uri.toUri(path);
    }

    private static String getCodeText(int code) {
        switch (code) {
            case 404: {
                return "NODE_NOT_FOUND";
            }
            case 405: {
                return "COMMAND_NOT_ALLOWED";
            }
            case 406: {
                return "FEATURE_NOT_SUPPORTED";
            }
            case 414: {
                return "URI_TOO_LONG";
            }
            case 418: {
                return "NODE_ALREADY_EXISTS";
            }
            case 425: {
                return "PERMISSION_DENIED";
            }
            case 500: {
                return "COMMAND_FAILED";
            }
            case 510: {
                return "DATA_STORE_FAILURE";
            }
            case 516: {
                return "ROLLBACK_FAILED";
            }
            case 1: {
                return "REMOTE_ERROR";
            }
            case 2: {
                return "METADATA_MISMATCH";
            }
            case 3: {
                return "INVALID_URI";
            }
            case 4: {
                return "CONCURRENT_ACCESS";
            }
            case 5: {
                return "ALERT_NOT_ROUTED";
            }
            case 6: {
                return "TRANSACTION_ERROR";
            }
            case 7: {
                return "SESSION_CREATION_TIMEOUT";
            }
        }
        return "<unknown code>";
    }
}

