/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.BaseWebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.slf4j.Logger;

public class WebSocketClientFilter
extends BaseWebSocketFilter {
    private static final Logger LOGGER = Grizzly.logger(WebSocketClientFilter.class);

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        LOGGER.trace("handleConnect");
        Connection connection = ctx.getConnection();
        if (!WebSocketClientFilter.webSocketInProgress(connection)) {
            return ctx.getInvokeAction();
        }
        WebSocketHolder.get((Connection)connection).handshake.initiate(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    protected NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return WebSocketClientFilter.handleClientHandShake(ctx, content);
    }

    private static NextAction handleClientHandShake(FilterChainContext ctx, HttpContent content) {
        WebSocketHolder holder = WebSocketHolder.get(ctx.getConnection());
        holder.handshake.validateServerResponse((HttpResponsePacket)content.getHttpHeader());
        holder.webSocket.onConnect();
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }
}

