/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Futures;
import org.slf4j.Logger;

public class SSLBaseFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(SSLBaseFilter.class);
    protected static final MessageCloner<Buffer> COPY_CLONER = new OnWriteCopyCloner();
    private static final SSLConnectionContext.Allocator MM_ALLOCATOR = new SSLConnectionContext.Allocator(){

        @Override
        public Buffer grow(SSLConnectionContext sslCtx, Buffer oldBuffer, int newSize) {
            MemoryManager<?> mm = sslCtx.getConnection().getMemoryManager();
            return oldBuffer == null ? mm.allocate(newSize) : mm.reallocate(oldBuffer, newSize);
        }
    };
    private static final SSLConnectionContext.Allocator OUTPUT_BUFFER_ALLOCATOR = new SSLConnectionContext.Allocator(){

        @Override
        public Buffer grow(SSLConnectionContext sslCtx, Buffer oldBuffer, int newSize) {
            return SSLUtils.allocateOutputBuffer(newSize);
        }
    };
    private final SSLEngineConfigurator serverSSLEngineConfigurator;
    private final boolean renegotiateOnClientAuthWant;
    private volatile boolean renegotiationDisabled;
    protected final Set<HandshakeListener> handshakeListeners = Collections.newSetFromMap(DataStructures.getConcurrentMap(2));
    private long handshakeTimeoutMillis = -1L;
    private SSLTransportFilterWrapper optimizedTransportFilter;

    public SSLBaseFilter() {
        this(null);
    }

    public SSLBaseFilter(SSLEngineConfigurator serverSSLEngineConfigurator) {
        this(serverSSLEngineConfigurator, true);
    }

    public SSLBaseFilter(SSLEngineConfigurator serverSSLEngineConfigurator, boolean renegotiateOnClientAuthWant) {
        this.renegotiateOnClientAuthWant = renegotiateOnClientAuthWant;
        this.serverSSLEngineConfigurator = serverSSLEngineConfigurator != null ? serverSSLEngineConfigurator : new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(true), false, false, false);
    }

    public boolean isRenegotiateOnClientAuthWant() {
        return this.renegotiateOnClientAuthWant;
    }

    public SSLEngineConfigurator getServerSSLEngineConfigurator() {
        return this.serverSSLEngineConfigurator;
    }

    public void addHandshakeListener(HandshakeListener listener) {
        this.handshakeListeners.add(listener);
    }

    public void removeHandshakeListener(HandshakeListener listener) {
        this.handshakeListeners.remove(listener);
    }

    public long getHandshakeTimeout(TimeUnit timeUnit) {
        if (this.handshakeTimeoutMillis < 0L) {
            return -1L;
        }
        return timeUnit.convert(this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit timeUnit) {
        this.handshakeTimeoutMillis = handshakeTimeout < 0L ? -1L : TimeUnit.MILLISECONDS.convert(handshakeTimeout, timeUnit);
    }

    public void setRenegotiationDisabled(boolean renegotiationDisabled) {
        this.renegotiationDisabled = renegotiationDisabled;
    }

    protected SSLTransportFilterWrapper getOptimizedTransportFilter(TransportFilter childFilter) {
        if (this.optimizedTransportFilter == null || this.optimizedTransportFilter.wrappedFilter != childFilter) {
            this.optimizedTransportFilter = this.createOptimizedTransportFilter(childFilter);
        }
        return this.optimizedTransportFilter;
    }

    protected SSLTransportFilterWrapper createOptimizedTransportFilter(TransportFilter childFilter) {
        return new SSLTransportFilterWrapper(childFilter, this);
    }

    @Override
    public void onRemoved(FilterChain filterChain) {
        int sslTransportFilterIdx;
        if (this.optimizedTransportFilter != null && (sslTransportFilterIdx = filterChain.indexOf(this.optimizedTransportFilter)) >= 0) {
            SSLTransportFilterWrapper wrapper = (SSLTransportFilterWrapper)filterChain.get(sslTransportFilterIdx);
            filterChain.set(sslTransportFilterIdx, wrapper.wrappedFilter);
        }
    }

    @Override
    public void onAdded(FilterChain filterChain) {
        int transportFilterIdx;
        int sslTransportFilterIdx = filterChain.indexOfType(SSLTransportFilterWrapper.class);
        if (sslTransportFilterIdx == -1 && (transportFilterIdx = filterChain.indexOfType(TransportFilter.class)) >= 0) {
            filterChain.set(transportFilterIdx, this.getOptimizedTransportFilter((TransportFilter)filterChain.get(transportFilterIdx)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == "CERT_EVENT") {
            CertificateEvent ce = (CertificateEvent)event;
            try {
                NextAction nextAction = ctx.getSuspendAction();
                return nextAction;
            }
            finally {
                this.getPeerCertificateChain(this.obtainSslConnectionContext(ctx.getConnection()), ctx, ce.needClientAuth, ce.certsFuture);
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        SSLConnectionContext sslCtx = this.obtainSslConnectionContext(connection);
        SSLEngine sslEngine = sslCtx.getSslEngine();
        if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
            return this.unwrapAll(ctx, sslCtx);
        }
        if (sslEngine == null) {
            sslEngine = this.serverSSLEngineConfigurator.createSSLEngine();
            sslEngine.beginHandshake();
            sslCtx.configure(sslEngine);
            this.notifyHandshakeStart(connection);
        }
        Buffer buffer = this.handshakeTimeoutMillis >= 0L ? this.doHandshakeSync(sslCtx, ctx, (Buffer)ctx.getMessage(), this.handshakeTimeoutMillis) : SSLUtils.makeInputRemainder(sslCtx, ctx, this.doHandshakeStep(sslCtx, ctx, (Buffer)ctx.getMessage()));
        boolean hasRemaining = buffer != null && buffer.hasRemaining();
        boolean isHandshaking = SSLUtils.isHandshaking(sslEngine);
        if (!isHandshaking) {
            this.notifyHandshakeComplete(connection, sslEngine);
            FilterChain connectionFilterChain = sslCtx.getNewConnectionFilterChain();
            sslCtx.setNewConnectionFilterChain(null);
            if (connectionFilterChain != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Applying new FilterChain after SSLHandshake. Connection={} filterchain={}", (Object)connection, (Object)connectionFilterChain);
                }
                connection.setProcessor(connectionFilterChain);
                if (hasRemaining) {
                    NextAction suspendAction = ctx.getSuspendAction();
                    ctx.setMessage(buffer);
                    ctx.suspend();
                    FilterChainContext newContext = SSLBaseFilter.obtainProtocolChainContext(ctx, connectionFilterChain);
                    ProcessorExecutor.execute(newContext.getInternalContext());
                    return suspendAction;
                }
                return ctx.getStopAction();
            }
            if (hasRemaining) {
                ctx.setMessage(buffer);
                return this.unwrapAll(ctx, sslCtx);
            }
        }
        return ctx.getStopAction(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection;
        if (ctx.getMessage() instanceof FileTransfer) {
            throw new IllegalStateException("TLS operations not supported with SendFile messages");
        }
        Connection connection2 = connection = ctx.getConnection();
        synchronized (connection2) {
            Buffer output = this.wrapAll(ctx, this.obtainSslConnectionContext(connection));
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            ctx.write(null, output, transportContext.getCompletionHandler(), transportContext.getPushBackHandler(), COPY_CLONER, transportContext.isBlocking());
            return ctx.getStopAction();
        }
    }

    protected NextAction unwrapAll(FilterChainContext ctx, SSLConnectionContext sslCtx) throws SSLException {
        int len;
        Buffer input = (Buffer)ctx.getMessage();
        Buffer output = null;
        boolean isClosed = false;
        block4: while ((len = SSLUtils.getSSLPacketSize(input)) != -1 && input.remaining() >= len) {
            SSLConnectionContext.SslResult result = sslCtx.unwrap(len, input, output, MM_ALLOCATOR);
            output = result.getOutput();
            if (result.isError()) {
                output.dispose();
                throw result.getError();
            }
            if (SSLUtils.isHandshaking(sslCtx.getSslEngine())) {
                if (result.getSslEngineResult().getStatus() != SSLEngineResult.Status.CLOSED) {
                    input = this.rehandshake(ctx, sslCtx);
                } else {
                    input = this.silentRehandshake(ctx, sslCtx);
                    isClosed = true;
                }
                if (input == null) break;
            }
            switch (result.getSslEngineResult().getStatus()) {
                case OK: {
                    if (!input.hasRemaining()) break block4;
                    break;
                }
                case CLOSED: {
                    isClosed = true;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected status: " + (Object)((Object)result.getSslEngineResult().getStatus()));
                }
            }
        }
        if (output != null) {
            output.trim();
            ctx.setMessage(output);
        }
        return this.resolveNextAction(ctx, sslCtx, input, output, isClosed);
    }

    protected NextAction resolveNextAction(FilterChainContext ctx, SSLConnectionContext sslCtx, Buffer input, Buffer output, boolean isClosed) {
        if (output != null && this.shouldContinueFilter(output, isClosed)) {
            return ctx.getInvokeAction(SSLUtils.makeInputRemainder(sslCtx, ctx, input));
        }
        return ctx.getStopAction(SSLUtils.makeInputRemainder(sslCtx, ctx, input));
    }

    private boolean shouldContinueFilter(Buffer output, boolean isClosed) {
        return !isClosed || output.hasRemaining();
    }

    protected Buffer wrapAll(FilterChainContext ctx, SSLConnectionContext sslCtx) throws SSLException {
        Buffer input = (Buffer)ctx.getMessage();
        Buffer output = sslCtx.wrapAll(input, OUTPUT_BUFFER_ALLOCATOR);
        input.tryDispose();
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer doHandshakeSync(SSLConnectionContext sslCtx, FilterChainContext ctx, Buffer inputBuffer, long timeoutMillis) throws IOException {
        Connection connection = ctx.getConnection();
        SSLEngine sslEngine = sslCtx.getSslEngine();
        Buffer tmpAppBuffer = SSLUtils.allocateOutputBuffer(sslCtx.getAppBufferSize());
        long oldReadTimeout = connection.getReadTimeout(TimeUnit.MILLISECONDS);
        try {
            connection.setReadTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
            inputBuffer = SSLUtils.makeInputRemainder(sslCtx, ctx, this.doHandshakeStep(sslCtx, ctx, inputBuffer, tmpAppBuffer));
            while (SSLUtils.isHandshaking(sslEngine)) {
                ReadResult rr = ctx.read();
                Buffer newBuf = (Buffer)rr.getMessage();
                inputBuffer = Buffers.appendBuffers(ctx.getMemoryManager(), inputBuffer, newBuf);
                inputBuffer = SSLUtils.makeInputRemainder(sslCtx, ctx, this.doHandshakeStep(sslCtx, ctx, inputBuffer, tmpAppBuffer));
            }
        }
        finally {
            tmpAppBuffer.dispose();
            connection.setReadTimeout(oldReadTimeout, TimeUnit.MILLISECONDS);
        }
        return inputBuffer;
    }

    protected Buffer doHandshakeStep(SSLConnectionContext sslCtx, FilterChainContext ctx, Buffer inputBuffer) throws IOException {
        return this.doHandshakeStep(sslCtx, ctx, inputBuffer, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Buffer doHandshakeStep(SSLConnectionContext sslCtx, FilterChainContext ctx, Buffer inputBuffer, Buffer tmpAppBuffer0) throws IOException {
        Buffer tmpNetBuffer;
        block28: {
            block27: {
                Connection connection = ctx.getConnection();
                boolean isLoggingFinest = LOGGER.isTraceEnabled();
                Buffer tmpInputToDispose = null;
                tmpNetBuffer = null;
                Buffer tmpAppBuffer = tmpAppBuffer0;
                try {
                    SSLEngineResult.HandshakeStatus handshakeStatus = sslCtx.getSslEngine().getHandshakeStatus();
                    block10: do {
                        if (isLoggingFinest) {
                            LOGGER.trace("Loop Engine: {} handshakeStatus={}", (Object)sslCtx.getSslEngine(), (Object)sslCtx.getSslEngine().getHandshakeStatus());
                        }
                        switch (handshakeStatus) {
                            case NEED_UNWRAP: {
                                int expectedLength;
                                if (isLoggingFinest) {
                                    LOGGER.trace("NEED_UNWRAP Engine: {}", (Object)sslCtx.getSslEngine());
                                }
                                if (inputBuffer != null && inputBuffer.hasRemaining() && (expectedLength = SSLUtils.getSSLPacketSize(inputBuffer)) != -1 && inputBuffer.remaining() >= expectedLength) {
                                    SSLEngineResult.Status status;
                                    if (tmpAppBuffer == null) {
                                        tmpAppBuffer = SSLUtils.allocateOutputBuffer(sslCtx.getAppBufferSize());
                                    }
                                    SSLEngineResult sslEngineResult = SSLUtils.handshakeUnwrap(expectedLength, sslCtx, inputBuffer, tmpAppBuffer);
                                    if (!inputBuffer.hasRemaining()) {
                                        tmpInputToDispose = inputBuffer;
                                        inputBuffer = null;
                                    }
                                    if ((status = sslEngineResult.getStatus()) == SSLEngineResult.Status.BUFFER_UNDERFLOW) throw new SSLException("SSL unwrap error: " + (Object)((Object)status));
                                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                        throw new SSLException("SSL unwrap error: " + (Object)((Object)status));
                                    }
                                    handshakeStatus = sslCtx.getSslEngine().getHandshakeStatus();
                                    break;
                                }
                                break block10;
                            }
                            case NEED_WRAP: {
                                if (isLoggingFinest) {
                                    LOGGER.trace("NEED_WRAP Engine: {}", (Object)sslCtx.getSslEngine());
                                }
                                tmpNetBuffer = SSLUtils.handshakeWrap(connection, sslCtx, tmpNetBuffer);
                                handshakeStatus = sslCtx.getSslEngine().getHandshakeStatus();
                                break;
                            }
                            case NEED_TASK: {
                                if (isLoggingFinest) {
                                    LOGGER.trace("NEED_TASK Engine: {}", (Object)sslCtx.getSslEngine());
                                }
                                SSLUtils.executeDelegatedTask(sslCtx.getSslEngine());
                                handshakeStatus = sslCtx.getSslEngine().getHandshakeStatus();
                                break;
                            }
                            case FINISHED: 
                            case NOT_HANDSHAKING: {
                                break block10;
                            }
                        }
                    } while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED);
                    if (tmpAppBuffer0 == null && tmpAppBuffer != null) {
                        tmpAppBuffer.dispose();
                    }
                    if (tmpInputToDispose == null) break block27;
                    tmpInputToDispose.tryDispose();
                }
                catch (IOException ioe) {
                    try {
                        this.notifyHandshakeFailed(connection, ioe);
                        throw ioe;
                    }
                    catch (Throwable throwable) {
                        if (tmpAppBuffer0 == null && tmpAppBuffer != null) {
                            tmpAppBuffer.dispose();
                        }
                        if (tmpInputToDispose != null) {
                            tmpInputToDispose.tryDispose();
                            inputBuffer = null;
                        } else if (inputBuffer != null) {
                            inputBuffer.shrink();
                        }
                        if (tmpNetBuffer == null) throw throwable;
                        if (inputBuffer != null) {
                            inputBuffer = SSLUtils.makeInputRemainder(sslCtx, ctx, inputBuffer);
                        }
                        ctx.write(tmpNetBuffer);
                        throw throwable;
                    }
                }
                inputBuffer = null;
                break block28;
            }
            if (inputBuffer != null) {
                inputBuffer.shrink();
            }
        }
        if (tmpNetBuffer == null) return inputBuffer;
        if (inputBuffer != null) {
            inputBuffer = SSLUtils.makeInputRemainder(sslCtx, ctx, inputBuffer);
        }
        ctx.write(tmpNetBuffer);
        return inputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renegotiate(SSLConnectionContext sslCtx, FilterChainContext context) throws IOException {
        boolean authConfigured;
        if (this.renegotiationDisabled) {
            return;
        }
        SSLEngine sslEngine = sslCtx.getSslEngine();
        if (sslEngine.getWantClientAuth() && !this.renegotiateOnClientAuthWant) {
            return;
        }
        boolean bl = authConfigured = sslEngine.getWantClientAuth() || sslEngine.getNeedClientAuth();
        if (!authConfigured) {
            sslEngine.setNeedClientAuth(true);
        }
        sslEngine.getSession().invalidate();
        try {
            sslEngine.beginHandshake();
        }
        catch (SSLHandshakeException e) {
            if (e.toString().toLowerCase().contains("insecure renegotiation") && LOGGER.isErrorEnabled()) {
                LOGGER.error("Secure SSL/TLS renegotiation is not supported by the peer.  This is most likely due to the peer using an older SSL/TLS implementation that does not implement RFC 5746.");
            }
            throw e;
        }
        try {
            this.rehandshake(context, sslCtx);
        }
        finally {
            if (!authConfigured) {
                sslEngine.setNeedClientAuth(false);
            }
        }
    }

    private Buffer silentRehandshake(FilterChainContext context, SSLConnectionContext sslCtx) throws SSLException {
        try {
            sslCtx.getSslEngine().closeOutbound();
            return this.doHandshakeSync(sslCtx, context, null, this.handshakeTimeoutMillis);
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error during graceful ssl connection close", t);
            }
            if (t instanceof SSLException) {
                throw (SSLException)t;
            }
            throw new SSLException("Error during re-handshaking", t);
        }
    }

    private Buffer rehandshake(FilterChainContext context, SSLConnectionContext sslCtx) throws SSLException {
        Connection c = context.getConnection();
        this.notifyHandshakeStart(c);
        try {
            Buffer buffer = this.doHandshakeSync(sslCtx, context, null, this.handshakeTimeoutMillis);
            this.notifyHandshakeComplete(c, sslCtx.getSslEngine());
            return buffer;
        }
        catch (Throwable t) {
            this.notifyHandshakeFailed(c, t);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error during re-handshaking", t);
            }
            if (t instanceof SSLException) {
                throw (SSLException)t;
            }
            throw new SSLException("Error during re-handshaking", t);
        }
    }

    protected void getPeerCertificateChain(final SSLConnectionContext sslCtx, final FilterChainContext context, boolean needClientAuth, final FutureImpl<Object[]> certFuture) {
        Certificate[] certs = SSLBaseFilter.getPeerCertificates(sslCtx);
        if (certs != null) {
            certFuture.result(certs);
            return;
        }
        if (needClientAuth) {
            Transport transport = context.getConnection().getTransport();
            ExecutorService threadPool = transport.getWorkerThreadPool();
            if (threadPool == null) {
                threadPool = transport.getKernelThreadPool();
            }
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            SSLBaseFilter.this.renegotiate(sslCtx, context);
                        }
                        catch (IOException ioe) {
                            certFuture.failure(ioe);
                            context.resume(context.getStopAction());
                            return;
                        }
                        Certificate[] certs = SSLBaseFilter.getPeerCertificates(sslCtx);
                        if (certs == null) {
                            certFuture.result(null);
                            return;
                        }
                        X509Certificate[] x509Certs = SSLBaseFilter.extractX509Certs(certs);
                        if (x509Certs == null || x509Certs.length < 1) {
                            certFuture.result(null);
                            return;
                        }
                        certFuture.result(x509Certs);
                    }
                    finally {
                        context.resume(context.getStopAction());
                    }
                }
            });
        }
    }

    protected SSLConnectionContext obtainSslConnectionContext(Connection connection) {
        SSLConnectionContext sslCtx = SSLUtils.SSL_CTX_ATTR.get(connection);
        if (sslCtx == null) {
            sslCtx = this.createSslConnectionContext(connection);
            SSLUtils.SSL_CTX_ATTR.set(connection, sslCtx);
        }
        return sslCtx;
    }

    protected SSLConnectionContext createSslConnectionContext(Connection connection) {
        return new SSLConnectionContext(connection);
    }

    private static FilterChainContext obtainProtocolChainContext(FilterChainContext ctx, FilterChain completeProtocolFilterChain) {
        FilterChainContext newFilterChainContext = completeProtocolFilterChain.obtainFilterChainContext(ctx.getConnection(), ctx.getStartIdx(), completeProtocolFilterChain.size(), ctx.getFilterIdx());
        newFilterChainContext.setAddressHolder(ctx.getAddressHolder());
        newFilterChainContext.setMessage(ctx.getMessage());
        newFilterChainContext.getInternalContext().setIoEvent(IOEvent.READ);
        newFilterChainContext.getInternalContext().addLifeCycleListener(new InternalProcessingHandler(ctx));
        return newFilterChainContext;
    }

    private static X509Certificate[] extractX509Certs(Certificate[] certs) {
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        int len = certs.length;
        for (int i = 0; i < len; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    LOGGER.info("Error translating cert {}", (Object)certs[i], (Object)ex);
                    return null;
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Cert #{} = {}", (Object)i, (Object)x509Certs[i]);
        }
        return x509Certs;
    }

    private static Certificate[] getPeerCertificates(SSLConnectionContext sslCtx) {
        try {
            return sslCtx.getSslEngine().getSession().getPeerCertificates();
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error getting client certs", t);
            }
            return null;
        }
    }

    protected void notifyHandshakeStart(Connection connection) {
        if (!this.handshakeListeners.isEmpty()) {
            for (HandshakeListener listener : this.handshakeListeners) {
                listener.onStart(connection);
            }
        }
    }

    protected void notifyHandshakeComplete(Connection<?> connection, SSLEngine sslEngine) {
        if (!this.handshakeListeners.isEmpty()) {
            for (HandshakeListener listener : this.handshakeListeners) {
                listener.onComplete(connection);
            }
        }
    }

    protected void notifyHandshakeFailed(Connection connection, Throwable t) {
        if (!this.handshakeListeners.isEmpty()) {
            for (HandshakeListener listener : this.handshakeListeners) {
                listener.onFailure(connection, t);
            }
        }
    }

    protected static class SSLTransportFilterWrapper
    extends TransportFilter {
        protected final TransportFilter wrappedFilter;
        protected final SSLBaseFilter sslBaseFilter;

        public SSLTransportFilterWrapper(TransportFilter transportFilter, SSLBaseFilter sslBaseFilter) {
            this.wrappedFilter = transportFilter;
            this.sslBaseFilter = sslBaseFilter;
        }

        @Override
        public NextAction handleAccept(FilterChainContext ctx) throws IOException {
            return this.wrappedFilter.handleAccept(ctx);
        }

        @Override
        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            return this.wrappedFilter.handleConnect(ctx);
        }

        @Override
        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            Connection connection = ctx.getConnection();
            SSLConnectionContext sslCtx = this.sslBaseFilter.obtainSslConnectionContext(connection);
            if (sslCtx.getSslEngine() == null) {
                SSLEngine sslEngine = this.sslBaseFilter.serverSSLEngineConfigurator.createSSLEngine();
                sslEngine.beginHandshake();
                sslCtx.configure(sslEngine);
                this.sslBaseFilter.notifyHandshakeStart(connection);
            }
            ctx.setMessage(SSLUtils.allowDispose(SSLUtils.allocateInputBuffer(sslCtx)));
            return this.wrappedFilter.handleRead(ctx);
        }

        @Override
        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            return this.wrappedFilter.handleWrite(ctx);
        }

        @Override
        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            return this.wrappedFilter.handleEvent(ctx, event);
        }

        @Override
        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            return this.wrappedFilter.handleClose(ctx);
        }

        @Override
        public void onAdded(FilterChain filterChain) {
            this.wrappedFilter.onAdded(filterChain);
        }

        @Override
        public void onFilterChainChanged(FilterChain filterChain) {
            this.wrappedFilter.onFilterChainChanged(filterChain);
        }

        @Override
        public void onRemoved(FilterChain filterChain) {
            this.wrappedFilter.onRemoved(filterChain);
        }

        @Override
        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            this.wrappedFilter.exceptionOccurred(ctx, error);
        }

        @Override
        public FilterChainContext createContext(Connection connection, FilterChainContext.Operation operation) {
            return this.wrappedFilter.createContext(connection, operation);
        }
    }

    public static class CertificateEvent
    implements FilterChainEvent {
        static final String TYPE = "CERT_EVENT";
        final FutureImpl<Object[]> certsFuture;
        final boolean needClientAuth;

        public CertificateEvent(boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
            this.certsFuture = Futures.createSafeFuture();
        }

        @Override
        public final Object type() {
            return TYPE;
        }

        public GrizzlyFuture<Object[]> trigger(FilterChainContext ctx) {
            ctx.getFilterChain().fireEventDownstream(ctx.getConnection(), this, null);
            return this.certsFuture;
        }
    }

    private static class InternalProcessingHandler
    extends IOEventLifeCycleListener.Adapter {
        private final FilterChainContext parentContext;

        private InternalProcessingHandler(FilterChainContext parentContext) {
            this.parentContext = parentContext;
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            this.parentContext.resume(this.parentContext.getStopAction());
        }
    }

    public static interface HandshakeListener {
        public void onStart(Connection var1);

        public void onComplete(Connection var1);

        public void onFailure(Connection var1, Throwable var2);
    }

    private static final class OnWriteCopyCloner
    implements MessageCloner<Buffer> {
        private OnWriteCopyCloner() {
        }

        @Override
        public Buffer clone(Connection connection, Buffer originalMessage) {
            SSLConnectionContext sslCtx = SSLUtils.getSslConnectionContext(connection);
            int copyThreshold = sslCtx.getNetBufferSize() / 2;
            Buffer lastOutputBuffer = sslCtx.resetLastOutputBuffer();
            int totalRemaining = originalMessage.remaining();
            if (totalRemaining < copyThreshold) {
                return SSLUtils.move(connection.getMemoryManager(), originalMessage);
            }
            if (lastOutputBuffer.remaining() < copyThreshold) {
                Buffer tmpBuf = SSLUtils.copy(connection.getMemoryManager(), originalMessage);
                if (originalMessage.isComposite()) {
                    ((CompositeBuffer)originalMessage).replace(lastOutputBuffer, tmpBuf);
                } else assert (originalMessage == lastOutputBuffer);
                lastOutputBuffer.tryDispose();
                return tmpBuf;
            }
            return originalMessage;
        }
    }
}

