/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiHandler;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletContext;
import org.glassfish.grizzly.osgi.httpservice.OSGiServletHandler;
import org.glassfish.grizzly.osgi.httpservice.util.Logger;
import org.osgi.service.http.HttpContext;

class OSGiCleanMapper {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final TreeSet<String> aliasTree = new TreeSet();
    private static final Map<String, HttpHandler> registrations = new HashMap<String, HttpHandler>(16);
    private static final Set<Servlet> registeredServlets = new HashSet<Servlet>(16);
    private final Set<String> localAliases = new HashSet<String>(4);
    private final HashMap<HttpContext, List<OSGiServletHandler>> contextServletHandlerMap = new HashMap(3);
    private final Logger logger;
    protected final Map<HttpContext, OSGiServletContext> httpContextToServletContextMap = new HashMap<HttpContext, OSGiServletContext>();

    protected OSGiCleanMapper(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String map(String resource, boolean cutAfterSlash) {
        int i;
        String match = resource;
        do {
            i = 0;
            if (cutAfterSlash) {
                i = match.lastIndexOf(47);
                if (i == -1) {
                    return null;
                }
                match = i == 0 ? "/" : resource.substring(0, i);
            }
            if (!OSGiCleanMapper.containsAlias(match)) continue;
            return match;
        } while (i != 0);
        return null;
    }

    public static boolean containsAlias(String alias) {
        return aliasTree.contains(alias);
    }

    public static boolean containsServlet(Servlet servlet) {
        return registeredServlets.contains(servlet);
    }

    public static ReentrantLock getLock() {
        return lock;
    }

    static HttpHandler getHttpHandler(String alias) {
        return registrations.get(alias);
    }

    public void recycleRegistrationData(String alias) {
        if (OSGiCleanMapper.containsAlias(alias)) {
            aliasTree.remove(alias);
            HttpHandler handler = registrations.remove(alias);
            handler.destroy();
            this.localAliases.remove(alias);
        }
    }

    public void addHttpHandler(String alias, HttpHandler handler) {
        if (!OSGiCleanMapper.containsAlias(alias)) {
            OSGiCleanMapper.registerAliasHandler(alias, handler);
            if (handler instanceof OSGiServletHandler) {
                registeredServlets.add(((OSGiServletHandler)handler).getServletInstance());
            }
            this.localAliases.add(alias);
        }
    }

    public boolean isLocalyRegisteredAlias(String alias) {
        return this.localAliases.contains(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnregister(String alias, boolean callDestroyOnServlet) {
        HttpHandler httpHandler;
        if (OSGiCleanMapper.containsAlias(alias) && (httpHandler = OSGiCleanMapper.getHttpHandler(alias)) instanceof OSGiServletHandler) {
            ((OSGiHandler)((Object)httpHandler)).getRemovalLock().lock();
            try {
                Servlet servlet = ((OSGiServletHandler)httpHandler).getServletInstance();
                registeredServlets.remove(servlet);
                if (callDestroyOnServlet) {
                    servlet.destroy();
                }
            }
            finally {
                ((OSGiHandler)((Object)httpHandler)).getRemovalLock().unlock();
            }
        }
        this.recycleRegistrationData(alias);
    }

    public Set<String> getLocalAliases() {
        return Collections.unmodifiableSet(this.localAliases);
    }

    static Set<String> getAllAliases() {
        return aliasTree;
    }

    public boolean containsContext(HttpContext httpContext) {
        return this.contextServletHandlerMap.containsKey(httpContext);
    }

    public List<OSGiServletHandler> getContext(HttpContext httpContext) {
        return this.contextServletHandlerMap.get(httpContext);
    }

    public void addContext(HttpContext httpContext, List<OSGiServletHandler> servletHandlers) {
        this.addContext(httpContext, null, servletHandlers);
    }

    public void addContext(HttpContext httpContext, OSGiServletContext servletCtx, List<OSGiServletHandler> servletHandlers) {
        if (servletCtx == null) {
            servletCtx = new OSGiServletContext(httpContext, this.logger);
        }
        this.contextServletHandlerMap.put(httpContext, servletHandlers);
        this.httpContextToServletContextMap.put(httpContext, servletCtx);
    }

    public OSGiServletContext getServletContext(HttpContext httpContext) {
        return this.httpContextToServletContextMap.get(httpContext);
    }

    private static boolean registerAliasHandler(String alias, HttpHandler httpHandler) {
        boolean wasNew = aliasTree.add(alias);
        if (wasNew) {
            registrations.put(alias, httpHandler);
        }
        return wasNew;
    }
}

