/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.statistics.BoundaryStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public final class BoundaryStatisticImpl
extends StatisticImpl
implements BoundaryStatistic,
InvocationHandler {
    private AtomicLong lowerBound = new AtomicLong(0L);
    private AtomicLong upperBound = new AtomicLong(0L);
    private BoundaryStatistic bs = (BoundaryStatistic)Proxy.newProxyInstance(BoundaryStatistic.class.getClassLoader(), new Class[]{BoundaryStatistic.class}, (InvocationHandler)this);

    public BoundaryStatisticImpl(long lower, long upper, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.upperBound.set(upper);
        this.lowerBound.set(lower);
    }

    public synchronized BoundaryStatistic getStatistic() {
        return this.bs;
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("lowerbound", this.getLowerBound());
        m.put("upperbound", this.getUpperBound());
        return m;
    }

    public long getLowerBound() {
        return this.lowerBound.get();
    }

    public void setLowerBound(long lower) {
        this.lowerBound.set(lower);
    }

    public long getUpperBound() {
        return this.upperBound.get();
    }

    public void setUpperBound(long upper) {
        this.upperBound.set(upper);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

