/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ContainerRegistry;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfo<T extends Container, U extends ApplicationContainer> {
    final Inhabitant<T> container;
    final Sniffer sniffer;
    ContainerRegistry registry = null;
    Map<String, ApplicationInfo> deployedApps = new HashMap<String, ApplicationInfo>();
    Map<WeakReference<Thread>, Set<Integer>> addedThreadLocals = new HashMap<WeakReference<Thread>, Set<Integer>>();
    Deployer deployer;
    final ClassLoader mainClassLoader;

    public ContainerInfo(Inhabitant<T> container, Sniffer sniffer, ClassLoader cloader) {
        this.container = container;
        this.sniffer = sniffer;
        this.mainClassLoader = cloader;
    }

    public T getContainer() {
        return (T)((Container)this.container.get());
    }

    public Sniffer getSniffer() {
        return this.sniffer;
    }

    public Deployer<T, U> getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer<T, U> deployer) {
        this.deployer = deployer;
    }

    public synchronized void add(ApplicationInfo application) {
        this.deployedApps.put(application.getName(), application);
    }

    public synchronized void remove(ApplicationInfo application) {
        if (!this.deployedApps.containsKey(application.getName())) {
            return;
        }
        this.deployedApps.remove(application.getName());
    }

    public synchronized void remove(String name) {
        this.deployedApps.remove(name);
    }

    public ApplicationInfo get(String name) {
        return this.deployedApps.get(name);
    }

    public Iterable<ApplicationInfo> getApplications() {
        ArrayList<ApplicationInfo> copy = new ArrayList<ApplicationInfo>(this.deployedApps.size());
        copy.addAll(this.deployedApps.values());
        return copy;
    }

    public void setRegistry(ContainerRegistry registry) {
        this.registry = registry;
    }

    public ClassLoader getClassLoader() {
        return this.mainClassLoader;
    }

    public synchronized void addThreadLocal(Thread t, Set<Integer> newEntries) {
        Set<Integer> existingEntries = null;
        for (Map.Entry<WeakReference<Thread>, Set<Integer>> entry : this.addedThreadLocals.entrySet()) {
            if (entry.getKey().get() != null) {
                if (!((Thread)entry.getKey().get()).equals(t)) continue;
                existingEntries = entry.getValue();
                break;
            }
            this.addedThreadLocals.remove(entry.getKey());
        }
        if (existingEntries == null) {
            existingEntries = new HashSet<Integer>();
            this.addedThreadLocals.put(new WeakReference<Thread>(t), existingEntries);
        }
        existingEntries.addAll(newEntries);
    }

    private void cleanup() {
        for (Map.Entry<WeakReference<Thread>, Set<Integer>> entry : this.addedThreadLocals.entrySet()) {
            if (entry.getKey().get() == null) continue;
            try {
                Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
                threadLocalsField.setAccessible(true);
                Class<?> c = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                Field tableField = c.getDeclaredField("table");
                Method remove = c.getDeclaredMethod("remove", ThreadLocal.class);
                tableField.setAccessible(true);
                c = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
                Field value = c.getDeclaredField("value");
                value.setAccessible(true);
                Thread t = (Thread)entry.getKey().get();
                Object threadLocals = threadLocalsField.get(t);
                for (WeakReference e : (WeakReference[])tableField.get(threadLocals)) {
                    if (e == null) continue;
                    remove.invoke((Object)threadLocalsField, e.get());
                    System.out.println("Removed " + value.get(e));
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

