/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.glassfish.spec.Artifact;
import org.glassfish.spec.Metadata;
import org.glassfish.spec.Spec;

public class CheckDistributionMojo
extends AbstractMojo {
    protected String includes;
    protected String excludes;
    protected File dir;
    protected List<Spec> specs;

    private Spec getSpec(File f) throws IOException {
        JarFile j = new JarFile(f);
        Artifact a = Artifact.fromJar(j);
        for (Spec s : this.specs) {
            if (!s.getArtifact().equals(a)) continue;
            s.setMetadata(Metadata.fromJar(j));
            return s;
        }
        Spec spec = new Spec();
        spec.setArtifact(a);
        spec.setMetadata(Metadata.fromJar(j));
        return spec;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.dir.exists()) {
            String msg = String.format("directory (%s) does not exist", this.dir.getAbsolutePath());
            this.getLog().error((CharSequence)msg);
            throw new MojoFailureException(msg);
        }
        List jars = Collections.EMPTY_LIST;
        try {
            jars = FileUtils.getFiles((File)this.dir, (String)this.includes, (String)this.excludes);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        for (File jar : jars) {
            try {
                Spec spec = this.getSpec(jar);
                spec.verify();
                if (spec.getErrors().isEmpty()) continue;
                System.out.println("");
                System.out.println(spec.getArtifact().toString());
                String specDesc = spec.toString();
                if (!specDesc.isEmpty()) {
                    System.out.println(spec.toString());
                }
                for (int i = 0; i < spec.getErrors().size(); ++i) {
                    System.out.println("" + '-' + ' ' + spec.getErrors().get(i));
                }
                System.out.println("");
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

