/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.runtime.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.glassfish.admin.runtime.annotations.MBean;
import org.glassfish.admin.runtime.annotations.ManagedAttribute;
import org.glassfish.admin.runtime.annotations.ManagedOperation;

class RuntimeMgmtAptProcessor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;
    private final Messager msg;
    private final boolean debug;
    private String pojoName;
    private String pojoClassName;
    private String packageName;
    private ArrayList<ModelMBeanOperationInfo> mmoiArr;
    private ArrayList<ModelMBeanAttributeInfo> mmaiArr;
    private HashMap<String, ArrayList> attrMap;
    private ModelMBeanInfo mmbinfo;

    private void init() {
        this.mmoiArr = new ArrayList();
        this.mmaiArr = new ArrayList();
        this.attrMap = new HashMap();
        this.mmbinfo = null;
    }

    public RuntimeMgmtAptProcessor(AnnotationProcessorEnvironment env) {
        this.env = env;
        this.msg = env.getMessager();
        this.debug = env.getOptions().containsKey("-Adebug");
    }

    public void process() {
        for (TypeDeclaration decl : this.env.getSpecifiedTypeDeclarations()) {
            if (this.debug) {
                this.msg.printNotice("type = " + decl.getQualifiedName());
                this.msg.printNotice("package = " + decl.getPackage().getQualifiedName());
            }
            this.generateMBeanInfo(decl);
        }
    }

    private void generateMBeanInfo(TypeDeclaration decl) {
        this.init();
        if (decl.getAnnotation(MBean.class) == null) {
            return;
        }
        this.pojoName = decl.getSimpleName();
        this.pojoClassName = decl.getQualifiedName();
        this.packageName = decl.getPackage().getQualifiedName();
        if (this.debug) {
            this.msg.printNotice("generating mbeaninfo ...");
        }
        try {
            ClassDeclaration cd = (ClassDeclaration)decl;
            this.msg.printNotice("before super classdecl = " + cd);
            this.processSuper((ClassDeclaration)decl);
            this.msg.printNotice("before attrinfo ...");
            this.generateAttrInfo();
            DescriptorSupport descriptor = new DescriptorSupport("name=" + this.pojoName, "descriptorType=mbean", "displayName=" + this.pojoClassName);
            ModelMBeanAttributeInfo[] mbaiArr = null;
            int k = 0;
            if (this.mmaiArr.size() > 0) {
                mbaiArr = new ModelMBeanAttributeInfo[this.mmaiArr.size()];
                Iterator<ModelMBeanAttributeInfo> i$ = this.mmaiArr.iterator();
                while (i$.hasNext()) {
                    ModelMBeanAttributeInfo mbai;
                    mbaiArr[k] = mbai = i$.next();
                    ++k;
                }
            }
            ModelMBeanOperationInfo[] mboiArr = null;
            k = 0;
            if (this.mmoiArr.size() > 0) {
                mboiArr = new ModelMBeanOperationInfo[this.mmoiArr.size()];
                Iterator<ModelMBeanOperationInfo> i$ = this.mmoiArr.iterator();
                while (i$.hasNext()) {
                    ModelMBeanOperationInfo mboi;
                    mboiArr[k] = mboi = i$.next();
                    ++k;
                }
            }
            this.mmbinfo = new ModelMBeanInfoSupport(this.pojoClassName, null, mbaiArr, null, mboiArr, null);
            this.mmbinfo.setMBeanDescriptor(descriptor);
            this.msg.printNotice("mbeanInfo = " + this.mmbinfo);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            OutputStream fos = this.env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, this.packageName, new File(this.pojoName + ".ser"));
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(this.mmbinfo);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void processSuper(ClassDeclaration cdecl) {
        this.msg.printNotice("processSuper, cdecl = " + cdecl);
        if (cdecl == null || "java.lang.Object".equals(cdecl.getQualifiedName())) {
            return;
        }
        for (MethodDeclaration mdecl : cdecl.getMethods()) {
            this.generateMethods(mdecl);
        }
        this.processSuper(cdecl.getSuperclass().getDeclaration());
    }

    private void generateMethods(MethodDeclaration mdecl) {
        if (mdecl.getAnnotation(ManagedOperation.class) == null && mdecl.getAnnotation(ManagedAttribute.class) == null) {
            return;
        }
        try {
            if (!mdecl.getModifiers().contains(Modifier.PUBLIC)) {
                return;
            }
            this.generateOperation(mdecl);
            if (mdecl.getAnnotation(ManagedAttribute.class) != null) {
                this.generateAttribute(mdecl);
            }
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void generateOperation(MethodDeclaration mdecl) {
        try {
            String methodName = mdecl.getSimpleName();
            DescriptorSupport descriptor = new DescriptorSupport("name=" + methodName, "descriptorType=operation", "class=" + this.pojoClassName, "role=operation");
            String returnType = mdecl.getReturnType().toString();
            MBeanParameterInfo[] mbpiArr = null;
            int paramSize = mdecl.getParameters().size();
            if (paramSize > 0) {
                mbpiArr = new MBeanParameterInfo[paramSize];
                int k = 0;
                for (ParameterDeclaration pdecl : mdecl.getParameters()) {
                    mbpiArr[k] = new MBeanParameterInfo(pdecl.getSimpleName(), pdecl.getType().toString(), null);
                    ++k;
                }
            }
            this.mmoiArr.add(new ModelMBeanOperationInfo(methodName, null, mbpiArr, returnType, 1, descriptor));
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void generateAttribute(MethodDeclaration mdecl) {
        try {
            String attrName = null;
            String name = mdecl.getSimpleName();
            String getterName = null;
            String setterName = null;
            String isIsName = null;
            String returnType = null;
            if (name.startsWith("get")) {
                attrName = name.substring(3);
                getterName = name;
                returnType = mdecl.getReturnType().toString();
            } else if (name.startsWith("is")) {
                attrName = name.substring(2);
                isIsName = name;
                returnType = mdecl.getReturnType().toString();
            } else if (name.startsWith("set")) {
                attrName = name.substring(3);
                setterName = name;
                for (ParameterDeclaration pdecl : mdecl.getParameters()) {
                    returnType = pdecl.getType().toString();
                }
            }
            if (this.attrMap == null) {
                this.setAttrMap(new ArrayList(4), attrName, getterName, setterName, isIsName, returnType);
            } else {
                ArrayList al = this.attrMap.get(attrName);
                if (al == null) {
                    this.setAttrMap(new ArrayList(4), attrName, getterName, setterName, isIsName, returnType);
                } else {
                    this.setAttrMap(al, attrName, getterName, setterName, isIsName, returnType);
                }
            }
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setAttrMap(ArrayList al, String name, String getterName, String setterName, String isIsName, String returnType) {
        if (al.size() == 0) {
            al.add(0, null);
            al.add(1, null);
            al.add(2, null);
            al.add(3, null);
        }
        if (getterName != null) {
            al.set(0, getterName);
        }
        if (setterName != null) {
            al.set(1, setterName);
        }
        if (isIsName != null) {
            al.set(2, isIsName);
        }
        al.set(3, returnType);
        this.attrMap.put(name, al);
    }

    private void generateAttrInfo() {
        String key2 = null;
        ArrayList al = null;
        boolean isReadable = false;
        boolean isWritable = false;
        boolean isIs = false;
        try {
            for (String key2 : this.attrMap.keySet()) {
                al = this.attrMap.get(key2);
                String gm = null;
                if (al.get(0) != null) {
                    gm = "getMethod=" + (String)al.get(0);
                    isReadable = true;
                } else if (al.get(2) != null) {
                    gm = "getMethod=" + (String)al.get(2);
                    isReadable = true;
                    isIs = true;
                }
                String sm = null;
                if (al.get(1) != null) {
                    sm = "setMethod=" + (String)al.get(1);
                    isWritable = true;
                }
                DescriptorSupport descriptor = new DescriptorSupport("name=" + key2, "descriptorType=attribute", gm, sm);
                this.mmaiArr.add(new ModelMBeanAttributeInfo(key2, (String)al.get(3), null, isReadable, isWritable, isIs, descriptor));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

