/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.util.config;

import net.xqhs.util.config.Configurable;

public abstract class Config
implements Configurable {
    private boolean locked = false;

    public Config() {
        this.makeDefaults();
    }

    @Override
    public Config makeDefaults() {
        return this;
    }

    @Override
    public Config lock() {
        this.locked = true;
        return this;
    }

    @Override
    public final Config build() {
        return this.lock();
    }

    @Override
    public void ensureLocked() {
        if (!this.locked) {
            this.lock();
        }
    }

    @Override
    public void locked() throws ConfigLockedException {
        if (this.locked) {
            throw new ConfigLockedException();
        }
    }

    protected final void lockedEx() throws ConfigLockedException {
        if (this.locked) {
            throw new ConfigLockedException();
        }
    }

    public class ConfigLockedException
    extends Exception {
        private static final long serialVersionUID = 8254604960026434594L;

        @Override
        public String toString() {
            return "It is illegal to modify a Config once it has been locked.";
        }
    }
}

