/*
 * Decompiled with CFR 0.152.
 */
package giwi.org.networkgraph.layout;

import android.util.Log;
import giwi.org.networkgraph.beans.Dimension;
import giwi.org.networkgraph.beans.NetworkGraph;
import giwi.org.networkgraph.beans.Point2D;
import giwi.org.networkgraph.beans.RandomLocationTransformer;
import giwi.org.networkgraph.layout.AbstractLayout;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Node;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.map.LazyMap;

public class FRLayout
extends AbstractLayout {
    private double temperature;
    private int currentIteration;
    private int mMaxIterations = 700;
    private Map<Node, FRVertexData> frVertexData = LazyMap.lazyMap(new HashMap(), (Factory)new Factory<FRVertexData>(){

        public FRVertexData create() {
            return new FRVertexData();
        }
    });
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private double max_dimension;
    private double EPSILON = 1.0E-6;

    public FRLayout(NetworkGraph g) {
        super(g);
    }

    public FRLayout(NetworkGraph g, Dimension d) {
        super(g, new RandomLocationTransformer<Node>(d), d);
        this.initialize();
        this.max_dimension = Math.max(d.getHeight(), d.getWidth());
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
        this.max_dimension = Math.max(size.getHeight(), size.getWidth());
    }

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    @Override
    public void reset() {
        this.doInit();
    }

    @Override
    public void initialize() {
        this.doInit();
    }

    @Override
    public void setGraph(NetworkGraph graph) {
        super.setGraph(graph);
    }

    private void doInit() {
        NetworkGraph graph = this.getGraph();
        Dimension d = this.getSize();
        if (graph != null && d != null) {
            this.currentIteration = 0;
            this.temperature = d.getWidth() / 10;
            double forceConstant = Math.sqrt(d.getHeight() * d.getWidth() / graph.getVertex().size());
            this.attraction_constant = this.attraction_multiplier * forceConstant;
            this.repulsion_constant = this.repulsion_multiplier * forceConstant;
        }
    }

    public synchronized void step() {
        ++this.currentIteration;
        while (true) {
            try {
                for (Node v1 : this.getGraph().getNodes()) {
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException cme) {
                Log.e((String)FRLayout.class.getName(), (String)cme.getMessage());
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Edge e : this.getGraph().getEdges()) {
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException cme) {
                Log.e((String)FRLayout.class.getName(), (String)cme.getMessage());
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Node v : this.getGraph().getNodes()) {
                    if (this.isLocked(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException cme) {
                Log.e((String)FRLayout.class.getName(), (String)cme.getMessage());
                continue;
            }
            break;
        }
        this.cool();
    }

    private synchronized void calcPositions(Node v) {
        FRVertexData fvd = this.getFRData(v);
        if (fvd == null) {
            return;
        }
        Point2D xyd = this.transform(v);
        double deltaLength = Math.max(this.EPSILON, fvd.norm());
        double newXDisp = fvd.getX() / deltaLength * Math.min(deltaLength, this.temperature);
        if (Double.isNaN(newXDisp)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [xdisp]");
        }
        double newYDisp = fvd.getY() / deltaLength * Math.min(deltaLength, this.temperature);
        xyd.setLocation(xyd.getX() + newXDisp, xyd.getY() + newYDisp);
        double borderWidth = (double)this.getSize().getWidth() / 50.0;
        double newXPos = xyd.getX();
        if (newXPos < borderWidth) {
            newXPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newXPos > (double)this.getSize().getWidth() - borderWidth) {
            newXPos = (double)this.getSize().getWidth() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double newYPos = xyd.getY();
        if (newYPos < borderWidth) {
            newYPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newYPos > (double)this.getSize().getHeight() - borderWidth) {
            newYPos = (double)this.getSize().getHeight() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        xyd.setLocation(newXPos, newYPos);
    }

    private void calcAttraction(Edge e) {
        double yDelta;
        Node v1 = e.getFrom();
        Node v2 = e.getTo();
        boolean v1_locked = this.isLocked(v1);
        boolean v2_locked = this.isLocked(v2);
        if (v1_locked && v2_locked) {
            return;
        }
        Point2D p1 = this.transform(v1);
        Point2D p2 = this.transform(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = p1.getX() - p2.getX();
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = p1.getY() - p2.getY()) * yDelta));
        double force = deltaLength * deltaLength / this.attraction_constant;
        if (Double.isNaN(force)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [force]");
        }
        double dx = xDelta / deltaLength * force;
        double dy = yDelta / deltaLength * force;
        if (!v1_locked) {
            FRVertexData fvd1 = this.getFRData(v1);
            fvd1.offset(-dx, -dy);
        }
        if (!v2_locked) {
            FRVertexData fvd2 = this.getFRData(v2);
            fvd2.offset(dx, dy);
        }
    }

    private void calcRepulsion(Node v1) {
        FRVertexData fvd1 = this.getFRData(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.setLocation(0.0, 0.0);
        try {
            for (Node v2 : this.getGraph().getNodes()) {
                double yDelta;
                if (v1 == v2) continue;
                Point2D p1 = this.transform(v1);
                Point2D p2 = this.transform(v2);
                if (p1 == null || p2 == null) continue;
                double xDelta = p1.getX() - p2.getX();
                double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + (yDelta = p1.getY() - p2.getY()) * yDelta));
                double force = this.repulsion_constant * this.repulsion_constant / deltaLength;
                if (Double.isNaN(force)) {
                    throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                }
                fvd1.offset(xDelta / deltaLength * force, yDelta / deltaLength * force);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    private FRVertexData getFRData(Node v) {
        return this.frVertexData.get(v);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean done() {
        return this.currentIteration > this.mMaxIterations || this.temperature < 1.0 / this.max_dimension;
    }

    private static class FRVertexData
    extends Point2D {
        private FRVertexData() {
        }

        void offset(double x, double y) {
            this.x += x;
            this.y += y;
        }

        double norm() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }
}

