/*
 * Decompiled with CFR 0.152.
 */
package giwi.org.networkgraph.layout;

import android.util.Log;
import giwi.org.networkgraph.beans.Dimension;
import giwi.org.networkgraph.beans.NetworkGraph;
import giwi.org.networkgraph.beans.Point2D;
import giwi.org.networkgraph.layout.Layout;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.xqhs.graphs.graph.Node;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.ChainedTransformer;
import org.apache.commons.collections4.map.LazyMap;

abstract class AbstractLayout
implements Layout {
    private Set<Node> dontmove = new HashSet<Node>();
    private Dimension size;
    private NetworkGraph graph;
    boolean initialized;
    private Map<Node, Point2D> locations = LazyMap.lazyMap(new HashMap(), (Transformer)new Transformer<Node, Point2D>(){

        public Point2D transform(Node arg0) {
            return new Point2D();
        }
    });

    AbstractLayout(NetworkGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("NetworkGraph must be non-null");
        }
        this.graph = graph;
    }

    protected AbstractLayout(NetworkGraph graph, Transformer<Node, Point2D> initializer) {
        this.graph = graph;
        Transformer chain = ChainedTransformer.chainedTransformer((Transformer[])new Transformer[]{initializer});
        this.locations = LazyMap.lazyMap(new HashMap(), (Transformer)chain);
        this.initialized = true;
    }

    protected AbstractLayout(NetworkGraph graph, Dimension size) {
        this.graph = graph;
        this.size = size;
    }

    AbstractLayout(NetworkGraph graph, Transformer<Node, Point2D> initializer, Dimension size) {
        this.graph = graph;
        this.locations = LazyMap.lazyMap(new HashMap(), initializer);
        this.size = size;
    }

    @Override
    public void setGraph(NetworkGraph graph) {
        this.graph = graph;
        if (this.size != null && graph != null) {
            this.initialize();
        }
    }

    @Override
    public void setSize(Dimension size) {
        if (size != null && this.graph != null) {
            Dimension oldSize = this.size;
            this.size = size;
            this.initialize();
            if (oldSize != null) {
                this.adjustLocations(oldSize, size);
            }
        }
    }

    private void adjustLocations(Dimension oldSize, Dimension size) {
        int xOffset = (size.getWidth() - oldSize.getWidth()) / 2;
        int yOffset = (size.getHeight() - oldSize.getHeight()) / 2;
        while (true) {
            try {
                for (Node v : this.getGraph().getNodes()) {
                    this.offsetVertex(v, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException cme) {
                Log.e((String)AbstractLayout.class.getName(), (String)cme.getMessage());
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isLocked(Node v) {
        return this.dontmove.contains(v);
    }

    @Override
    public void setInitializer(Transformer<Node, Point2D> initializer) {
        if (this.equals(initializer)) {
            throw new IllegalArgumentException("Layout cannot be initialized with itself");
        }
        this.locations = LazyMap.lazyMap(new HashMap(), initializer);
        this.initialized = true;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    private Point2D getCoordinates(Node v) {
        return this.locations.get(v);
    }

    public Point2D transform(Node v) {
        return this.getCoordinates(v);
    }

    public double getX(Node v) {
        assert (this.getCoordinates(v) != null) : "Cannot getX for an unmapped vertex " + v;
        return this.getCoordinates(v).getX();
    }

    public double getY(Node v) {
        assert (this.getCoordinates(v) != null) : "Cannot getY for an unmapped vertex " + v;
        return this.getCoordinates(v).getY();
    }

    private void offsetVertex(Node v, double xOffset, double yOffset) {
        Point2D c = this.getCoordinates(v);
        c.setLocation(c.getX() + xOffset, c.getY() + yOffset);
        this.setLocation(v, c);
    }

    @Override
    public NetworkGraph getGraph() {
        return this.graph;
    }

    public void setLocation(Node picked, double x, double y) {
        Point2D coord = this.getCoordinates(picked);
        coord.setLocation(x, y);
    }

    @Override
    public void setLocation(Node picked, Point2D p) {
        Point2D coord = this.getCoordinates(picked);
        coord.setLocation(p);
    }

    @Override
    public void lock(Node v, boolean state) {
        if (state) {
            this.dontmove.add(v);
        } else {
            this.dontmove.remove(v);
        }
    }

    public void lock(boolean lock) {
        for (Node v : this.graph.getNodes()) {
            this.lock(v, lock);
        }
    }
}

