/*
 * Decompiled with CFR 0.152.
 */
package giwi.org.networkgraph.beans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;

public class ArcUtils {
    private ArcUtils() {
    }

    public static void drawArc(PointF e1, PointF e2, float radius, Canvas canvas, Paint paint, Paint textPaint, Paint recPaint, int value) {
        double a1 = Math.toRadians(radius + 5.0f);
        double dx = e2.x - e1.x;
        double dy = e2.y - e1.y;
        double l = Math.sqrt(dx * dx + dy * dy);
        double l1 = l / 2.0;
        double h = l1 / Math.tan(a1 / 2.0);
        double r = l1 / Math.sin(a1 / 2.0);
        double a2 = Math.atan2(dy, dx);
        double a3 = 1.5707963267948966 - a2;
        double mX = (double)(e1.x + e2.x) / 2.0;
        double mY = (double)(e1.y + e2.y) / 2.0;
        double cY = mY + h * Math.sin(a3);
        double cX = mX - h * Math.cos(a3);
        RectF oval = new RectF((float)(cX - r), (float)(cY - r), (float)(cX + r), (float)(cY + r));
        double rawA4 = Math.atan2((double)e1.y - cY, (double)e1.x - cX);
        float a4 = (float)Math.toDegrees(rawA4);
        paint.setStrokeWidth((float)(value + 1));
        ArcUtils.drawArrow(e2.x, e2.y, a4 + radius + 45.0f, paint, canvas);
        canvas.drawArc(oval, a4, radius, false, paint);
        double deltay = -Math.sin(a3) * (r - h);
        double deltax = Math.cos(a3) * (r - h);
        canvas.drawRect((float)(mX + deltax) - 20.0f, (float)(mY + deltay) + 20.0f, (float)(mX + deltax) + 20.0f, (float)(mY + deltay) - 20.0f, recPaint);
        canvas.drawText(String.valueOf(value), (float)(mX + deltax), (float)(mY + deltay) + 10.0f, textPaint);
    }

    private static void drawArrow(float x, float y, float degrees, Paint paint, Canvas canvas) {
        canvas.save();
        canvas.rotate(degrees, x, y);
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo(x - 40.0f, y - 40.0f);
        path.lineTo(x - 60.0f, y - 40.0f);
        path.lineTo(x - 40.0f, y - 60.0f);
        path.lineTo(x - 40.0f, y - 40.0f);
        path.close();
        canvas.drawPath(path, paint);
        canvas.restore();
        paint.setStyle(Paint.Style.STROKE);
    }
}

