/*
 * Decompiled with CFR 0.152.
 */
package giwi.org.networkgraph;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import giwi.org.networkgraph.R;
import giwi.org.networkgraph.beans.ArcUtils;
import giwi.org.networkgraph.beans.Dimension;
import giwi.org.networkgraph.beans.NetworkGraph;
import giwi.org.networkgraph.beans.Point2D;
import giwi.org.networkgraph.beans.Vertex;
import giwi.org.networkgraph.layout.FRLayout;
import net.xqhs.graphs.graph.Edge;

public class GraphSurfaceView
extends SurfaceView {
    private ScaleGestureDetector mScaleDetector;
    private TypedArray attributes;
    private float mScaleFactor = 1.0f;

    public GraphSurfaceView(Context context) {
        super(context);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    }

    public GraphSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.GraphSurfaceView);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    }

    public GraphSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.GraphSurfaceView);
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    }

    public void init(final NetworkGraph graph) {
        this.setZOrderOnTop(true);
        this.getHolder().setFormat(-3);
        this.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                Canvas canvas = holder.lockCanvas(null);
                canvas.drawARGB(0, 225, 225, 255);
                GraphSurfaceView.this.drawGraph(canvas, graph);
                holder.unlockCanvasAndPost(canvas);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
    }

    private void drawGraph(Canvas canvas, NetworkGraph graph) {
        Paint paint = new Paint();
        Paint whitePaint = new Paint();
        paint.setAntiAlias(true);
        FRLayout layout = new FRLayout(graph, new Dimension(this.getWidth(), this.getHeight()));
        whitePaint.setColor(this.attributes.getColor(R.styleable.GraphSurfaceView_nodeBgColor, graph.getNodeBgColor()));
        whitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        whitePaint.setStrokeWidth(2.0f);
        whitePaint.setShadowLayer(5.0f, 0.0f, 0.0f, this.attributes.getColor(R.styleable.GraphSurfaceView_defaultColor, graph.getDefaultColor()));
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(20.0f);
        paint.setColor(this.attributes.getColor(R.styleable.GraphSurfaceView_defaultColor, graph.getDefaultColor()));
        for (Edge edge : graph.getEdges()) {
            Point2D p1 = layout.transform(edge.getFrom());
            Point2D p2 = layout.transform(edge.getTo());
            paint.setStrokeWidth(Float.valueOf(edge.getLabel()).floatValue() + 1.0f);
            paint.setColor(this.attributes.getColor(R.styleable.GraphSurfaceView_edgeColor, graph.getEdgeColor()));
            Paint curve = new Paint();
            curve.setAntiAlias(true);
            curve.setStyle(Paint.Style.STROKE);
            curve.setStrokeWidth(2.0f);
            curve.setColor(this.attributes.getColor(R.styleable.GraphSurfaceView_edgeColor, graph.getEdgeColor()));
            PointF e1 = new PointF((float)p1.getX(), (float)p1.getY());
            PointF e2 = new PointF((float)p2.getX(), (float)p2.getY());
            ArcUtils.drawArc(e1, e2, 36.0f, canvas, curve, paint, whitePaint, Integer.parseInt(edge.getLabel()));
        }
        paint.setStyle(Paint.Style.FILL);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(30.0f);
        paint.setStrokeWidth(0.0f);
        paint.setColor(this.attributes.getColor(R.styleable.GraphSurfaceView_nodeColor, graph.getNodeColor()));
        for (Vertex node : graph.getVertex()) {
            Point2D position = layout.transform(node.getNode());
            canvas.drawCircle((float)position.getX(), (float)position.getY(), 40.0f, whitePaint);
            if (node.getIcon() != null) {
                Bitmap b = ((BitmapDrawable)node.getIcon()).getBitmap();
                Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
                Bitmap roundBitmap = this.getCroppedBitmap(bitmap, 75);
                canvas.drawBitmap(roundBitmap, (float)position.getX() - 38.0f, (float)position.getY() - 38.0f, null);
            }
            canvas.drawRect((float)position.getX() - 20.0f, (float)position.getY() + 50.0f, (float)position.getX() + 20.0f, (float)position.getY() + 10.0f, whitePaint);
            canvas.drawText(node.getNode().getLabel(), (float)position.getX(), (float)position.getY() + 40.0f, paint);
        }
    }

    private Bitmap getCroppedBitmap(Bitmap bmp, int radius) {
        Bitmap sbmp = bmp.getWidth() != radius || bmp.getHeight() != radius ? Bitmap.createScaledBitmap((Bitmap)bmp, (int)radius, (int)radius, (boolean)false) : bmp;
        Bitmap output = Bitmap.createBitmap((int)sbmp.getWidth(), (int)sbmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, sbmp.getWidth(), sbmp.getHeight());
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(sbmp.getWidth() / 2) + 0.7f, (float)(sbmp.getHeight() / 2) + 0.7f, (float)(sbmp.getWidth() / 2) + 0.1f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(sbmp, rect, rect, paint);
        return output;
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        this.mScaleDetector.onTouchEvent(ev);
        return true;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            GraphSurfaceView.this.mScaleFactor = GraphSurfaceView.this.mScaleFactor * detector.getScaleFactor();
            GraphSurfaceView.this.mScaleFactor = Math.max(0.1f, Math.min(GraphSurfaceView.this.mScaleFactor, 5.0f));
            GraphSurfaceView.this.invalidate();
            return true;
        }
    }
}

