/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.text;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.SimpleNode;
import net.xqhs.graphs.pattern.NodeP;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.RepresentationElement;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.text.SettableEdge;
import net.xqhs.graphs.representation.text.TextGraphRepresentation;
import net.xqhs.graphs.util.ContentHolder;
import net.xqhs.util.logging.UnitComponent;

public class TextRepresentationElement
extends RepresentationElement {
    public static final String DEFAULT_INDENT = "";
    public static final String DEFAULT_INDENT_INCREMENT = " ";
    public static final int DEFAULT_INDENT_LIMIT = 3;
    int nestingLevel = 0;
    boolean isLastChild = false;
    boolean isOnlyChild = false;
    boolean isFirstSubgraph = false;
    Type linkType;
    List<TextRepresentationElement> content = new LinkedList<TextRepresentationElement>();

    public TextRepresentationElement(GraphRepresentation root, Type type) {
        this(root, null, type, 0, false, false, false);
        if (type != Type.ELEMENT_CONTAINER) {
            throw new IllegalArgumentException();
        }
    }

    public TextRepresentationElement(GraphRepresentation root, Type type, boolean first) {
        this(root, null, type, 0, false, false, first);
        if (type != Type.SUBGRAPH) {
            throw new IllegalArgumentException();
        }
    }

    public TextRepresentationElement(GraphRepresentation root, VisualizableGraphComponent representedEdge, Type type, int level, boolean lastChild, boolean alone) {
        this(root, representedEdge, type, level, lastChild, alone, false);
        if (!TextRepresentationElement.isEdgeType(type)) {
            throw new IllegalArgumentException();
        }
    }

    public TextRepresentationElement(GraphRepresentation root, VisualizableGraphComponent representedNode, Type type) {
        this(root, representedNode, type, 0, false, false, false);
        if (type != Type.NODE) {
            throw new IllegalArgumentException();
        }
    }

    protected TextRepresentationElement(GraphRepresentation root, VisualizableGraphComponent representedElement, Type type, int level, boolean lastChild, boolean alone, boolean firstSubgraph) {
        super(root, representedElement);
        this.linkType = type;
        this.nestingLevel = level;
        this.isLastChild = lastChild;
        this.isOnlyChild = alone;
        this.isFirstSubgraph = firstSubgraph;
        if (this.getRepresentedComponent() != null) {
            this.getRepresentedComponent().addRepresentation(this);
        }
    }

    protected TextRepresentationElement addSub(TextRepresentationElement sub) {
        this.content.add(sub);
        return this;
    }

    protected TextRepresentationElement addSub(List<TextRepresentationElement> subs) {
        this.content.addAll(subs);
        return this;
    }

    public String toString() {
        return this.toString(DEFAULT_INDENT, DEFAULT_INDENT_INCREMENT, 3, false);
    }

    public String toString(String indent, String indentIncrement, int indentLimit, boolean isBackwards) {
        String displayedIndent = indent;
        String displayedIndentIncrement = indentIncrement;
        int nextIndentLimit = indentLimit;
        String ret = DEFAULT_INDENT;
        if (this.linkType == Type.SUBGRAPH && !this.isFirstSubgraph) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.SUBGRAPH_SEPARATOR);
        }
        if (indentLimit == 0) {
            displayedIndent = DEFAULT_INDENT;
            displayedIndentIncrement = DEFAULT_INDENT;
        }
        if (!(this.isOnlyChild || this.linkType == Type.NODE || this.linkType == Type.ELEMENT_CONTAINER || this.linkType == Type.SUBGRAPH && this.isFirstSubgraph)) {
            ret = String.valueOf(ret) + displayedIndent;
        }
        if (this.linkType != Type.ELEMENT_CONTAINER && this.content.size() > 1) {
            displayedIndent = String.valueOf(displayedIndent) + displayedIndentIncrement;
        }
        if (TextRepresentationElement.isEdgeType(this.linkType)) {
            nextIndentLimit = indentLimit - 1;
        }
        if (this.linkType == Type.ELEMENT_CONTAINER) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.ELEMENT_CONTAINER_IN);
        }
        if (TextRepresentationElement.isEdgeType(this.linkType) && !this.isOnlyChild && !this.isLastChild) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.BRANCH_IN);
        }
        if (TextRepresentationElement.isEdgeType(this.linkType)) {
            if (isBackwards) {
                ret = String.valueOf(ret) + (Object)((Object)Symbol.EDGE_ENDING_BACKWARD);
            }
            ret = String.valueOf(ret) + (Object)((Object)Symbol.EDGE_LIMIT);
            if (((Edge)((Object)this.getRepresentedComponent())).getLabel() != null) {
                ret = String.valueOf(ret) + ((Edge)((Object)this.getRepresentedComponent())).getLabel() + (Object)((Object)Symbol.EDGE_LIMIT);
            }
            if (!isBackwards) {
                ret = String.valueOf(ret) + (Object)((Object)Symbol.EDGE_ENDING_FORWARD);
            }
        }
        if (this.linkType == Type.EXTERNAL_LINK) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.EXTERNAL_LINK_PREFIX);
        }
        if (this.linkType == Type.INTERNAL_LINK) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.INTERNAL_LINK_PREFIX);
        }
        if (this.linkType == Type.NODE) {
            if (this.getRepresentedComponent() == null) {
                ret = String.valueOf(ret) + "<null>";
            } else {
                String rendition = this.getRepresentedComponent().toString();
                ret = String.valueOf(ret) + rendition;
            }
        }
        if (this.content != null) {
            for (TextRepresentationElement el : this.content) {
                ret = String.valueOf(ret) + el.toString(displayedIndent, displayedIndentIncrement, nextIndentLimit, isBackwards);
            }
        }
        if (TextRepresentationElement.isEdgeType(this.linkType) && !this.isOnlyChild && !this.isLastChild) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.BRANCH_OUT);
        }
        if (this.linkType == Type.ELEMENT_CONTAINER) {
            ret = String.valueOf(ret) + (Object)((Object)Symbol.ELEMENT_CONTAINER_OUT);
        }
        return ret;
    }

    protected static boolean isEdgeType(Type elementType) {
        return elementType == Type.INTERNAL_LINK || elementType == Type.EXTERNAL_LINK || elementType == Type.BRANCH;
    }

    protected static TextRepresentationElement readRepresentation(String input, TextGraphRepresentation root, UnitComponent log) {
        return TextRepresentationElement.readRepresentation(new ContentHolder<String>(input), Type.ELEMENT_CONTAINER, true, root, log);
    }

    protected static TextRepresentationElement readRepresentation(ContentHolder<String> input, TextGraphRepresentation root, UnitComponent log) {
        return TextRepresentationElement.readRepresentation(input, Type.ELEMENT_CONTAINER, true, root, log);
    }

    protected static TextRepresentationElement readRepresentation(ContentHolder<String> input, Type type, boolean firstSibling, TextGraphRepresentation root, UnitComponent log) {
        log.lf("reading [] from []", new Object[]{type, input});
        TextRepresentationElement ret = null;
        int nChildren = 0;
        switch (type) {
            case ELEMENT_CONTAINER: {
                String rest = null;
                if (input.get().trim().startsWith(Symbol.ELEMENT_CONTAINER_IN.toString())) {
                    String str = input.get();
                    str = str.substring(str.indexOf(Symbol.ELEMENT_CONTAINER_IN.toString()) + Symbol.ELEMENT_CONTAINER_IN.toString().length());
                    int lastIndex = TextRepresentationElement.getFirstUnmatchedClosingSymbolIndex(str, Symbol.ELEMENT_CONTAINER_IN.toString(), Symbol.ELEMENT_CONTAINER_OUT.toString());
                    rest = str.substring(lastIndex + Symbol.ELEMENT_CONTAINER_OUT.toString().length());
                    str = str.substring(0, lastIndex);
                    input.set(str);
                }
                ret = new TextRepresentationElement((GraphRepresentation)root, type);
                while (input.get().length() > 0) {
                    ret.addSub(TextRepresentationElement.readRepresentation(input, Type.SUBGRAPH, nChildren++ == 0, root, log));
                }
                if (rest == null) break;
                input.set(rest);
                break;
            }
            case SUBGRAPH: {
                String[] rez = input.get().split(Symbol.SUBGRAPH_SEPARATOR.toRegexp(), 2);
                if (rez.length > 0 && rez[0].length() > 0) {
                    input.set(rez[0]);
                    log.li("create new subgraph", new Object[0]);
                    ret = new TextRepresentationElement((GraphRepresentation)root, Type.SUBGRAPH, firstSibling);
                    ret.addSub(TextRepresentationElement.readRepresentation(input, Type.NODE, true, root, log));
                }
                if (rez.length > 1) {
                    input.set(rez[1]);
                    break;
                }
                input.set(DEFAULT_INDENT);
                break;
            }
            case BRANCH: 
            case INTERNAL_LINK: 
            case EXTERNAL_LINK: {
                Type edgeType;
                String edgeLabel;
                String nextNode;
                int lastIndex;
                int firstIndex;
                String[] rez;
                boolean isLastChild;
                String rest;
                String branchString;
                input.set(input.get().trim());
                if (input.get().startsWith(Symbol.BRANCH_IN.toString())) {
                    String open = Symbol.BRANCH_IN.toString();
                    String close = Symbol.BRANCH_OUT.toString();
                    int lastIndex2 = TextRepresentationElement.getFirstUnmatchedClosingSymbolIndex(input.get().substring(open.length()), open, close);
                    branchString = input.get().substring(open.length(), lastIndex2 + open.length()).trim();
                    rest = input.get().substring(lastIndex2 + open.length() + close.length());
                    isLastChild = false;
                } else {
                    branchString = input.get().trim();
                    rest = DEFAULT_INDENT;
                    isLastChild = true;
                }
                log.lf("identified [] edge []", new Object[]{isLastChild ? "last" : DEFAULT_INDENT, branchString});
                if (!root.isBackwards()) {
                    rez = branchString.split(Symbol.EDGE_ENDING_FORWARD.toRegexp(), 2);
                    firstIndex = rez[0].indexOf(Symbol.EDGE_LIMIT.toString()) + Symbol.EDGE_LIMIT.toString().length();
                    if (rez[0].length() == 0) {
                        lastIndex = -1;
                    } else {
                        if (rez.length < 2) {
                            throw new IllegalArgumentException("No ending for edge.");
                        }
                        lastIndex = rez[0].substring(rez[0].length() - 1).equals(Symbol.EDGE_LIMIT.toString()) ? rez[0].length() - 1 : rez[0].length();
                    }
                    nextNode = rez[1].trim();
                } else {
                    branchString = branchString.substring(Symbol.EDGE_ENDING_BACKWARD.toString().length());
                    rez = branchString.split(Symbol.EDGE_ENDING_BACKWARD.toRegexp(), 2);
                    lastIndex = rez[0].lastIndexOf(Symbol.EDGE_LIMIT.toString());
                    firstIndex = rez[0].startsWith(Symbol.EDGE_LIMIT.toString()) ? Symbol.EDGE_LIMIT.toString().length() : 0;
                    nextNode = branchString.substring(lastIndex + Symbol.EDGE_LIMIT.toString().length()).trim();
                }
                if (firstIndex <= lastIndex) {
                    edgeLabel = branchString.substring(firstIndex, lastIndex).trim();
                    if (edgeLabel.length() == 0) {
                        edgeLabel = null;
                    }
                } else {
                    edgeLabel = null;
                }
                String edgeTypeChar = DEFAULT_INDENT;
                if (nextNode.startsWith(Symbol.EXTERNAL_LINK_PREFIX.toString())) {
                    edgeType = Type.EXTERNAL_LINK;
                    nextNode = nextNode.substring(Symbol.EXTERNAL_LINK_PREFIX.toString().length());
                    edgeTypeChar = Symbol.EXTERNAL_LINK_PREFIX.toString();
                } else if (nextNode.startsWith(Symbol.INTERNAL_LINK_PREFIX.toString())) {
                    edgeType = Type.INTERNAL_LINK;
                    nextNode = nextNode.substring(Symbol.INTERNAL_LINK_PREFIX.toString().length());
                    edgeTypeChar = Symbol.INTERNAL_LINK_PREFIX.toString();
                } else {
                    edgeType = Type.BRANCH;
                }
                log.li("create new [][] edge: [].", new Object[]{edgeTypeChar, edgeType, edgeLabel});
                SettableEdge edge = new SettableEdge(edgeLabel);
                ret = new TextRepresentationElement(root, edge, edgeType, -1, isLastChild, isLastChild && firstSibling);
                ret.addSub(TextRepresentationElement.readRepresentation(input.set(nextNode), Type.NODE, true, root, log));
                input.set(rest);
                break;
            }
            case NODE: {
                String regex = String.valueOf(Symbol.EDGE_LIMIT.toRegexp()) + "|" + Symbol.BRANCH_IN.toRegexp() + "|" + Symbol.EDGE_ENDING_FORWARD.toRegexp() + "|" + Symbol.EDGE_ENDING_BACKWARD.toRegexp();
                String[] parts = input.get().split(regex, 2);
                String nodeName = parts[0].trim();
                if (nodeName.length() == 0) {
                    throw new IllegalArgumentException("Node name is empty.");
                }
                SimpleNode node = null;
                if (nodeName.startsWith("?") && nodeName.substring("?".length()).startsWith("#")) {
                    int index = Integer.parseInt(nodeName.substring("?".length() + "#".length()));
                    log.li("create new pattern node #[]", new Object[]{new Integer(index)});
                    node = new NodeP(index);
                } else {
                    log.li("create new node: []", new Object[]{nodeName});
                    node = new SimpleNode(nodeName);
                }
                ret = new TextRepresentationElement((GraphRepresentation)root, node, Type.NODE);
                if (parts.length <= 1) break;
                input.set(input.get().substring(parts[0].length()));
                while (input.get().length() > 0) {
                    ret.addSub(TextRepresentationElement.readRepresentation(input, Type.BRANCH, nChildren++ == 0, root, log));
                }
                break;
            }
        }
        return ret;
    }

    protected static int getFirstUnmatchedClosingSymbolIndex(String input, String openingSymbol, String closingSymbol) {
        int openlen = openingSymbol.length();
        int closelen = closingSymbol.length();
        int lastIndex = 0;
        int openEnclosures = 0;
        int pastLength = 0;
        String str = input;
        while (lastIndex == 0) {
            int openIndex = str.indexOf(openingSymbol);
            int closeIndex = str.indexOf(closingSymbol);
            if (openIndex >= 0 && openIndex < closeIndex) {
                ++openEnclosures;
                pastLength += openIndex + openlen;
                str = str.substring(openIndex + openlen);
                continue;
            }
            if (openEnclosures == 0) {
                lastIndex = pastLength + closeIndex;
                continue;
            }
            --openEnclosures;
            pastLength += closeIndex + closelen;
            str = str.substring(closeIndex + closelen);
        }
        return lastIndex;
    }

    public static enum Symbol {
        ELEMENT_CONTAINER_IN("["),
        ELEMENT_CONTAINER_OUT("]"),
        SUBGRAPH_SEPARATOR(";"),
        INTERNAL_LINK_PREFIX("*"),
        EXTERNAL_LINK_PREFIX("^"),
        BRANCH_IN("("),
        BRANCH_OUT(")"),
        EDGE_LIMIT("-"),
        EDGE_ENDING_FORWARD(">"),
        EDGE_ENDING_BACKWARD("<");

        private String symbol;

        private Symbol(String symb) {
            this.symbol = symb;
        }

        public String toString() {
            return this.symbol;
        }

        public String toRegexp() {
            return Pattern.quote(this.symbol);
        }
    }

    public static enum Type {
        NODE,
        BRANCH,
        INTERNAL_LINK,
        EXTERNAL_LINK,
        SUBGRAPH,
        ELEMENT_CONTAINER;

    }
}

