/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.HyperNode;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.SimpleNode;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.graphs.pattern.NodeP;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.RepresentationElement;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.linear.LinearGraphRepresentation;
import net.xqhs.graphs.representation.linear.PathElement;
import net.xqhs.graphs.representation.text.SettableEdge;
import net.xqhs.graphs.representation.text.TextRepresentationElement;
import net.xqhs.graphs.util.ContentHolder;
import net.xqhs.util.logging.LoggerSimple;
import net.xqhs.util.logging.UnitComponent;

public class TextGraphRepresentation
extends LinearGraphRepresentation {
    public static final String DEFAULT_BRANCH_SEPARATOR = "";
    public static final String DEFAULT_SEPARATOR_INCREMENT = "";
    public static final int DEFAULT_INCREMENT_LIMIT = -1;
    protected String indent = "";
    protected String indentIncrement = "";
    protected int incrementLimit = -1;

    public TextGraphRepresentation(Graph graph) {
        super(graph);
    }

    public TextGraphRepresentation setLayout(String branchSeparator, String separatorIncrement, int limit) {
        if (branchSeparator != null) {
            this.indent = branchSeparator;
        }
        if (separatorIncrement != null) {
            this.indentIncrement = separatorIncrement;
        }
        this.incrementLimit = limit;
        return this;
    }

    @Override
    protected String setDefaultName(String name) {
        return String.valueOf(super.setDefaultName(name)) + "T";
    }

    @Override
    protected void processGraph() {
        super.processGraph();
        HashSet<PathElement> blackNodes = new HashSet<PathElement>();
        TextRepresentationElement textRepresentation = new TextRepresentationElement((GraphRepresentation)this, TextRepresentationElement.Type.ELEMENT_CONTAINER);
        boolean first = true;
        for (PathElement el : this.paths) {
            if (blackNodes.contains(el)) continue;
            TextRepresentationElement nodeRepr = new TextRepresentationElement((GraphRepresentation)this, (VisualizableGraphComponent)((Object)el.getNode()), TextRepresentationElement.Type.NODE);
            blackNodes.add(el);
            nodeRepr.addSub(this.buildTextChildren(el, 1, blackNodes));
            TextRepresentationElement repr = new TextRepresentationElement((GraphRepresentation)this, TextRepresentationElement.Type.SUBGRAPH, first);
            repr.addSub(nodeRepr);
            textRepresentation.addSub(repr);
            first = false;
        }
        this.theRepresentation = textRepresentation;
    }

    protected List<TextRepresentationElement> buildTextChildren(PathElement el, int level, Set<PathElement> blackNodes) {
        int allchildren;
        LinkedList<TextRepresentationElement> ret = new LinkedList<TextRepresentationElement>();
        int remainingChildren = allchildren = el.getOtherChildren().size() + el.getChildren().size();
        LinkedList<PathElement> others = new LinkedList<PathElement>(el.getOtherChildren());
        for (PathElement child : el.getChildren()) {
            while (!others.isEmpty() && blackNodes.contains(others.get(0))) {
                --remainingChildren;
                PathElement other = (PathElement)others.get(0);
                for (Edge edge : this.isBackwards ? this.theGraph.getInEdges(el.getNode()) : this.theGraph.getOutEdges(el.getNode())) {
                    if ((!this.isBackwards || edge.getFrom() != other.getNode()) && (this.isBackwards || edge.getTo() != other.getNode())) continue;
                    TextRepresentationElement repr = new TextRepresentationElement(this, (VisualizableGraphComponent)((Object)edge), TextRepresentationElement.Type.INTERNAL_LINK, level, remainingChildren <= 0, allchildren == 1);
                    repr.addSub(new TextRepresentationElement((GraphRepresentation)this, (VisualizableGraphComponent)((Object)other.getNode()), TextRepresentationElement.Type.NODE));
                    ret.add(repr);
                }
                others.remove(0);
            }
            --remainingChildren;
            boolean first = true;
            for (Edge edge : this.isBackwards ? this.theGraph.getInEdges(el.getNode()) : this.theGraph.getOutEdges(el.getNode())) {
                if ((!this.isBackwards || edge.getFrom() != child.getNode()) && (this.isBackwards || edge.getTo() != child.getNode())) continue;
                TextRepresentationElement.Type type = first ? TextRepresentationElement.Type.BRANCH : TextRepresentationElement.Type.INTERNAL_LINK;
                TextRepresentationElement reprEdge = new TextRepresentationElement(this, (VisualizableGraphComponent)((Object)edge), type, level, remainingChildren <= 0, allchildren == 1);
                TextRepresentationElement reprNode = new TextRepresentationElement((GraphRepresentation)this, (VisualizableGraphComponent)((Object)child.getNode()), TextRepresentationElement.Type.NODE);
                if (first) {
                    blackNodes.add(child);
                }
                first = false;
                reprEdge.addSub(reprNode);
                reprNode.addSub(this.buildTextChildren(child, level + 1, blackNodes));
                ret.add(reprEdge);
            }
            if (!(child.getNode() instanceof HyperNode)) continue;
            TextRepresentationElement textRepresentation = new TextRepresentationElement((GraphRepresentation)this, TextRepresentationElement.Type.ELEMENT_CONTAINER);
            first = true;
            for (PathElement elsub : this.paths) {
                if (blackNodes.contains(elsub)) continue;
                TextRepresentationElement nodeRepr = new TextRepresentationElement((GraphRepresentation)this, (VisualizableGraphComponent)((Object)elsub.getNode()), TextRepresentationElement.Type.NODE);
                blackNodes.add(elsub);
                nodeRepr.addSub(this.buildTextChildren(elsub, 1, blackNodes));
                TextRepresentationElement repr = new TextRepresentationElement((GraphRepresentation)this, TextRepresentationElement.Type.SUBGRAPH, first);
                repr.addSub(nodeRepr);
                textRepresentation.addSub(repr);
                first = false;
            }
        }
        while (!others.isEmpty()) {
            --remainingChildren;
            PathElement other = (PathElement)others.get(0);
            boolean external = !blackNodes.contains(other);
            for (Edge edge : this.isBackwards ? this.theGraph.getInEdges(el.getNode()) : this.theGraph.getOutEdges(el.getNode())) {
                if ((!this.isBackwards || edge.getFrom() != other.getNode()) && (this.isBackwards || edge.getTo() != other.getNode())) continue;
                TextRepresentationElement repr = new TextRepresentationElement(this, (VisualizableGraphComponent)((Object)edge), external ? TextRepresentationElement.Type.EXTERNAL_LINK : TextRepresentationElement.Type.INTERNAL_LINK, level, remainingChildren <= 0, allchildren == 1);
                repr.addSub(new TextRepresentationElement((GraphRepresentation)this, (VisualizableGraphComponent)((Object)other.getNode()), TextRepresentationElement.Type.NODE));
                ret.add(repr);
            }
            blackNodes.add(other);
            others.remove(0);
        }
        return ret;
    }

    public String toString() {
        return this.displayRepresentation();
    }

    @Override
    public RepresentationElement getRepresentation() {
        return this.theRepresentation;
    }

    @Override
    public boolean isBackwards() {
        return this.isBackwards;
    }

    @Override
    public String displayRepresentation() {
        String firstIndent;
        String string = firstIndent = this.indent.contains("\n") ? this.indent : "";
        if (this.theRepresentation != null) {
            return String.valueOf(firstIndent) + ((TextRepresentationElement)this.theRepresentation).toString(this.indent, this.indentIncrement, this.incrementLimit, this.isBackwards);
        }
        this.le("representation not computed (use update()).", new Object[0]);
        return null;
    }

    public Graph readRepresentation(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        catch (IOException e) {
            this.le("Reading file failed: " + e.toString(), new Object[0]);
            return null;
        }
        return this.readRepresentation(builder.toString());
    }

    public Graph readRepresentation(String rawInput) {
        return this.readRepresentation(new ContentHolder<String>(rawInput));
    }

    public Graph readRepresentation(ContentHolder<String> input) {
        boolean backwards;
        this.lf("reading graph", new Object[]{input.get()});
        if (input.get().trim().length() == 0) {
            this.le("input is empty.", new Object[0]);
            return null;
        }
        boolean bl = backwards = input.get().indexOf(TextRepresentationElement.Symbol.EDGE_ENDING_BACKWARD.toString()) >= 0;
        if (backwards && input.get().indexOf(TextRepresentationElement.Symbol.EDGE_ENDING_FORWARD.toString()) >= 0) {
            return (Graph)this.lr(null, "Representation contains both forward and backward edges.", new Object[0]);
        }
        this.setBackwards(backwards);
        TextRepresentationElement rootRepr = TextRepresentationElement.readRepresentation(input, this, (UnitComponent)new UnitComponent().setUnitName("theDefaulUnitName").setLink(this.getUnitName()).setLogLevel(LoggerSimple.Level.WARN));
        this.theRepresentation = rootRepr;
        this.lf("result: [] \n====================================", new Object[]{((Object)((Object)this.theRepresentation)).toString()});
        return this.buildGraph(rootRepr);
    }

    protected Graph buildGraph(TextRepresentationElement rootRepresentation) {
        Stack tree = new Stack();
        Queue cLevel = new LinkedList<TextRepresentationElement>();
        LinkedList<TextRepresentationElement> nLevel = null;
        cLevel.add((TextRepresentationElement)this.theRepresentation);
        tree.add(cLevel);
        block6: while (!tree.isEmpty()) {
            cLevel = (Queue)tree.peek();
            this.lf("inspecting tree at level []", new Object[]{new Integer(tree.size())});
            if (cLevel.isEmpty()) {
                tree.pop();
                continue;
            }
            this.lf("[] element(s) left to inspect", new Object[]{new Integer(cLevel.size())});
            TextRepresentationElement element = (TextRepresentationElement)((Object)cLevel.poll());
            TextRepresentationElement.Type type = element.linkType;
            switch (type) {
                case SUBGRAPH: 
                case ELEMENT_CONTAINER: {
                    this.lf("inspecting []", new Object[]{type});
                    nLevel = new LinkedList<TextRepresentationElement>();
                    nLevel.addAll(element.content);
                    tree.push(nLevel);
                    break;
                }
                case NODE: {
                    Node node = (Node)((Object)element.getRepresentedComponent());
                    this.lf("inspecting []: []", new Object[]{type, node});
                    this.li("adding to graph node []", new Object[]{node});
                    if (node instanceof NodeP && ((NodeP)node).isGeneric() && ((NodeP)node).genericIndex() > 0) {
                        ((GraphPattern)this.theGraph).addNode(node, false);
                    } else {
                        this.theGraph.addNode(node);
                    }
                    if (element.content.isEmpty()) continue block6;
                    nLevel = new LinkedList();
                    tree.push(nLevel);
                    for (TextRepresentationElement edgeEl : element.content) {
                        SettableEdge edge = (SettableEdge)edgeEl.getRepresentedComponent();
                        if (!this.isBackwards) {
                            edge.setFrom(node);
                        } else {
                            edge.setTo(node);
                        }
                        this.lf("adding to queue []: []", new Object[]{edgeEl.linkType, edge});
                        nLevel.add(edgeEl);
                    }
                    continue block6;
                }
                case BRANCH: 
                case INTERNAL_LINK: {
                    SettableEdge edge = (SettableEdge)element.getRepresentedComponent();
                    this.lf("inspecting []: []", new Object[]{type, edge});
                    Node targetNode = null;
                    if (element.content.isEmpty()) {
                        throw new IllegalArgumentException("Edge representation element contains no target");
                    }
                    TextRepresentationElement targetNodeEl = element.content.iterator().next();
                    if (element.linkType == TextRepresentationElement.Type.INTERNAL_LINK) {
                        Node dummyTargetNode = (Node)((Object)targetNodeEl.getRepresentedComponent());
                        if (dummyTargetNode instanceof NodeP && ((NodeP)dummyTargetNode).isGeneric()) {
                            this.lf("searching pattern target node []", new Object[]{dummyTargetNode});
                            for (Node candidateNode : this.theGraph.getNodesNamed(dummyTargetNode.getLabel())) {
                                if (!(candidateNode instanceof NodeP) || ((NodeP)dummyTargetNode).genericIndex() != ((NodeP)candidateNode).genericIndex()) continue;
                                targetNode = candidateNode;
                            }
                            if (targetNode == null) {
                                throw new IllegalArgumentException("Target pattern node [" + dummyTargetNode + "] not found in the graph.");
                            }
                            this.lf("found old target pattern node []", new Object[]{targetNode});
                        } else {
                            this.lf("searching target node []", new Object[]{dummyTargetNode});
                            Collection<Node> candidates = this.theGraph.getNodesNamed(dummyTargetNode.getLabel());
                            if (candidates.isEmpty()) {
                                throw new IllegalArgumentException("Target pattern node [" + dummyTargetNode + "] not found in the graph.");
                            }
                            targetNode = candidates.iterator().next();
                            this.lf("found old target node []", new Object[]{targetNode});
                        }
                    } else {
                        targetNode = (SimpleNode)targetNodeEl.getRepresentedComponent();
                        if (!this.theGraph.getNodesNamed(targetNode.getLabel()).isEmpty()) {
                            if (targetNode instanceof NodeP) {
                                Collection<Node> similarNodes = this.theGraph.getNodesNamed(targetNode.getLabel());
                                for (Node n : similarNodes) {
                                    if (((NodeP)n).genericIndex() != ((NodeP)targetNode).genericIndex()) continue;
                                    throw new IllegalArgumentException("Node [" + targetNode.toString() + "] already present in the graph by not referred as internal link.");
                                }
                            } else {
                                throw new IllegalArgumentException("Node [" + targetNode.toString() + "] already present in the graph by not referred as internal link.");
                            }
                        }
                        nLevel = new LinkedList();
                        nLevel.add(targetNodeEl);
                        tree.push(nLevel);
                        this.lf("target node added to queue []", new Object[]{targetNode});
                    }
                    if (!this.isBackwards) {
                        edge.setTo(targetNode);
                    } else {
                        edge.setFrom(targetNode);
                    }
                    this.li("adding to graph edge []", new Object[]{edge});
                    this.theGraph.addEdge(edge.toSimpleEdge());
                    break;
                }
                case EXTERNAL_LINK: {
                    this.le("external links not supported", new Object[0]);
                }
            }
        }
        return this.theGraph;
    }
}

