/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.multilevel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.SimpleGraph;
import net.xqhs.graphs.representation.GraphRepresentationImplementation;

public abstract class MultilevelGraphRepresentation
extends GraphRepresentationImplementation {
    protected List<Map<Node, Node>> levelNodes = null;
    protected List<Map<Node, Graph>> theLevels = null;

    public MultilevelGraphRepresentation(Graph graph, List<Map<Node, Node>> nodeLevels) {
        super(graph);
        this.levelNodes = new Vector<Map<Node, Node>>(nodeLevels);
    }

    @Override
    protected void processGraph() {
        this.theLevels = new ArrayList<Map<Node, Graph>>(this.levelNodes.size());
        for (Map<Node, Node> level : this.levelNodes) {
            HashMap<Node, SimpleGraph> graphs = new HashMap<Node, SimpleGraph>();
            this.theLevels.add(graphs);
            for (Map.Entry<Node, Node> memberShip : level.entrySet()) {
                if (!graphs.containsKey(memberShip.getValue())) {
                    graphs.put(memberShip.getValue(), new SimpleGraph());
                }
                ((Graph)graphs.get(memberShip.getValue())).addNode(memberShip.getKey());
            }
            for (Graph graph : graphs.values()) {
                for (Edge edge : this.theGraph.getEdges()) {
                    if (!graph.contains(edge.getTo()) || !graph.contains(edge.getFrom())) continue;
                    graph.addEdge(edge);
                }
            }
        }
    }
}

