/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.linear;

import java.util.LinkedList;
import java.util.List;
import net.xqhs.graphs.graph.Node;

public class PathElement {
    Node node = null;
    int depth = 0;
    int forwardLength = -1;
    PathElement parent = null;
    List<PathElement> children = new LinkedList<PathElement>();
    List<PathElement> otherChildren = new LinkedList<PathElement>();

    public PathElement(Node node, int distance, PathElement parent) {
        this.node = node;
        this.depth = distance;
        this.parent = parent;
    }

    public boolean pathContains(PathElement el1) {
        PathElement el = this;
        while (el.parent != null) {
            if (el == el1) {
                return true;
            }
            el = el.parent;
        }
        return el == el1;
    }

    public String toString() {
        if (this.node == null) {
            return "<corrupt>";
        }
        return String.valueOf(this.node.toString()) + "(" + this.depth + ":" + (this.parent != null ? this.parent.node.toString() : "-") + (!this.children.isEmpty() ? "/" + this.children.size() : ".") + (this.otherChildren.isEmpty() ? "" : "+" + this.otherChildren.size()) + "/" + this.forwardLength + ")";
    }

    public Node getNode() {
        return this.node;
    }

    public List<PathElement> getChildren() {
        return this.children;
    }

    public List<PathElement> getOtherChildren() {
        return this.otherChildren;
    }
}

