/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.linear;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.NodeAlphaComparator;
import net.xqhs.graphs.representation.GraphRepresentationImplementation;
import net.xqhs.graphs.representation.linear.PathElement;

public abstract class LinearGraphRepresentation
extends GraphRepresentationImplementation {
    protected boolean isBackwards = false;
    protected List<Node> sortedNodes = null;
    protected List<PathElement> paths = null;

    public LinearGraphRepresentation(Graph graph) {
        super(graph);
    }

    public LinearGraphRepresentation setBackwards() {
        return this.setBackwards(true);
    }

    public LinearGraphRepresentation setBackwards(boolean back) {
        this.isBackwards = back;
        return this;
    }

    public boolean isBackwards() {
        return this.isBackwards;
    }

    @Override
    protected String setDefaultName(String name) {
        return String.valueOf(super.setDefaultName(name)) + "Lin";
    }

    @Override
    protected void processGraph() {
        super.processGraph();
        this.sortedNodes = new LinkedList<Node>(this.theGraph.getNodes());
        Collections.sort(this.sortedNodes, new NodeInAlphaComparator(this.theGraph));
        this.lf("sorted nodes: " + this.sortedNodes, new Object[0]);
        this.buildPaths();
    }

    protected void buildPaths() {
        LinkedList<PathElement> grayNodes = new LinkedList<PathElement>();
        LinkedList<PathElement> blackNodes = new LinkedList<PathElement>();
        while (blackNodes.size() < this.sortedNodes.size()) {
            for (Node node : this.sortedNodes) {
                boolean found = false;
                for (PathElement pathElement : blackNodes) {
                    if (pathElement.node != node) continue;
                    found = true;
                }
                if (found) continue;
                grayNodes.add(new PathElement(node, 0, null));
                break;
            }
            while (!grayNodes.isEmpty()) {
                PathElement el = (PathElement)grayNodes.poll();
                this.lf("taking element " + el, new Object[0]);
                LinkedList<Node> childSet = new LinkedList<Node>();
                if (!this.isBackwards) {
                    for (Edge e : this.theGraph.getOutEdges(el.node)) {
                        childSet.add(e.getTo());
                    }
                } else {
                    for (Edge e : this.theGraph.getInEdges(el.node)) {
                        childSet.add(e.getFrom());
                    }
                }
                Collections.sort(childSet, new NodeInAlphaComparator(this.theGraph));
                for (Node n1 : childSet) {
                    boolean towardsoutside = false;
                    if (!this.theGraph.contains(n1)) {
                        towardsoutside = true;
                    }
                    PathElement el1 = null;
                    boolean wasinblacknodes = false;
                    for (PathElement eli : grayNodes) {
                        if (eli.node != n1) continue;
                        el1 = eli;
                    }
                    for (PathElement eli : blackNodes) {
                        if (eli.node != n1) continue;
                        el1 = eli;
                        wasinblacknodes = true;
                        this.lf("(element " + el1 + " was black)", new Object[0]);
                    }
                    if (el1 == null) {
                        el1 = new PathElement(n1, el.depth + 1, el);
                        if (!towardsoutside) {
                            this.lf("new gray node added: " + el1 + " of " + el, new Object[0]);
                            grayNodes.add(el1);
                            el.children.add(el1);
                            continue;
                        }
                        el.otherChildren.add(el1);
                        continue;
                    }
                    if (el.pathContains(el1)) {
                        this.lf("cycle detected for " + el1, new Object[0]);
                        if (el.otherChildren.contains(el1)) continue;
                        el.otherChildren.add(el1);
                        continue;
                    }
                    if (el.depth + 1 > el1.depth) {
                        if (el1.parent != null) {
                            el1.parent.children.remove(el1);
                            el1.parent.otherChildren.add(el1);
                        }
                        el1.depth = el.depth + 1;
                        el1.parent = el;
                        if (el.otherChildren.contains(el1)) {
                            el.otherChildren.remove(el1);
                        }
                        el.children.add(el1);
                        if (wasinblacknodes) {
                            blackNodes.remove(el1);
                            grayNodes.add(el1);
                        }
                        this.lf("element reinserted: " + el1, new Object[0]);
                        continue;
                    }
                    this.lf("element not reinserted", new Object[0]);
                    if (el.otherChildren.contains(el1)) continue;
                    el.otherChildren.add(el1);
                }
                blackNodes.add(el);
            }
            this.li("build paths done", new Object[0]);
            for (PathElement el : blackNodes) {
                if (!el.children.isEmpty()) continue;
                el.forwardLength = 0;
                PathElement eli = el;
                while (eli.parent != null) {
                    PathElement pathElement = eli.parent;
                    if (pathElement.forwardLength < eli.forwardLength + 1) {
                        pathElement.forwardLength = eli.forwardLength + 1;
                    }
                    eli = pathElement;
                }
            }
        }
        this.li("measure paths done", new Object[0]);
        this.lf("path_element : [children] / [otherchildren]", new Object[0]);
        for (PathElement el : blackNodes) {
            HashSet<PathElement> marked = new HashSet<PathElement>();
            for (PathElement pathElement : el.otherChildren) {
                if (pathElement.pathContains(el) || pathElement.parent == null || el.forwardLength <= pathElement.parent.forwardLength) continue;
                this.lf("switching " + pathElement.toString() + (pathElement.parent != null ? " from " + pathElement.parent.toString() : "") + " to " + el.toString(), new Object[0]);
                if (pathElement.parent != null) {
                    pathElement.parent.children.remove(pathElement);
                    pathElement.parent.otherChildren.add(pathElement);
                }
                pathElement.parent = el;
                pathElement.depth = el.depth + 1;
                marked.add(pathElement);
            }
            for (PathElement pathElement : marked) {
                el.otherChildren.remove(pathElement);
                el.children.add(pathElement);
            }
            Collections.sort(el.children, new PathComparator(this.theGraph));
            Collections.sort(el.otherChildren, new PathComparator(this.theGraph));
            this.lf(String.valueOf(el.toString()) + ": " + el.children.toString() + " / " + el.otherChildren.toString(), new Object[0]);
        }
        this.paths = new LinkedList<PathElement>(blackNodes);
        Collections.sort(this.paths, new PathComparator(this.theGraph));
        this.li("sort paths done", new Object[0]);
        this.li("[node_name ( distance_from_root : parent_or_dash_if_root / number_of_children_or_dot_if_none +number_of_other_children)]/ path_length_from_node)]", new Object[0]);
        this.li(this.paths.toString(), new Object[0]);
    }

    static class NodeInAlphaComparator
    extends NodeAlphaComparator {
        protected Graph theGraph = null;

        public NodeInAlphaComparator(Graph graph) {
            this.theGraph = graph;
        }

        @Override
        public int compare(Node n0, Node n1) {
            if (this.theGraph.contains(n0) && this.theGraph.contains(n1) && this.theGraph.getInEdges(n0).size() != this.theGraph.getInEdges(n1).size()) {
                return (int)Math.signum(this.theGraph.getInEdges(n0).size() - this.theGraph.getInEdges(n1).size());
            }
            return super.compare(n0, n1);
        }
    }

    static class PathComparator
    implements Comparator<PathElement> {
        protected Graph theGraph = null;

        public PathComparator(Graph graph) {
            this.theGraph = graph;
        }

        @Override
        public int compare(PathElement el1, PathElement el2) {
            if (el1.forwardLength != el2.forwardLength) {
                return -(el1.forwardLength - el2.forwardLength);
            }
            return new NodeInAlphaComparator(this.theGraph).compare(el1.node, el2.node);
        }
    }
}

