/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.graphical;

import java.awt.Point;
import java.awt.geom.Point2D;
import net.xqhs.graphical.GConnector;
import net.xqhs.graphical.GContainer;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.representation.graphical.GraphicalGraphRepresentation;
import net.xqhs.graphs.representation.graphical.GraphicalRepresentationElement;

public class RadialGraphRepresentation
extends GraphicalGraphRepresentation {
    public RadialGraphRepresentation(Graph theGraph) {
        super(theGraph);
    }

    @Override
    protected void doLayout() {
        float w = (float)(this.bottomright.getX() - this.topleft.getX());
        float h = (float)(this.bottomright.getY() - this.topleft.getY());
        Point measurement = this.measureLayout((GraphicalRepresentationElement)this.theRepresentation);
        int wc = measurement.x;
        int hc = measurement.y;
        this.lf("measured wc = " + wc + " and hc = " + hc, new Object[0]);
        GraphicalRepresentationElement repr = (GraphicalRepresentationElement)this.theRepresentation;
        ((GContainer)repr.gelement).setSize(w, h).setMoveTo((Point2D)new Point2D.Double(this.topleft.getX() + (double)(w / 2.0f), this.topleft.getY() + (double)(h / 2.0f)));
        this.doLayout((GraphicalRepresentationElement)this.theRepresentation, new Point(-1, 0), new Point2D.Float(h / ((float)hc - 0.5f) / 2.0f, h / 2.0f), wc > 2 ? 1.0f / (float)(wc - 2) : 0.0f, (float)((double)h / ((double)hc - 0.5) / 2.0 * Math.sqrt(2.0)), repr);
    }

    protected void doLayout(GraphicalRepresentationElement repr, Point cPos, Point2D ref, float aFactor, float rFactor, GraphicalRepresentationElement container) {
        repr.gelement.setCanvas(this.canvas);
        if (repr.glabel != null) {
            repr.glabel.setCanvas(this.canvas);
        }
        if (repr.type == GraphicalRepresentationElement.Type.NODE) {
            ((GContainer)container.gelement).addReferencingElement(repr.gelement);
        }
        this.li("layout (r) for: [" + repr.label + "] at [" + cPos + "] having size [" + repr.subSize + "] : " + (repr.edgeType == null ? "-" : repr.edgeType), new Object[0]);
        switch (repr.type) {
            case EDGE: {
                if (repr.edgeType == GraphicalRepresentationElement.EdgeType.CHILDLINK) {
                    this.doLayout(repr.connected.get(1), new Point(cPos), ref, aFactor, rFactor, container);
                }
                ((GConnector)repr.gelement).setFrom(repr.connected.get((int)0).gelement).setTo(repr.connected.get((int)1).gelement);
                break;
            }
            case NODE: {
                repr.positionInRadial(new Point(cPos), ref, aFactor, rFactor);
                cPos.setLocation(cPos.x + 1, cPos.y + 1);
                for (GraphicalRepresentationElement sub : repr.connected) {
                    this.doLayout(sub, new Point(cPos), ref, aFactor, rFactor, container);
                    if (sub.edgeType != GraphicalRepresentationElement.EdgeType.CHILDLINK) continue;
                    cPos.setLocation(cPos.x + sub.subSize.x, cPos.y);
                }
                break;
            }
            case ELEMENT_CONTAINER: {
                cPos.setLocation(cPos.x, cPos.y);
                for (GraphicalRepresentationElement sub : repr.connected) {
                    this.doLayout(sub, new Point(cPos), ref, aFactor, rFactor, container);
                    cPos.setLocation(cPos.x + sub.subSize.x, cPos.y);
                }
                break;
            }
        }
    }
}

