/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.graphical;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import net.xqhs.graphical.GConnector;
import net.xqhs.graphical.GContainer;
import net.xqhs.graphical.GElement;
import net.xqhs.graphical.GLabel;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.RepresentationElement;
import net.xqhs.graphs.representation.VisualizableGraphComponent;

public class GraphicalRepresentationElement
extends RepresentationElement {
    Type type;
    GElement gelement = null;
    GLabel glabel = null;
    Point gridPos = null;
    Point subSize = null;
    String label = "";
    float widthFactor = 1.0f;
    float heightFactor = 1.0f;
    List<GraphicalRepresentationElement> connected = null;
    EdgeType edgeType = null;

    public GraphicalRepresentationElement(GraphRepresentation root, VisualizableGraphComponent component, Type elementType) {
        super(root, component);
        this.type = elementType;
        this.connected = new LinkedList<GraphicalRepresentationElement>();
        switch (elementType) {
            case ELEMENT_CONTAINER: {
                this.gelement = new GContainer().setReferenceType(GElement.ReferenceType.TOPLEFT);
                break;
            }
            case EDGE: {
                this.gelement = new GConnector();
                this.glabel = new GLabel().setText(((Edge)((Object)this.getRepresentedComponent())).getLabel()).setParent(this.gelement);
                this.label = ((Edge)((Object)this.getRepresentedComponent())).getLabel();
                break;
            }
            case NODE: {
                this.gelement = new GElement();
                this.glabel = new GLabel().setText(((Node)((Object)this.getRepresentedComponent())).getLabel()).setParent(this.gelement);
                this.label = ((Node)((Object)this.getRepresentedComponent())).getLabel();
                break;
            }
            default: {
                this.gelement = new GElement();
            }
        }
        this.gelement.setRepresented((Object)this.getRepresentedComponent());
        if (this.getRepresentedComponent() != null) {
            this.getRepresentedComponent().addRepresentation(this);
        }
    }

    public GraphicalRepresentationElement setEdge(EdgeType type, GraphicalRepresentationElement from, GraphicalRepresentationElement to) {
        if (this.type != Type.EDGE) {
            throw new IllegalArgumentException("function is only available for edges");
        }
        this.connected.add(from);
        this.connected.add(to);
        this.edgeType = type;
        return this;
    }

    public GraphicalRepresentationElement setSize(Point size) {
        this.subSize = size;
        return this;
    }

    public GraphicalRepresentationElement setHighlighted(boolean doHighlight) {
        if (this.gelement != null) {
            if (doHighlight) {
                this.gelement.setColor(Color.RED);
            } else {
                this.gelement.setColor(null);
            }
        }
        return this;
    }

    public GElement getGElement() {
        return this.gelement;
    }

    public GraphicalRepresentationElement positionInGrid(Point position, float widthFactor, float heightFactor) {
        this.gridPos = new Point(position);
        this.widthFactor = widthFactor;
        this.heightFactor = heightFactor;
        this.gelement.setMoveTo((Point2D)new Point2D.Float((float)this.gridPos.x * widthFactor, (float)this.gridPos.y * heightFactor));
        return this;
    }

    public GraphicalRepresentationElement positionInRadial(Point position, Point2D center, float angleFactor, float rangeFactor) {
        this.gridPos = new Point(position);
        this.widthFactor = angleFactor;
        this.heightFactor = rangeFactor;
        double init = 0.5235987755982988;
        double interval = 2.0943951023931953;
        this.gelement.setMoveTo((Point2D)new Point2D.Double(center.getX() + (double)((float)this.gridPos.y * rangeFactor) * Math.sin((double)((float)this.gridPos.x * angleFactor) * interval + init), center.getY() + (double)((float)this.gridPos.y * rangeFactor) * Math.cos((double)((float)this.gridPos.x * angleFactor) * interval + init)));
        return this;
    }

    static enum EdgeType {
        CHILDLINK,
        SIDELINK,
        EXTLINK,
        FORELINK,
        BACKLINK;

    }

    static enum Type {
        NODE,
        EDGE,
        ELEMENT_CONTAINER;

    }
}

