/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation.graphical;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.xqhs.graphical.GCanvas;
import net.xqhs.graphical.GConnector;
import net.xqhs.graphical.GContainer;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.graphical.GraphicalRepresentationElement;
import net.xqhs.graphs.representation.linear.LinearGraphRepresentation;
import net.xqhs.graphs.representation.linear.PathElement;

public class GraphicalGraphRepresentation
extends LinearGraphRepresentation {
    GCanvas canvas;
    Point2D topleft;
    Point2D bottomright;

    public GraphicalGraphRepresentation(Graph theGraph) {
        super(theGraph);
    }

    public GraphicalGraphRepresentation makeDefaults() {
        super.makeDefaults();
        this.setCanvas(new GCanvas());
        this.topleft = new Point2D.Float(-100.0f, -100.0f);
        this.bottomright = new Point2D.Float(100.0f, 100.0f);
        return this;
    }

    public GraphicalGraphRepresentation setCanvas(GCanvas representationCanvas) {
        if (representationCanvas != null) {
            this.canvas = representationCanvas;
        }
        return this;
    }

    public GraphicalGraphRepresentation setOrigin(Point2D origin) {
        this.topleft = origin;
        return this;
    }

    public GraphicalGraphRepresentation setBottomRight(Point2D bottomRight) {
        this.bottomright = bottomRight;
        return this;
    }

    @Override
    protected String setDefaultName(String name) {
        return String.valueOf(super.setDefaultName(name)) + "X";
    }

    @Override
    protected void processGraph() {
        super.processGraph();
        HashSet<PathElement> blackNodes = new HashSet<PathElement>();
        GraphicalRepresentationElement representation = new GraphicalRepresentationElement(this, null, GraphicalRepresentationElement.Type.ELEMENT_CONTAINER);
        for (PathElement el : this.paths) {
            if (blackNodes.contains(el)) continue;
            representation.connected.add(this.representChildren(el, blackNodes));
        }
        this.theRepresentation = representation;
        this.doLayout();
        this.lf("get ready for magnetics", new Object[0]);
        this.canvas.startMagnetics();
    }

    protected GraphicalRepresentationElement representChildren(PathElement el, Set<PathElement> blackNodes) {
        GraphicalRepresentationElement repr = new GraphicalRepresentationElement(this, (VisualizableGraphComponent)((Object)el.getNode()), GraphicalRepresentationElement.Type.NODE);
        blackNodes.add(el);
        LinkedList<PathElement> others = new LinkedList<PathElement>(el.getOtherChildren());
        this.representOthers(others, blackNodes, GraphicalRepresentationElement.EdgeType.BACKLINK, el, repr);
        boolean first = true;
        for (PathElement child : el.getChildren()) {
            for (Edge edge : this.isBackwards ? this.theGraph.getInEdges(el.getNode()) : this.theGraph.getOutEdges(el.getNode())) {
                if ((!this.isBackwards || edge.getFrom() != child.getNode()) && (this.isBackwards || edge.getTo() != child.getNode())) continue;
                GraphicalRepresentationElement childRepr = this.representChildren(child, blackNodes);
                GraphicalRepresentationElement edgeRepr = new GraphicalRepresentationElement(this, (VisualizableGraphComponent)((Object)edge), GraphicalRepresentationElement.Type.EDGE);
                edgeRepr.setEdge(GraphicalRepresentationElement.EdgeType.CHILDLINK, repr, childRepr);
                repr.connected.add(edgeRepr);
                ((VisualizableGraphComponent)((Object)child.getNode())).addRepresentation(childRepr);
                ((VisualizableGraphComponent)((Object)edge)).addRepresentation(edgeRepr);
                first = false;
            }
            this.representOthers(others, blackNodes, first ? GraphicalRepresentationElement.EdgeType.FORELINK : GraphicalRepresentationElement.EdgeType.SIDELINK, el, repr);
        }
        this.representOthers(others, blackNodes, GraphicalRepresentationElement.EdgeType.EXTLINK, el, repr);
        return repr;
    }

    protected void representOthers(List<PathElement> others, Set<PathElement> blackNodes, GraphicalRepresentationElement.EdgeType edgeType, PathElement parent, GraphicalRepresentationElement parentRepr) {
        while (!others.isEmpty() && (edgeType == GraphicalRepresentationElement.EdgeType.EXTLINK || blackNodes.contains(others.get(0)))) {
            PathElement other = others.get(0);
            GraphicalRepresentationElement.EdgeType actualEdgeType = edgeType;
            GraphicalRepresentationElement otherRepr = (GraphicalRepresentationElement)((VisualizableGraphComponent)((Object)other.getNode())).getFirstRepresentationForRoot(parentRepr.getParentRepresentation());
            if (otherRepr == null) {
                others.remove(other);
                continue;
            }
            if (actualEdgeType == GraphicalRepresentationElement.EdgeType.BACKLINK && !parent.pathContains(other)) {
                actualEdgeType = GraphicalRepresentationElement.EdgeType.SIDELINK;
            }
            for (Edge edge : this.isBackwards ? this.theGraph.getInEdges(parent.getNode()) : this.theGraph.getOutEdges(parent.getNode())) {
                if ((!this.isBackwards || edge.getFrom() != other.getNode()) && (this.isBackwards || edge.getTo() != other.getNode())) continue;
                GraphicalRepresentationElement edgeRepr = new GraphicalRepresentationElement(this, (VisualizableGraphComponent)((Object)edge), GraphicalRepresentationElement.Type.EDGE);
                edgeRepr.setEdge(actualEdgeType, parentRepr, otherRepr);
                parentRepr.connected.add(edgeRepr);
                ((VisualizableGraphComponent)((Object)edge)).addRepresentation(edgeRepr);
            }
            others.remove(other);
        }
    }

    protected void doLayout() {
        float w = (float)(this.bottomright.getX() - this.topleft.getX());
        float h = (float)(this.bottomright.getY() - this.topleft.getY());
        Point measurement = this.measureLayout((GraphicalRepresentationElement)this.theRepresentation);
        int wc = measurement.x;
        int hc = measurement.y;
        GraphicalRepresentationElement repr = (GraphicalRepresentationElement)this.theRepresentation;
        ((GContainer)repr.gelement).setSize(w, h).setMoveTo((Point2D)new Point2D.Double(this.topleft.getX() + (double)(w / 2.0f), this.topleft.getY() + (double)(h / 2.0f)));
        this.doLayout((GraphicalRepresentationElement)this.theRepresentation, new Point(1, 0), w / (float)(wc + 2), h / (float)(hc + 1), repr);
    }

    protected void doLayout(GraphicalRepresentationElement repr, Point cPos, float wFactor, float hFactor, GraphicalRepresentationElement container) {
        repr.gelement.setCanvas(this.canvas);
        if (repr.glabel != null) {
            repr.glabel.setCanvas(this.canvas);
        }
        if (repr.type == GraphicalRepresentationElement.Type.NODE) {
            ((GContainer)container.gelement).addReferencingElement(repr.gelement);
        }
        this.li("layout for: [" + repr.label + "] at [" + cPos + "] having size [" + repr.subSize + "] : " + (repr.edgeType == null ? "-" : repr.edgeType), new Object[0]);
        switch (repr.type) {
            case EDGE: {
                if (repr.edgeType == GraphicalRepresentationElement.EdgeType.CHILDLINK) {
                    this.doLayout(repr.connected.get(1), new Point(cPos), wFactor, hFactor, container);
                }
                ((GConnector)repr.gelement).setFrom(repr.connected.get((int)0).gelement).setTo(repr.connected.get((int)1).gelement);
                break;
            }
            case NODE: {
                repr.positionInGrid(new Point(cPos), wFactor, hFactor);
                cPos.setLocation(cPos.x, cPos.y + 1);
                for (GraphicalRepresentationElement sub : repr.connected) {
                    this.doLayout(sub, new Point(cPos), wFactor, hFactor, container);
                    if (sub.edgeType != GraphicalRepresentationElement.EdgeType.CHILDLINK) continue;
                    cPos.setLocation(cPos.x + sub.subSize.x, cPos.y);
                }
                break;
            }
            case ELEMENT_CONTAINER: {
                cPos.setLocation(cPos.x, cPos.y + 1);
                for (GraphicalRepresentationElement sub : repr.connected) {
                    this.doLayout(sub, new Point(cPos), wFactor, hFactor, container);
                    cPos.setLocation(cPos.x + sub.subSize.x, cPos.y);
                }
                break;
            }
        }
    }

    protected Point measureLayout(GraphicalRepresentationElement repr) {
        int height = 0;
        int width = 0;
        switch (repr.type) {
            case ELEMENT_CONTAINER: {
                for (GraphicalRepresentationElement sub : repr.connected) {
                    Point result = this.measureLayout(sub);
                    if (result.y > height) {
                        height = result.y;
                    }
                    width += result.x;
                }
                return repr.setSize((Point)new Point((int)width, (int)height)).subSize;
            }
            case EDGE: {
                return repr.setSize((Point)this.measureLayout((GraphicalRepresentationElement)repr.connected.get((int)1))).subSize;
            }
            case NODE: {
                for (GraphicalRepresentationElement sub : repr.connected) {
                    if (sub.edgeType != GraphicalRepresentationElement.EdgeType.CHILDLINK) continue;
                    Point result = this.measureLayout(sub);
                    if (result.y > height) {
                        height = result.y;
                    }
                    width += result.x;
                }
                return repr.setSize((Point)new Point((int)(width == 0 ? 1 : width + 1), (int)(height + 1))).subSize;
            }
        }
        return new Point(width, height);
    }

    @Override
    public GraphicalRepresentationElement getRepresentation() {
        return (GraphicalRepresentationElement)this.theRepresentation;
    }

    public GCanvas displayRepresentation() {
        return this.canvas;
    }
}

