/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation;

import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.SimpleGraph;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.RepresentationElement;
import net.xqhs.util.logging.Unit;

public abstract class GraphRepresentationImplementation
extends Unit
implements GraphRepresentation {
    protected Graph theGraph = null;
    protected GraphRepresentation parentRepresentation = null;
    protected RepresentationElement theRepresentation = null;

    protected String setDefaultName(String name) {
        return String.valueOf(name) + "-R";
    }

    public GraphRepresentationImplementation(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("the graph cannot be null");
        }
        this.theGraph = graph;
    }

    public GraphRepresentationImplementation setUnitName(String unitName) {
        if ("theDefaulUnitName".equals(unitName) && this.theGraph instanceof SimpleGraph) {
            String graphName = ((SimpleGraph)this.theGraph).getUnitName();
            if (graphName == null) {
                return (GraphRepresentationImplementation)super.setUnitName(this.setDefaultName("Graph" + new Integer(this.theGraph.hashCode()).toString().substring(0, 5)));
            }
            return (GraphRepresentationImplementation)super.setUnitName(this.setDefaultName(graphName));
        }
        return (GraphRepresentationImplementation)super.setUnitName(unitName);
    }

    @Override
    public GraphRepresentationImplementation setParentRepresentation(GraphRepresentation parent) {
        if (this.lockedR()) {
            return null;
        }
        if (parent != null) {
            this.parentRepresentation = parent;
        }
        return this;
    }

    @Override
    public GraphRepresentation getRootRepresentation() {
        GraphRepresentationImplementation root = this;
        while (root.parentRepresentation != null) {
            root = (GraphRepresentationImplementation)root.parentRepresentation;
        }
        return root;
    }

    @Override
    public GraphRepresentation update() {
        this.processGraph();
        return this;
    }

    protected void processGraph() {
        this.ensureLocked();
    }

    @Override
    public abstract RepresentationElement getRepresentation();

    @Override
    public abstract Object displayRepresentation();
}

