/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.representation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.RepresentationElement;
import net.xqhs.graphs.representation.VisualizableGraphComponent;

public abstract class AbstractVisualizableGraphComponent
implements VisualizableGraphComponent {
    protected Set<RepresentationElement> representations = new HashSet<RepresentationElement>();

    @Override
    public void addRepresentation(RepresentationElement repr) {
        this.representations.add(repr);
    }

    @Override
    public Collection<RepresentationElement> getRepresentations() {
        return this.representations;
    }

    @Override
    public RepresentationElement getFirstRepresentationForRoot(GraphRepresentation root) {
        Collection<RepresentationElement> filtered = this.getRepresentationsForRoot(root);
        if (filtered.isEmpty()) {
            return null;
        }
        return filtered.iterator().next();
    }

    @Override
    public Collection<RepresentationElement> getRepresentationsForRoot(GraphRepresentation root) {
        HashSet<RepresentationElement> ret = new HashSet<RepresentationElement>();
        for (RepresentationElement repr : this.representations) {
            if (repr.getParentRepresentation() != root) continue;
            ret.add(repr);
        }
        return ret;
    }
}

