/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.pattern;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.GraphComponent;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.SimpleEdge;
import net.xqhs.graphs.graph.SimpleGraph;
import net.xqhs.graphs.pattern.NodeP;
import net.xqhs.graphs.representation.AbstractVisualizableGraphComponent;

public class GraphPattern
extends SimpleGraph {
    public int maxK() {
        return this.m();
    }

    @Override
    public GraphPattern addNode(Node node) {
        return this.addNode(node, true);
    }

    public GraphPattern addNode(Node node, boolean doindex) {
        if (doindex && node instanceof NodeP && ((NodeP)node).isGeneric()) {
            int maxIdx = 0;
            for (Node n : this.nodes.keySet()) {
                if (!(n instanceof NodeP) || !((NodeP)n).isGeneric() || maxIdx > ((NodeP)n).genericIndex()) continue;
                maxIdx = ((NodeP)n).genericIndex();
            }
            if (maxIdx >= 0) {
                ((NodeP)node).labelIndex = maxIdx + 1;
            }
        }
        super.addNode(node);
        return this;
    }

    @Override
    public GraphPattern readFrom(InputStream input) {
        super.readFrom(input);
        HashSet<AbstractVisualizableGraphComponent> additions = new HashSet<AbstractVisualizableGraphComponent>();
        HashSet<GraphComponent> removals = new HashSet<GraphComponent>();
        HashMap<Node, NodeP> replacements = new HashMap<Node, NodeP>();
        for (Node node : this.nodes.keySet()) {
            if (!node.getLabel().startsWith("?#")) continue;
            NodeP newNode = new NodeP();
            removals.add(node);
            additions.add(newNode);
            replacements.put(node, newNode);
        }
        for (Edge edge : this.edges) {
            Node from = (Node)replacements.get(edge.getFrom());
            Node to = (Node)replacements.get(edge.getTo());
            if (from == null && to == null) continue;
            removals.add(edge);
            additions.add(new SimpleEdge(from != null ? from : edge.getFrom(), to != null ? to : edge.getTo(), edge.getLabel()));
        }
        for (GraphComponent graphComponent : removals) {
            this.remove(graphComponent);
        }
        for (GraphComponent graphComponent : additions) {
            this.add(graphComponent);
        }
        return this;
    }
}

