/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matchingPlatform;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.GraphComponent;
import net.xqhs.graphs.graph.SimpleGraph;
import net.xqhs.graphs.representation.text.TextGraphRepresentation;

public class TrackingGraph
extends SimpleGraph {
    protected AtomicInteger sequence = new AtomicInteger(0);
    protected boolean isShadow;
    protected Queue<Transaction> transactionQueue;
    protected List<Queue<Transaction>> shadowQueues = null;
    protected boolean keepHistory = false;
    protected List<Transaction> history = null;

    public TrackingGraph() {
        this.isShadow = false;
    }

    public TrackingGraph(Queue<Transaction> transactionsLink, int initialSequence, Graph initialGraph) {
        if (transactionsLink == null) {
            throw new IllegalArgumentException("A shadow graph must be linked to an existing transaction queue");
        }
        this.addAll(initialGraph.getComponents());
        this.sequence = new AtomicInteger(initialSequence);
        this.transactionQueue = transactionsLink;
        this.isShadow = true;
    }

    public boolean isShadow() {
        return this.isShadow;
    }

    public TrackingGraph createShadow() {
        return new TrackingGraph(this.createShadowQueue(), this.sequence.get(), this);
    }

    protected Queue<Transaction> createShadowQueue() {
        if (this.shadowQueues == null) {
            this.shadowQueues = new ArrayList<Queue<Transaction>>();
        }
        LinkedList<Transaction> newQueue = new LinkedList<Transaction>();
        this.shadowQueues.add(newQueue);
        return newQueue;
    }

    public TrackingGraph keepHistory(boolean keep, boolean clearHistory) {
        if (clearHistory) {
            this.history.clear();
        }
        if (keep && this.history == null) {
            this.history = new ArrayList<Transaction>();
        }
        this.keepHistory = keep;
        return this;
    }

    protected TrackingGraph performOperation(GraphComponent component, Operation operation, boolean externalCall) {
        if (this.isShadow && externalCall) {
            throw new UnsupportedOperationException("A shadow graph only takes modifications from its transaction queue.");
        }
        if (externalCall && (operation == Operation.ADD && !this.contains(component) || operation == Operation.REMOVE && this.contains(component))) {
            this.addTransaction(new Transaction(component, operation));
        }
        switch (operation) {
            case ADD: {
                super.add(component);
                break;
            }
            case REMOVE: {
                super.remove(component);
            }
        }
        return this;
    }

    protected void addTransaction(Transaction t) {
        this.sequence.incrementAndGet();
        if (this.shadowQueues != null) {
            for (Queue<Transaction> queue : this.shadowQueues) {
                queue.add(t);
            }
        }
        if (this.keepHistory) {
            this.history.add(t);
        }
    }

    public TrackingGraph applyTransaction(Transaction t) {
        if (this.isShadow) {
            throw new UnsupportedOperationException("A shadow graph only takes modifications from its transaction queue.");
        }
        this.applyTransactionInternal(t);
        return this;
    }

    protected void applyTransactionInternal(Transaction t) {
        if (t.isEmpty()) {
            this.lw("Transaction is void.", new Object[0]);
        } else if (t.isSingleOperation()) {
            this.performOperation(t.getComponent(), t.getOperation(), false);
        } else {
            for (Map.Entry<GraphComponent, Operation> e : t.entrySet()) {
                this.performOperation(e.getKey(), e.getValue(), false);
            }
        }
        this.addTransaction(t);
    }

    @Override
    public TrackingGraph add(GraphComponent component) {
        if (!this.contains(component)) {
            return this.performOperation(component, Operation.ADD, true);
        }
        this.lw("component [] already present. Not re-added.", new Object[]{component});
        return this;
    }

    @Override
    public TrackingGraph addAll(Collection<? extends GraphComponent> components) {
        if (this.isShadow) {
            throw new UnsupportedOperationException("A shadow graph only takes modifications from its transaction queue.");
        }
        Transaction t = new Transaction();
        for (GraphComponent graphComponent : components) {
            if (!this.contains(graphComponent)) {
                t.put(graphComponent, Operation.ADD);
                continue;
            }
            this.lw("node [" + graphComponent.toString() + "] already present. Not re-added.", new Object[0]);
        }
        if (!t.isEmpty()) {
            this.applyTransactionInternal(t);
        }
        return this;
    }

    @Override
    public TrackingGraph remove(GraphComponent component) {
        if (this.contains(component)) {
            return this.performOperation(component, Operation.REMOVE, true);
        }
        this.lw("component [] not contained", new Object[]{component});
        return this;
    }

    @Override
    public TrackingGraph removeAll(Collection<? extends GraphComponent> components) {
        if (this.isShadow) {
            throw new UnsupportedOperationException("A shadow graph only takes modifications from its transaction queue.");
        }
        Transaction t = new Transaction();
        for (GraphComponent graphComponent : components) {
            if (this.contains(graphComponent)) {
                t.put(graphComponent, Operation.REMOVE);
                continue;
            }
            this.lw("node [" + graphComponent.toString() + "] not present.", new Object[0]);
        }
        if (!t.isEmpty()) {
            this.applyTransactionInternal(t);
        }
        return this;
    }

    public int getSequence() {
        return this.sequence.get();
    }

    public boolean canIncrement() {
        if (!this.isShadow) {
            throw new IllegalStateException("Non-shadow graphs do not support this operation");
        }
        return !this.transactionQueue.isEmpty();
    }

    public Map<GraphComponent, Operation> getNextSequenceOperations() {
        if (!this.isShadow) {
            throw new IllegalStateException("Non-shadow graphs do not support this operation");
        }
        if (this.transactionQueue.isEmpty()) {
            return null;
        }
        return this.transactionQueue.peek().toOperationMap();
    }

    protected void incrementSequenceInternal() {
        if (!this.isShadow || this.transactionQueue.isEmpty()) {
            throw new IllegalStateException("Illegal state reached.");
        }
        this.applyTransactionInternal(this.transactionQueue.poll());
    }

    public int incrementSequence() {
        if (!this.isShadow) {
            throw new IllegalStateException("Non-shadow graphs do not support this operation");
        }
        if (this.transactionQueue.isEmpty()) {
            return -1;
        }
        this.incrementSequenceInternal();
        return this.sequence.get();
    }

    /*
     * Unable to fully structure code
     */
    public int incrementSequence(int targetSequence) {
        if (this.isShadow) ** GOTO lbl4
        throw new IllegalStateException("Non-shadow graphs do not support this operation");
lbl-1000:
        // 1 sources

        {
            this.incrementSequenceInternal();
lbl4:
            // 2 sources

            ** while (!this.transactionQueue.isEmpty() && this.sequence.get() < targetSequence)
        }
lbl5:
        // 1 sources

        if (this.sequence.get() < targetSequence) {
            this.lw("Target sequence not reached.", new Object[0]);
        }
        return this.sequence.get();
    }

    /*
     * Unable to fully structure code
     */
    public int incrementSequenceFastForward() {
        if (this.isShadow) ** GOTO lbl4
        throw new IllegalStateException("Non-shadow graphs do not support this operation");
lbl-1000:
        // 1 sources

        {
            this.incrementSequenceInternal();
lbl4:
            // 2 sources

            ** while (!this.transactionQueue.isEmpty())
        }
lbl5:
        // 1 sources

        return this.sequence.get();
    }

    @Override
    public SimpleGraph readFrom(InputStream input) {
        throw new UnsupportedOperationException("Reading graphs is not supported. Use method addGraph(Graph).");
    }

    @Override
    public String toString() {
        return this.toString("", "", -1);
    }

    public String toString(String branchSeparator, String separatorIncrement, int limit) {
        String detail = "[" + this.sequence + "|";
        boolean first = true;
        if (this.shadowQueues != null) {
            for (Queue<Transaction> q : this.shadowQueues) {
                detail = String.valueOf(detail) + (first ? "" : "/") + q.size();
                first = false;
            }
        } else {
            detail = String.valueOf(detail) + "-";
        }
        detail = String.valueOf(detail) + "]";
        return String.valueOf(detail) + new TextGraphRepresentation(this).setLayout(branchSeparator, separatorIncrement, limit).update().toString();
    }

    public String toStringBasic() {
        return super.toString();
    }

    public static enum Operation {
        ADD,
        REMOVE;

    }

    public static class Transaction
    implements Map<GraphComponent, Operation> {
        boolean singleOperation = false;
        boolean empty = true;
        GraphComponent singleOperationComponent = null;
        Operation singleOperationOperation = null;
        Map<GraphComponent, Operation> multipleOperations = null;

        public Transaction(GraphComponent component, Operation operation) {
            this.empty = false;
            this.singleOperation = true;
            this.singleOperationComponent = component;
            this.singleOperationOperation = operation;
        }

        public Transaction() {
        }

        public GraphComponent getComponent() {
            if (!this.singleOperation) {
                throw new UnsupportedOperationException("Transaction contains multiple operations");
            }
            return this.singleOperationComponent;
        }

        public Operation getOperation() {
            if (!this.singleOperation) {
                throw new UnsupportedOperationException("Transaction contains multiple operations");
            }
            return this.singleOperationOperation;
        }

        public boolean isSingleOperation() {
            return this.singleOperation;
        }

        protected void compact() {
            if (this.empty || this.singleOperation || this.multipleOperations == null) {
                throw new IllegalStateException("Should not have called compact in this state");
            }
            this.empty = this.multipleOperations.isEmpty();
            boolean bl = this.singleOperation = this.multipleOperations.size() == 1;
            if (this.empty) {
                this.multipleOperations = null;
            }
            if (this.singleOperation) {
                Map.Entry<GraphComponent, Operation> e = this.multipleOperations.entrySet().iterator().next();
                this.singleOperationComponent = e.getKey();
                this.singleOperationOperation = e.getValue();
                this.multipleOperations = null;
            }
        }

        protected void toMultipleOperations() {
            if (!this.singleOperation && !this.empty) {
                return;
            }
            this.empty = false;
            this.multipleOperations = new HashMap<GraphComponent, Operation>();
            if (this.singleOperation) {
                this.multipleOperations.put(this.singleOperationComponent, this.singleOperationOperation);
            }
            this.singleOperation = false;
            this.singleOperationComponent = null;
            this.singleOperationOperation = null;
        }

        @Override
        public Operation put(GraphComponent component, Operation operation) {
            if (this.empty) {
                this.empty = false;
                this.singleOperation = true;
                this.singleOperationComponent = component;
                this.singleOperationOperation = operation;
                return this.singleOperationOperation;
            }
            if (this.singleOperation) {
                if (component == this.singleOperationComponent) {
                    Operation ret = this.singleOperationOperation;
                    this.singleOperationOperation = operation;
                    return ret;
                }
                this.toMultipleOperations();
            }
            return this.multipleOperations.put(component, operation);
        }

        public Transaction putR(GraphComponent component, Operation operation) {
            this.put(component, operation);
            return this;
        }

        @Override
        public void putAll(Map<? extends GraphComponent, ? extends Operation> operations) {
            this.toMultipleOperations();
            this.multipleOperations.putAll(operations);
            this.compact();
        }

        @Override
        public Operation get(Object component) {
            if (this.empty) {
                return null;
            }
            if (this.singleOperation) {
                if (component == this.singleOperationComponent) {
                    return this.singleOperationOperation;
                }
                return null;
            }
            return this.multipleOperations.get(component);
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.empty) {
                return false;
            }
            return this.singleOperation ? this.singleOperationComponent == key : this.multipleOperations.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Operation is unsupported");
        }

        @Override
        public Collection<Operation> values() {
            throw new UnsupportedOperationException("Operation is unsupported");
        }

        @Override
        public void clear() {
            this.empty = true;
            this.singleOperation = false;
            this.singleOperationComponent = null;
            this.singleOperationOperation = null;
            this.multipleOperations.clear();
            this.multipleOperations = null;
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }

        @Override
        public int size() {
            return this.empty ? 0 : (this.singleOperation ? 1 : this.multipleOperations.size());
        }

        @Override
        public Set<Map.Entry<GraphComponent, Operation>> entrySet() {
            if (this.empty || this.singleOperation) {
                throw new UnsupportedOperationException("Cannot iterate over empty or single-operation transactions.");
            }
            return this.multipleOperations.entrySet();
        }

        @Override
        public Set<GraphComponent> keySet() {
            if (this.empty || this.singleOperation) {
                throw new UnsupportedOperationException("Cannot iterate over empty or single-operation transactions.");
            }
            return this.multipleOperations.keySet();
        }

        @Override
        public Operation remove(Object component) {
            if (this.empty) {
                return null;
            }
            if (this.singleOperation) {
                if (component == this.singleOperationComponent) {
                    Operation ret = this.singleOperationOperation;
                    this.singleOperationComponent = null;
                    this.singleOperationOperation = null;
                    this.empty = true;
                    this.singleOperation = false;
                    return ret;
                }
                return null;
            }
            Operation ret = this.multipleOperations.remove(component);
            this.compact();
            return ret;
        }

        public String toString() {
            if (this.empty) {
                return "[-]";
            }
            if (this.singleOperation) {
                return this.singleOperationComponent + ": " + this.singleOperationOperation.toString();
            }
            return this.multipleOperations.toString();
        }

        public Map<GraphComponent, Operation> toOperationMap() {
            this.toMultipleOperations();
            HashMap<GraphComponent, Operation> ret = new HashMap<GraphComponent, Operation>(this.multipleOperations);
            this.compact();
            return ret;
        }
    }
}

