/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matchingPlatform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.matcher.GraphMatcherQuick;
import net.xqhs.graphs.matcher.Match;
import net.xqhs.graphs.matcher.MonitorPack;
import net.xqhs.graphs.pattern.EdgeP;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.graphs.util.Debug;

public class GraphMatcherPersistent
extends GraphMatcherQuick {
    protected SortedSet<Match> sortedMatches;
    protected Map<Edge, Set<Match>> eMatchIndex = null;
    protected Map<Edge, Set<Match>> ePMatchIndex = null;

    protected GraphMatcherPersistent(Graph graph, GraphPattern pattern) {
        super(graph, pattern);
    }

    @Override
    public GraphMatcherPersistent initializeMatching() {
        this.sortedMatches = new TreeSet<Match>(new Match.MatchComparator(this.monitor));
        this.eMatchIndex = new HashMap<Edge, Set<Match>>();
        this.ePMatchIndex = new HashMap<Edge, Set<Match>>();
        super.initializeMatching();
        return this;
    }

    @Override
    public GraphMatcherPersistent clearData() {
        super.clearData();
        this.sortedMatches.clear();
        this.eMatchIndex.clear();
        this.ePMatchIndex.clear();
        return this;
    }

    public GraphMatcherPersistent completeMatches() {
        this.getAllMatches(0);
        return this;
    }

    public GraphMatcherPersistent addMatches(Edge e) {
        if (this.matchQueue == null || this.allMatches == null) {
            this.initializeMatching();
        }
        TreeSet<Edge> sortedEdges = new TreeSet<Edge>(new GraphMatcherQuick.EdgeComparator(this.monitor));
        sortedEdges.addAll(this.pattern.getEdges());
        int edgeId = 0;
        int matchId = 0;
        for (Edge eP : sortedEdges) {
            if (eP instanceof EdgeP && ((EdgeP)eP).isGeneric()) continue;
            this.monitor.lf("edge [] has id []", eP, new Integer(edgeId));
            this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, "trying edges: [] : []", eP, e);
            if (!this.isMatch(eP, e)) continue;
            Match m = this.addInitialMatch(e, eP, String.valueOf(edgeId) + ":" + matchId);
            this.monitor.incrementMatchCount();
            this.monitor.lf("new single match: []", m.toString());
            ++matchId;
        }
        return this;
    }

    public GraphMatcherPersistent removeMatches(Edge edge) {
        if (this.matchQueue == null || this.allMatches == null) {
            return this;
        }
        if (!this.eMatchIndex.containsKey(edge)) {
            return this;
        }
        Set<Match> toRemove = this.eMatchIndex.get(edge);
        this.eMatchIndex.remove(edge);
        for (Match m : toRemove) {
            this.invalidateMatch(m);
        }
        toRemove.clear();
        return this;
    }

    @Override
    protected Match addInitialMatch(Edge e, Edge eP, String matchID) {
        Match m = new Match(this.graph, this.pattern, e, eP, matchID);
        HashSet<Edge> neighborEdgePs = new HashSet<Edge>();
        neighborEdgePs.addAll(this.pattern.getInEdges(eP.getFrom()));
        neighborEdgePs.addAll(this.pattern.getOutEdges(eP.getFrom()));
        neighborEdgePs.addAll(this.pattern.getInEdges(eP.getTo()));
        neighborEdgePs.addAll(this.pattern.getOutEdges(eP.getTo()));
        HashSet<Match> nMatches = new HashSet<Match>();
        for (Edge neP : neighborEdgePs) {
            if (!this.ePMatchIndex.containsKey(neP)) continue;
            Iterator<Match> it = this.ePMatchIndex.get(neP).iterator();
            while (it.hasNext()) {
                Match mc = it.next();
                if (mc.isValid()) {
                    nMatches.add(mc);
                    continue;
                }
                it.remove();
            }
        }
        for (Match mi : nMatches) {
            m.considerCandidate(mi, this.eMatchIndex, this.ePMatchIndex, this.monitor);
        }
        if (!this.eMatchIndex.containsKey(e)) {
            this.eMatchIndex.put(e, new HashSet());
        }
        this.eMatchIndex.get(e).add(m);
        if (!this.ePMatchIndex.containsKey(eP)) {
            this.ePMatchIndex.put(eP, new HashSet());
        }
        this.ePMatchIndex.get(eP).add(m);
        this.matchQueue.add(m);
        this.allMatches.add(m);
        return m;
    }

    @Override
    protected Match addMergeMatch(Match m1, Match m2) {
        Match newM = m1.merge(m2, this.eMatchIndex, this.ePMatchIndex, this.monitor);
        this.matchQueue.add(newM);
        this.allMatches.add(newM);
        return newM;
    }

    public static GraphMatcherPersistent getMatcher(Graph graph, GraphPattern pattern, MonitorPack monitoring) {
        if (monitoring == null) {
            throw new IllegalArgumentException();
        }
        if (monitoring.getVisual() != null) {
            monitoring.getVisual().feedLine(graph, null, "the graph");
            monitoring.getVisual().feedLine(pattern, null, "the pattern");
        }
        return (GraphMatcherPersistent)new GraphMatcherPersistent(graph, pattern).setMonitor(monitoring);
    }

    protected int getMemory() {
        int ret = this.allMatches != null ? this.allMatches.size() : 0;
        return ret;
    }

    public static /* bridge */ /* synthetic */ GraphMatcherQuick getMatcher(Graph graph, GraphPattern graphPattern, MonitorPack monitorPack) {
        return GraphMatcherPersistent.getMatcher(graph, graphPattern, monitorPack);
    }
}

