/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matchingPlatform;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.GraphComponent;
import net.xqhs.graphs.matcher.GraphMatchingProcess;
import net.xqhs.graphs.matcher.Match;
import net.xqhs.graphs.matcher.MonitorPack;
import net.xqhs.graphs.matchingPlatform.GraphMatcherPersistent;
import net.xqhs.graphs.matchingPlatform.GraphMatchingPlatform;
import net.xqhs.graphs.matchingPlatform.TrackingGraph;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.util.logging.Unit;

public class GMPImplementation
extends Unit
implements GraphMatchingPlatform {
    MonitorPack monitor = new MonitorPack();
    GraphMatchingPlatform.PlatformPrincipalGraph principalGraph = null;
    Map<GraphPattern, GraphMatcherPersistent> patterns = null;
    GraphMatchingPlatform.PlatformShadowGraph matchingGraph = null;

    public GMPImplementation setMonitor(MonitorPack monitorLink) {
        this.monitor = this.monitor == null ? new MonitorPack() : monitorLink;
        return this;
    }

    @Override
    public GMPImplementation setPrincipalGraph(GraphMatchingPlatform.PlatformPrincipalGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Principal graph cannot be null");
        }
        this.principalGraph = graph;
        this.matchingGraph = null;
        if (this.patterns != null && !this.patterns.isEmpty()) {
            HashSet<GraphPattern> newP = new HashSet<GraphPattern>(this.patterns.keySet());
            this.patterns.clear();
            for (GraphPattern pattern : newP) {
                this.addPattern(pattern);
            }
        }
        return this;
    }

    @Override
    public GraphMatchingPlatform.PlatformPrincipalGraph getPrincipalGraph() {
        return this.principalGraph;
    }

    @Override
    public GMPImplementation addPattern(GraphPattern pattern) {
        if (this.patterns != null && this.patterns.containsKey(pattern)) {
            this.lw("Pattern already contained.", new Object[0]);
        } else {
            if (this.patterns == null) {
                this.patterns = new HashMap<GraphPattern, GraphMatcherPersistent>();
            }
            if (this.matchingGraph == null) {
                this.matchingGraph = this.principalGraph.createShadowGraph();
            }
            GraphMatcherPersistent matchingProcess = GraphMatcherPersistent.getMatcher(this.matchingGraph, pattern, this.monitor);
            this.patterns.put(pattern, matchingProcess);
        }
        return this;
    }

    @Override
    public GMPImplementation removePattern(GraphPattern pattern) {
        if (!this.patterns.containsKey(pattern)) {
            this.le("Pattern not contained.", new Object[0]);
        } else {
            this.patterns.get(pattern).clearData();
            this.patterns.remove(pattern);
        }
        return this;
    }

    @Override
    public Collection<GraphPattern> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns.keySet());
    }

    @Override
    public Set<Match> incrementSequence() {
        int mem = 0;
        for (GraphMatcherPersistent gm : this.patterns.values()) {
            mem += gm.getMemory();
        }
        this.monitor.setMemoryIndication(mem);
        if (!this.matchingGraph.canIncrement()) {
            return null;
        }
        Map<GraphComponent, TrackingGraph.Operation> operations = this.matchingGraph.getNextSequenceOperations();
        this.matchingGraph.incrementSequence();
        for (Map.Entry<GraphComponent, TrackingGraph.Operation> op : operations.entrySet()) {
            if (op.getValue() != TrackingGraph.Operation.REMOVE || !(op.getKey() instanceof Edge)) continue;
            for (GraphMatcherPersistent gm : this.patterns.values()) {
                gm.removeMatches((Edge)op.getKey());
            }
        }
        for (Map.Entry<GraphComponent, TrackingGraph.Operation> op : operations.entrySet()) {
            if (op.getValue() != TrackingGraph.Operation.ADD || !(op.getKey() instanceof Edge)) continue;
            for (GraphMatcherPersistent gm : this.patterns.values()) {
                gm.addMatches((Edge)op.getKey());
            }
        }
        HashSet<Match> ret = new HashSet<Match>();
        for (GraphMatcherPersistent gm : this.patterns.values()) {
            ret.addAll(gm.getAllCompleteMatches());
        }
        return ret;
    }

    @Override
    public List<Map.Entry<Integer, Set<Match>>> incrementSequence(int targetSequence) {
        ArrayList<Map.Entry<Integer, Set<Match>>> ret = new ArrayList<Map.Entry<Integer, Set<Match>>>();
        while (this.getMathingSequence() < Math.min(this.getGraphSequence(), targetSequence > 0 ? targetSequence : this.getGraphSequence())) {
            Set<Match> result = this.incrementSequence();
            if (result == null) continue;
            ret.add(new AbstractMap.SimpleEntry<Integer, Set<Match>>(new Integer(this.getMathingSequence()), result));
        }
        return ret;
    }

    @Override
    public List<Map.Entry<Integer, Set<Match>>> incrementSequenceFastForward() {
        return this.incrementSequence(-1);
    }

    @Override
    public Set<Match> getMatches(GraphPattern pattern, int maxK) {
        if (!this.patterns.containsKey(pattern)) {
            throw new IllegalArgumentException("Pattern is not part of this platform");
        }
        GraphMatchingProcess GM = this.patterns.get(pattern);
        return new HashSet<Match>(GM.getAllMatches(maxK));
    }

    @Override
    public int getMathingSequence() {
        if (this.matchingGraph == null) {
            if (this.principalGraph == null) {
                return -1;
            }
            return this.principalGraph.getSequence();
        }
        return this.matchingGraph.getSequence();
    }

    @Override
    public int getGraphSequence() {
        if (this.principalGraph == null) {
            return -1;
        }
        return this.principalGraph.getSequence();
    }

    @Override
    public GraphMatchingProcess getMatcherAgainstGraph(GraphPattern pattern) {
        return GraphMatcherPersistent.getMatcher(this.principalGraph.createShadowGraph(), pattern, this.monitor);
    }

    public static class PrincipalGraph
    extends TrackingGraph
    implements GraphMatchingPlatform.PlatformPrincipalGraph,
    GraphMatchingPlatform.PlatformShadowGraph {
        public PrincipalGraph() {
        }

        protected PrincipalGraph(Queue<TrackingGraph.Transaction> transactionsLink, int initialSequence, Graph initialGraph) {
            super(transactionsLink, initialSequence, initialGraph);
        }

        @Override
        public GraphMatchingPlatform.PlatformShadowGraph createShadowGraph() {
            return new PrincipalGraph(this.createShadowQueue(), this.getSequence(), this);
        }
    }
}

