/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matcher;

import java.util.concurrent.atomic.AtomicInteger;
import net.xqhs.graphs.matcher.MatchingVisualizer;
import net.xqhs.util.logging.Debug;
import net.xqhs.util.logging.LoggerSimple;

public class MonitorPack
implements LoggerSimple {
    MatchingVisualizer visual = null;
    LoggerSimple log = null;
    AtomicInteger performanceNodes = new AtomicInteger();
    AtomicInteger performanceNodesLabels = new AtomicInteger();
    AtomicInteger performanceEdges = new AtomicInteger();
    AtomicInteger performanceEdgesLabels = new AtomicInteger();
    AtomicInteger matchCount = new AtomicInteger();
    AtomicInteger mergeCount = new AtomicInteger();
    AtomicInteger memory = new AtomicInteger();

    public MonitorPack setLog(LoggerSimple logger) {
        this.log = logger;
        return this;
    }

    public MonitorPack setVisual(MatchingVisualizer visualizer) {
        this.visual = visualizer;
        return this;
    }

    public MatchingVisualizer getVisual() {
        return this.visual;
    }

    public int getPerformanceNodes() {
        return this.performanceNodes.get();
    }

    public int getPerformanceNodesLabels() {
        return this.performanceNodesLabels.get();
    }

    public int getPerformanceEdges() {
        return this.performanceEdges.get();
    }

    public int getPerformanceEdgesLabels() {
        return this.performanceEdgesLabels.get();
    }

    public int getMatchCount() {
        return this.matchCount.get();
    }

    public int getMergeCount() {
        return this.mergeCount.get();
    }

    public int getMemoryIndication() {
        return this.memory.get();
    }

    public int incrementEdgeLabelComparison() {
        return this.performanceEdgesLabels.incrementAndGet();
    }

    public int incrementEdgeLabelComparison(int increment) {
        return this.performanceEdgesLabels.addAndGet(increment);
    }

    public int incrementEdgeReferenceOperation() {
        return this.performanceEdges.incrementAndGet();
    }

    public int incrementEdgeReferenceOperation(int increment) {
        return this.performanceEdges.addAndGet(increment);
    }

    public int incrementNodeLabelComparison() {
        return this.performanceNodesLabels.incrementAndGet();
    }

    public int incrementNodeLabelComparison(int increment) {
        return this.performanceNodesLabels.addAndGet(increment);
    }

    public int incrementNodeReferenceOperation() {
        return this.performanceNodes.incrementAndGet();
    }

    public int incrementNodeReferenceOperation(int increment) {
        return this.performanceNodes.addAndGet(increment);
    }

    public int incrementMatchCount() {
        return this.matchCount.incrementAndGet();
    }

    public int incrementMergeCount() {
        return this.mergeCount.incrementAndGet();
    }

    public int setMemoryIndication(int indication) {
        int ret = this.memory.get();
        this.memory.set(indication);
        return ret;
    }

    public String printStats() {
        String stats = "";
        stats = String.valueOf(stats) + "nodes Ops|Labels: " + this.performanceNodes + "|" + this.performanceNodesLabels + "; edges Ops|Labels: " + this.performanceEdges + "|" + this.performanceEdgesLabels + "; matches: " + this.matchCount + "; merges: " + this.mergeCount + "; memory: " + this.memory;
        stats = String.valueOf(stats) + " $$> " + this.performanceNodes + ", " + this.performanceNodesLabels + ", " + this.performanceEdges + ", " + this.performanceEdgesLabels + ", " + this.matchCount + ", " + this.mergeCount + "," + this.memory + "<$$";
        this.li(stats, new Object[0]);
        return stats;
    }

    public void le(String message, Object ... arguments) {
        if (this.log != null) {
            this.log.le(message, arguments);
        }
    }

    public void lw(String message, Object ... arguments) {
        if (this.log != null) {
            this.log.lw(message, arguments);
        }
    }

    public void li(String message, Object ... arguments) {
        if (this.log != null) {
            this.log.li(message, arguments);
        }
    }

    public void lf(String message, Object ... arguments) {
        if (this.log != null) {
            this.log.lf(message, arguments);
        }
    }

    public Object lr(Object ret) {
        if (this.log != null) {
            return this.log.lr(ret);
        }
        return ret;
    }

    public Object lr(Object ret, String message, Object ... arguments) {
        if (this.log != null) {
            return this.log.lr(ret, message, arguments);
        }
        return ret;
    }

    public void dbg(Debug.DebugItem debug, String message, Object ... arguments) {
        if (this.log != null) {
            this.log.dbg(debug, message, arguments);
        }
    }
}

