/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matcher;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.xqhs.graphical.GCanvas;
import net.xqhs.graphical.GElement;
import net.xqhs.graphical.GLabel;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.matcher.Match;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.graphical.GraphicalRepresentationElement;
import net.xqhs.graphs.representation.graphical.RadialGraphRepresentation;
import net.xqhs.util.logging.Unit;

public class MatchingVisualizer
extends Unit {
    GCanvas theCanvas = null;
    Point topleftLine = null;
    int lineHeight = 200;
    float lineSpacing = 0.2f;
    int fontSize = 20;

    public MatchingVisualizer setCanvas(GCanvas canvas) {
        this.theCanvas = canvas;
        return this;
    }

    public MatchingVisualizer setTopLeft(Point topleft) {
        this.topleftLine = topleft;
        return this;
    }

    public MatchingVisualizer setLineHeight(int height) {
        this.lineHeight = height;
        return this;
    }

    public MatchingVisualizer feedLine(Match m1, String comment) {
        ArrayList<Match> ms = new ArrayList<Match>(1);
        ms.add(m1);
        return this.feedLine(ms, comment);
    }

    public MatchingVisualizer feedLine(Match m1, Match m2, String comment) {
        ArrayList<Match> ms = new ArrayList<Match>(2);
        ms.add(m1);
        ms.add(m2);
        return this.feedLine(ms, comment);
    }

    public MatchingVisualizer feedLine(Match m1, Match m2, Match m3, String comment) {
        ArrayList<Match> ms = new ArrayList<Match>(3);
        ms.add(m1);
        ms.add(m2);
        ms.add(m3);
        return this.feedLine(ms, comment);
    }

    public MatchingVisualizer feedLine(List<Match> ms, String comment) {
        GraphRepresentation lastrepr = null;
        int i = 0;
        for (Match m : ms) {
            lastrepr = m.toVisual(this.theCanvas, new Point(this.topleftLine.x + i * 2 * this.lineHeight, this.topleftLine.y), new Point(this.topleftLine.x + (i + 1) * 2 * this.lineHeight, this.topleftLine.y + this.lineHeight));
            ++i;
        }
        new GLabel().setCanvas(this.theCanvas).setFont(0, (float)this.fontSize).setText(comment).setReference(((GraphicalRepresentationElement)lastrepr.getRepresentation()).getGElement(), GElement.ReferenceType.CENTER);
        this.theCanvas.repaint();
        this.topleftLine.setLocation((double)this.topleftLine.x, (float)this.topleftLine.y + (float)this.lineHeight * (1.0f + this.lineSpacing));
        return this;
    }

    public MatchingVisualizer feedLine(Graph graph, VisualizableGraphComponent highlight, String comment) {
        GraphRepresentation repr = new RadialGraphRepresentation(graph).setCanvas(this.theCanvas).setOrigin(this.topleftLine).setBottomRight(new Point(this.topleftLine.x + this.lineHeight, this.topleftLine.y + this.lineHeight)).update();
        if (highlight != null) {
            ((GraphicalRepresentationElement)highlight.getFirstRepresentationForRoot(repr)).setHighlighted(true);
        }
        new GLabel().setCanvas(this.theCanvas).setFont(0, (float)this.fontSize).setText(comment).setReference(((GraphicalRepresentationElement)repr.getRepresentation()).getGElement(), GElement.ReferenceType.CENTER);
        this.theCanvas.repaint();
        this.topleftLine.setLocation((double)this.topleftLine.x, (float)this.topleftLine.y + (float)this.lineHeight * (1.0f + this.lineSpacing));
        return this;
    }

    public MatchingVisualizer feedLine(String comment) {
        GElement label = new GLabel().setCanvas(this.theCanvas).setFont(0, (float)this.fontSize).setText(comment).setMoveTo((Point2D)new Point2D.Float(this.topleftLine.x, this.topleftLine.y));
        this.theCanvas.repaint();
        this.topleftLine.setLocation((double)this.topleftLine.x, (double)this.topleftLine.y + label.getCurrentBox().getHeight() + (double)((float)this.lineHeight * this.lineSpacing));
        return this;
    }
}

