/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matcher;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.xqhs.graphical.GCanvas;
import net.xqhs.graphical.GConnector;
import net.xqhs.graphical.GElement;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.SimpleGraph;
import net.xqhs.graphs.matcher.MonitorPack;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.graphs.representation.GraphRepresentation;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.graphical.GraphicalRepresentationElement;
import net.xqhs.graphs.representation.graphical.RadialGraphRepresentation;
import net.xqhs.graphs.representation.text.TextGraphRepresentation;

public class Match {
    Graph targetGraphLink;
    GraphPattern patternLink;
    Graph matchedGraph;
    GraphPattern solvedPart;
    GraphPattern unsolvedPart;
    int k;
    Map<Node, Node> nodeFunction;
    Map<Edge, List<Edge>> edgeFunction;
    Map<Node, AtomicInteger> frontier = null;
    Set<Match> mergeCandidates = null;
    Set<Match> mergeOuterCandidates = null;
    String id = "-";
    boolean valid = true;

    public Match(Graph g, GraphPattern p) {
        this.targetGraphLink = g;
        this.patternLink = p;
    }

    public Match(Graph g, GraphPattern p, Edge e, Edge eP, String id) {
        this(g, p);
        this.matchedGraph = new SimpleGraph().addNode(e.getFrom()).addNode(e.getTo()).addEdge(e);
        this.solvedPart = (GraphPattern)new GraphPattern().addNode(eP.getFrom(), false).addNode(eP.getTo(), false).addEdge(eP);
        Node ePFrom = eP.getFrom();
        Node ePTo = eP.getTo();
        this.nodeFunction = new HashMap<Node, Node>();
        this.nodeFunction.put(ePFrom, e.getFrom());
        this.nodeFunction.put(ePTo, e.getTo());
        this.edgeFunction = new HashMap<Edge, List<Edge>>();
        ArrayList<Edge> eL = new ArrayList<Edge>();
        eL.add(e);
        this.edgeFunction.put(eP, eL);
        this.frontier = new HashMap<Node, AtomicInteger>();
        if (p.getInEdges(ePFrom).size() + p.getOutEdges(ePFrom).size() > 1) {
            this.frontier.put(eP.getFrom(), new AtomicInteger(p.getInEdges(ePFrom).size() + p.getOutEdges(ePFrom).size() - 1));
        }
        if (p.getInEdges(ePTo).size() + p.getOutEdges(ePTo).size() > 1) {
            this.frontier.put(eP.getTo(), new AtomicInteger(p.getInEdges(ePTo).size() + p.getOutEdges(ePTo).size() - 1));
        }
        this.unsolvedPart = new GraphPattern();
        for (Node vP : p.getNodes()) {
            if (vP == eP.getFrom() || vP == eP.getTo()) continue;
            this.unsolvedPart.addNode(vP, false);
        }
        for (Edge ePi : p.getEdges()) {
            if (ePi == eP) continue;
            this.unsolvedPart.addEdge(ePi);
        }
        this.k = this.unsolvedPart.getEdges().size();
        this.mergeCandidates = new TreeSet<Match>(new MatchComparator(null));
        this.mergeOuterCandidates = new TreeSet<Match>(new MatchComparator(null));
        this.id = id;
    }

    protected void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getK() {
        return this.k;
    }

    public int getSize() {
        return this.solvedPart.m();
    }

    public Graph getGraph() {
        return this.targetGraphLink;
    }

    public GraphPattern getPattern() {
        return this.patternLink;
    }

    public GraphPattern getSolvedPart() {
        return this.solvedPart;
    }

    public GraphPattern getUnsolvedPart() {
        return this.unsolvedPart;
    }

    public Graph getMatchedGraph() {
        return this.matchedGraph;
    }

    public Node getMatchedGraphNode(Node patternNode) {
        if (!this.solvedPart.contains(patternNode)) {
            throw new IllegalArgumentException("Node [" + patternNode.toString() + "] not in the solved part of the match");
        }
        if (!this.nodeFunction.containsKey(patternNode)) {
            throw new IllegalStateException("Internal error: pattern node not found in the node function.");
        }
        return this.nodeFunction.get(patternNode);
    }

    public List<Edge> getMatchedGraphEdges(Edge patternEdge) {
        if (!this.solvedPart.contains(patternEdge)) {
            throw new IllegalArgumentException("Edge [" + patternEdge.toString() + "] not in the solved part of the match");
        }
        if (!this.edgeFunction.containsKey(patternEdge)) {
            throw new IllegalStateException("Internal error: pattern edge not found in the edge function.");
        }
        return this.edgeFunction.get(patternEdge);
    }

    public Candidacy getCandidacy(Match mc, Map<Edge, Set<Match>> eMatchIndex, Map<Edge, Set<Match>> ePMatchIndex, MonitorPack monitor) {
        if (mc == null || ePMatchIndex == null || eMatchIndex == null || monitor == null) {
            throw new IllegalArgumentException("Indexes must be non-null");
        }
        for (Edge eP : this.solvedPart.getEdges()) {
            monitor.incrementEdgeReferenceOperation();
            if (!ePMatchIndex.containsKey(eP) || !ePMatchIndex.get(eP).contains(mc)) continue;
            return Candidacy.NONE;
        }
        for (Edge e : this.matchedGraph.getEdges()) {
            monitor.incrementEdgeReferenceOperation();
            if (!eMatchIndex.containsKey(e) || !eMatchIndex.get(e).contains(mc)) continue;
            return Candidacy.NONE;
        }
        return this.getCandidacyInternal(mc, monitor);
    }

    protected Candidacy getCandidacyInternal(Match mc, MonitorPack monitor) {
        boolean outer = true;
        HashSet<Node> frontierIntersection = new HashSet<Node>(this.frontier.keySet());
        frontierIntersection.retainAll(mc.frontier.keySet());
        monitor.incrementNodeReferenceOperation(this.frontier.size());
        for (Node node : frontierIntersection) {
            monitor.incrementNodeReferenceOperation();
            if (this.nodeFunction.get(node) == mc.nodeFunction.get(node)) {
                outer = false;
                continue;
            }
            return Candidacy.NONE;
        }
        if (outer) {
            return Candidacy.OUTER;
        }
        return Candidacy.IMMEDIATE;
    }

    public Candidacy considerCandidate(Match mc, Map<Edge, Set<Match>> eMatchIndex, Map<Edge, Set<Match>> ePMatchIndex, MonitorPack monitor) {
        if (mc == null || mc.targetGraphLink != this.targetGraphLink || mc.patternLink != this.patternLink) {
            throw new IllegalArgumentException("Other match is not in the same space");
        }
        Candidacy cand = this.getCandidacy(mc, eMatchIndex, ePMatchIndex, monitor);
        if (cand == Candidacy.IMMEDIATE) {
            this.mergeCandidates.add(mc);
            mc.mergeCandidates.add(this);
        }
        if (cand == Candidacy.OUTER) {
            this.mergeOuterCandidates.add(mc);
            mc.mergeOuterCandidates.add(this);
        }
        return cand;
    }

    public Match merge(Match m1, Map<Edge, Set<Match>> eMatchIndex, Map<Edge, Set<Match>> ePMatchIndex, MonitorPack monitor) {
        Match newM = new Match(this.targetGraphLink, this.patternLink);
        newM.unsolvedPart = new GraphPattern();
        newM.unsolvedPart.addAll(this.patternLink.getNodes());
        newM.unsolvedPart.addAll(this.patternLink.getEdges());
        newM.k = newM.unsolvedPart.getEdges().size();
        HashSet<Edge> totalMatch = new HashSet<Edge>();
        totalMatch.addAll(this.solvedPart.getEdges());
        totalMatch.addAll(m1.solvedPart.getEdges());
        newM.solvedPart = new GraphPattern();
        newM.nodeFunction = new HashMap<Node, Node>();
        newM.edgeFunction = new HashMap<Edge, List<Edge>>();
        newM.matchedGraph = new SimpleGraph();
        newM.frontier = new HashMap<Node, AtomicInteger>();
        for (Edge eP : totalMatch) {
            AtomicInteger fromIndex;
            monitor.incrementEdgeReferenceOperation(2);
            newM.solvedPart.addEdge(eP).addNode(eP.getFrom()).addNode(eP.getTo());
            newM.unsolvedPart.removeEdge(eP).removeNode(eP.getFrom()).removeNode(eP.getTo());
            --newM.k;
            Match sourceMatch = null;
            if (this.solvedPart.contains(eP)) {
                sourceMatch = this;
            }
            if (m1.solvedPart.contains(eP)) {
                if (sourceMatch != null) {
                    monitor.le("match-intersection pattern edge found: []", eP);
                    System.out.println("\t\t [" + this + "] \t\t [" + m1 + "]");
                    throw new IllegalArgumentException("match-intersection edge");
                }
                sourceMatch = m1;
            }
            if (sourceMatch == null) {
                throw new InternalError("edge not found in total match");
            }
            newM.nodeFunction.put(eP.getFrom(), sourceMatch.nodeFunction.get(eP.getFrom()));
            newM.nodeFunction.put(eP.getTo(), sourceMatch.nodeFunction.get(eP.getTo()));
            newM.edgeFunction.put(eP, sourceMatch.edgeFunction.get(eP));
            for (Edge em : sourceMatch.edgeFunction.get(eP)) {
                newM.matchedGraph.addEdge(em).addNode(em.getFrom()).addNode(em.getTo());
                if (eMatchIndex != null) {
                    if (!eMatchIndex.containsKey(em)) {
                        eMatchIndex.put(em, new HashSet());
                    }
                    eMatchIndex.get(em).add(newM);
                }
                monitor.incrementEdgeReferenceOperation(1);
            }
            if (ePMatchIndex != null) {
                if (!ePMatchIndex.containsKey(eP)) {
                    ePMatchIndex.put(eP, new HashSet());
                }
                ePMatchIndex.get(eP).add(newM);
                monitor.incrementEdgeReferenceOperation(1);
            }
            if ((fromIndex = newM.frontier.get(eP.getFrom())) != null) {
                if (fromIndex.decrementAndGet() == 0) {
                    newM.frontier.remove(eP.getFrom());
                } else {
                    newM.frontier.put(eP.getFrom(), fromIndex);
                }
            } else {
                newM.frontier.put(eP.getFrom(), new AtomicInteger(this.patternLink.getInEdges(eP.getFrom()).size() + this.patternLink.getOutEdges(eP.getFrom()).size() - 1));
            }
            AtomicInteger toIndex = newM.frontier.get(eP.getTo());
            if (toIndex != null) {
                if (toIndex.decrementAndGet() == 0) {
                    newM.frontier.remove(eP.getTo());
                } else {
                    newM.frontier.put(eP.getTo(), toIndex);
                }
            } else {
                newM.frontier.put(eP.getTo(), new AtomicInteger(this.patternLink.getInEdges(eP.getTo()).size() + this.patternLink.getOutEdges(eP.getTo()).size() - 1));
            }
            monitor.incrementNodeReferenceOperation(4);
        }
        newM.mergeCandidates = new HashSet<Match>(this.mergeCandidates);
        HashSet<Match> partB = new HashSet<Match>(this.mergeCandidates);
        HashSet<Match> partC = new HashSet<Match>(m1.mergeCandidates);
        newM.mergeCandidates.retainAll(m1.mergeCandidates);
        partB.retainAll(m1.mergeOuterCandidates);
        partC.retainAll(this.mergeOuterCandidates);
        newM.mergeCandidates.addAll(partB);
        newM.mergeCandidates.addAll(partC);
        newM.mergeOuterCandidates = new HashSet<Match>(this.mergeOuterCandidates);
        newM.mergeOuterCandidates.retainAll(m1.mergeOuterCandidates);
        Iterator<Match> mi = this.mergeCandidates.iterator();
        while (mi.hasNext()) {
            if (mi.next().isValid()) continue;
            mi.remove();
        }
        mi = this.mergeOuterCandidates.iterator();
        while (mi.hasNext()) {
            if (mi.next().isValid()) continue;
            mi.remove();
        }
        monitor.incrementEdgeReferenceOperation(this.mergeCandidates.size() + m1.mergeCandidates.size() + this.mergeOuterCandidates.size() + m1.mergeOuterCandidates.size());
        return newM;
    }

    public static String toStringDemo() {
        String ret = "match [ <id> ] (k= <k> ): ";
        ret = String.valueOf(ret) + "<G'><GmP>\n\t";
        ret = String.valueOf(ret) + "Gx: <GxP>\n\t";
        ret = String.valueOf(ret) + "frontier: <frontier>";
        ret = String.valueOf(ret) + "mCs: [ <merge candidates ids> ] \n\t";
        ret = String.valueOf(ret) + "fv: <node function>";
        return ret;
    }

    public String toString() {
        String ret = "M" + (this.valid ? "" : "[INVALID]") + "[" + this.id + "]K=" + this.k + new TextGraphRepresentation(this.solvedPart).setLayout("", "", -1).update() + "|" + new TextGraphRepresentation(this.matchedGraph).setLayout("", "", -1).update();
        return ret;
    }

    public String toStringExtended() {
        String ret = "match [" + this.id + "] (k=" + this.k + "): \t";
        ret = String.valueOf(ret) + new TextGraphRepresentation(this.matchedGraph).setLayout("", " ", 2).update() + "\t : \t";
        ret = String.valueOf(ret) + new TextGraphRepresentation(this.solvedPart).setLayout("", " ", 2).update() + "\t";
        ret = String.valueOf(ret) + "Gx: " + new TextGraphRepresentation(this.unsolvedPart).setLayout("", " ", 2).update() + "\t";
        ret = String.valueOf(ret) + "frontier: " + this.frontier + "; ";
        ret = String.valueOf(ret) + "mCs: [";
        for (Match mi : this.mergeCandidates) {
            if (!mi.isValid()) continue;
            ret = String.valueOf(ret) + mi.id + ", ";
        }
        ret = String.valueOf(ret) + "] mOCs: [";
        for (Match moi : this.mergeOuterCandidates) {
            if (!moi.isValid()) continue;
            ret = String.valueOf(ret) + moi.id + ", ";
        }
        ret = String.valueOf(ret) + "] \t";
        ret = String.valueOf(ret) + "fv: " + this.nodeFunction;
        return ret;
    }

    public String toStringLong() {
        String ret = "match: \n\t";
        ret = String.valueOf(ret) + "G': " + new TextGraphRepresentation(this.matchedGraph).setLayout("", " ", 2).update() + "\n\t";
        ret = String.valueOf(ret) + "Gm: " + new TextGraphRepresentation(this.solvedPart).setLayout("", " ", 2).update() + "\n\t";
        ret = String.valueOf(ret) + "Gx: " + new TextGraphRepresentation(this.unsolvedPart).setLayout("", " ", 2).update() + "\n\t";
        ret = String.valueOf(ret) + "fv: " + this.nodeFunction + "\n\t";
        ret = String.valueOf(ret) + "fe: " + this.edgeFunction + "\n\t";
        ret = String.valueOf(ret) + "k=" + this.k;
        return ret;
    }

    public GraphRepresentation toVisual(GCanvas canvas, Point topleft, Point bottomright) {
        int tw = bottomright.x - topleft.x;
        GraphRepresentation GR = new RadialGraphRepresentation(this.targetGraphLink).setCanvas(canvas).setOrigin(topleft).setBottomRight(new Point(topleft.x + tw / 2, bottomright.y)).update();
        GraphRepresentation GPR = new RadialGraphRepresentation(this.patternLink).setCanvas(canvas).setOrigin(new Point(topleft.x + tw / 2, topleft.y)).setBottomRight(bottomright).update();
        for (Map.Entry<Edge, List<Edge>> corr : this.edgeFunction.entrySet()) {
            GElement el1 = ((GraphicalRepresentationElement)((VisualizableGraphComponent)((Object)corr.getKey())).getFirstRepresentationForRoot(GPR)).getGElement();
            GElement el2 = ((GraphicalRepresentationElement)((VisualizableGraphComponent)((Object)corr.getValue().iterator().next())).getFirstRepresentationForRoot(GR)).getGElement();
            el1.setColor(Color.RED);
            el2.setColor(Color.RED);
            new GConnector().setFrom(el1).setTo(el2).setCanvas(canvas).setColor(Color.RED).setStrokeWidth(0.5f);
        }
        return GPR;
    }

    public static enum Candidacy {
        OUTER,
        IMMEDIATE,
        NONE;

    }

    public static class MatchComparator
    implements Comparator<Match> {
        private MonitorPack monitorLink = null;

        public MatchComparator(MonitorPack monitor) {
            this.monitorLink = monitor;
        }

        @Override
        public int compare(Match m1, Match m2) {
            if (m1.k != m2.k) {
                return m1.k - m2.k;
            }
            if (m1.id.equals(m2.id)) {
                return m1.hashCode() - m2.hashCode();
            }
            return m1.id.compareTo(m2.id);
        }
    }
}

