/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.matcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.matcher.GraphMatchingProcess;
import net.xqhs.graphs.matcher.Match;
import net.xqhs.graphs.matcher.MonitorPack;
import net.xqhs.graphs.pattern.EdgeP;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.graphs.pattern.NodeP;
import net.xqhs.graphs.representation.VisualizableGraphComponent;
import net.xqhs.graphs.representation.text.TextGraphRepresentation;
import net.xqhs.graphs.util.Debug;

public class GraphMatcherQuick
implements GraphMatchingProcess {
    protected Graph graph;
    protected GraphPattern pattern;
    protected MonitorPack monitor;
    protected PriorityQueue<Match> matchQueue = null;
    protected List<Match> allMatches = null;
    protected Iterator<Match> matchIterator = null;
    protected boolean initialState = true;
    protected int kThreshold = 0;

    protected GraphMatcherQuick(Graph graph, GraphPattern pattern) {
        this.graph = graph;
        this.pattern = pattern;
    }

    public GraphMatcherQuick setMonitor(MonitorPack monitoring) {
        this.monitor = monitoring;
        return this;
    }

    public GraphMatcherQuick initializeMatching() {
        this.allMatches = new ArrayList<Match>();
        this.matchQueue = this.initializeMatchQueue();
        this.addInitialMatches();
        this.initialState = true;
        return this;
    }

    @Override
    public GraphMatcherQuick resetIterator() {
        this.initialState = true;
        return this;
    }

    @Override
    public GraphMatcherQuick resetIterator(int k) {
        this.kThreshold = k;
        return this.resetIterator();
    }

    @Override
    public GraphMatcherQuick clearData() {
        this.matchQueue.clear();
        this.allMatches.clear();
        this.matchQueue = null;
        this.allMatches = null;
        return this;
    }

    @Override
    public Match getNextMatch() {
        this.monitor.dbg(Debug.D_G.D_MATCHING_PROGRESS, "iterating;queue;all: === ", this.matchIterator != null ? "Y" : "N", this.matchQueue != null ? new Integer(this.matchQueue.size()) : "-", this.allMatches != null ? new Integer(this.allMatches.size()) : "-");
        if (this.matchQueue == null || this.allMatches == null) {
            this.initializeMatching();
        }
        if (this.initialState) {
            this.matchIterator = this.allMatches.iterator();
        }
        this.initialState = false;
        if (this.matchIterator != null) {
            while (this.matchIterator.hasNext()) {
                Match m = this.matchIterator.next();
                if (!m.isValid()) {
                    this.matchIterator.remove();
                    continue;
                }
                if (m.k > this.kThreshold) continue;
                return m;
            }
        }
        this.monitor.dbg(Debug.D_G.D_MATCHING_PROGRESS, "iterating;queue;all: =:= ", this.matchIterator != null ? "Y" : "N", this.matchQueue != null ? new Integer(this.matchQueue.size()) : "-", this.allMatches != null ? new Integer(this.allMatches.size()) : "-");
        this.matchIterator = null;
        List<Match> result = this.growMatches(this.kThreshold, true);
        this.monitor.dbg(Debug.D_G.D_MATCHING_PROGRESS, "iterating;queue;all: ==/ ", this.matchIterator != null ? "Y" : "N", this.matchQueue != null ? new Integer(this.matchQueue.size()) : "-", this.allMatches != null ? new Integer(this.allMatches.size()) : "-");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public List<Match> getAllMatches(int k) {
        if (this.matchQueue == null || this.allMatches == null) {
            this.initializeMatching();
        }
        this.resetIterator(k);
        this.matchIterator = this.allMatches.iterator();
        ArrayList<Match> result = new ArrayList<Match>();
        while (this.matchIterator.hasNext()) {
            Match m = this.matchIterator.next();
            if (!m.isValid()) {
                this.matchIterator.remove();
                continue;
            }
            if (m.k > this.kThreshold) continue;
            result.add(m);
        }
        this.matchIterator = null;
        result.addAll(this.growMatches(k, false));
        return result;
    }

    @Override
    public List<Match> getAllCompleteMatches() {
        return this.getAllMatches(0);
    }

    @Override
    public List<Match> getBestMatches() {
        List<Match> ret = this.getAllCompleteMatches();
        int bestK = 0;
        if (ret.isEmpty()) {
            bestK = this.pattern.m();
            for (Match m : this.allMatches) {
                if (!m.isValid()) {
                    this.matchIterator.remove();
                    continue;
                }
                if (m.k == bestK) {
                    ret.add(m);
                    continue;
                }
                if (m.k >= bestK) continue;
                ret.clear();
                ret.add(m);
                bestK = m.k;
            }
        }
        this.resetIterator(bestK);
        return ret;
    }

    protected PriorityQueue<Match> initializeMatchQueue() {
        Map<Node, Integer> distances = this.computeVertexDistances();
        MatchSingleComparator matchComparator = new MatchSingleComparator(distances, this.monitor);
        return new PriorityQueue<Match>(1, matchComparator);
    }

    protected Map<Node, Integer> computeVertexDistances() {
        TreeSet<Node> vertexSet = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                GraphMatcherQuick.this.monitor.incrementNodeReferenceOperation();
                int out1 = GraphMatcherQuick.this.pattern.getOutEdges(n1).size() - GraphMatcherQuick.this.pattern.getInEdges(n1).size();
                int out2 = GraphMatcherQuick.this.pattern.getOutEdges(n2).size() - GraphMatcherQuick.this.pattern.getInEdges(n2).size();
                if (out1 != out2) {
                    return -(out1 - out2);
                }
                if (n1 instanceof NodeP && n2 instanceof NodeP) {
                    GraphMatcherQuick.this.monitor.incrementNodeReferenceOperation();
                    NodeP n1P = (NodeP)n1;
                    NodeP n2P = (NodeP)n2;
                    if (n1P.isGeneric() && n2P.isGeneric()) {
                        if (n1P.genericIndex() == n2P.genericIndex()) {
                            return n1P.hashCode() - n2P.hashCode();
                        }
                        return n1P.genericIndex() - n2P.genericIndex();
                    }
                    if (n1P.isGeneric()) {
                        return -1;
                    }
                    if (n2P.isGeneric()) {
                        return 1;
                    }
                }
                GraphMatcherQuick.this.monitor.incrementNodeLabelComparison();
                if (n1.getLabel().equals(n2.getLabel())) {
                    return n1.hashCode() - n2.hashCode();
                }
                return n1.getLabel().compareTo(n2.getLabel());
            }
        });
        vertexSet.addAll(this.pattern.getNodes());
        this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, "sorted vertex set: []", vertexSet);
        Node vMP = (Node)vertexSet.first();
        this.monitor.lf("start vertex: ", vMP);
        if (this.monitor.getVisual() != null && vMP instanceof VisualizableGraphComponent) {
            this.monitor.getVisual().feedLine(this.pattern, (VisualizableGraphComponent)((Object)vMP), "start vertex");
        }
        Map<Node, Integer> distances = this.pattern.computeDistancesFromUndirected(vMP);
        this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, "vertex distances: []", distances);
        return distances;
    }

    protected void addInitialMatches() {
        Comparator<Match> comparator = this.matchQueue.comparator();
        TreeSet<Edge> sortedEdges = new TreeSet<Edge>(new EdgeComparator(this.monitor));
        sortedEdges.addAll(this.pattern.getEdges());
        TreeSet<Edge> sortedGraphEdges = new TreeSet<Edge>(new EdgeComparator(this.monitor));
        sortedGraphEdges.addAll(this.graph.getEdges());
        int edgeId = 0;
        for (Edge eP : sortedEdges) {
            if (eP instanceof EdgeP && ((EdgeP)eP).isGeneric()) continue;
            int matchId = 0;
            this.monitor.lf("edge [] has id []", eP, new Integer(edgeId));
            for (Edge e : sortedGraphEdges) {
                this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, "trying edges: [] : []", eP, e);
                if (!this.isMatch(eP, e)) continue;
                Match m = this.addInitialMatch(e, eP, String.valueOf(edgeId) + ":" + matchId);
                this.monitor.incrementMatchCount();
                this.monitor.lf("new initial match: [] [] : []", m.id, m.solvedPart.getEdges().iterator().next(), m.matchedGraph.getEdges().iterator().next());
                if (Debug.D_G.D_MATCHING_INITIAL.toBool()) {
                    this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, "=======", new Object[0]);
                    String dbg_match = "=============== match queue ===============================> ";
                    Match[] dbg_sorted = this.matchQueue.toArray(new Match[1]);
                    if (comparator != null) {
                        Arrays.sort(dbg_sorted, comparator);
                    }
                    Match[] matchArray = dbg_sorted;
                    int n = dbg_sorted.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Match mdbg = matchArray[n2];
                        if (mdbg.isValid()) {
                            dbg_match = String.valueOf(dbg_match) + mdbg.id + ", ";
                        }
                        ++n2;
                    }
                    this.monitor.dbg(Debug.D_G.D_MATCHING_INITIAL, dbg_match, new Object[0]);
                }
                ++matchId;
            }
            ++edgeId;
        }
        String string = "[\n ";
        if (!this.matchQueue.isEmpty()) {
            Match[] sorted = this.matchQueue.toArray(new Match[1]);
            if (comparator != null) {
                Arrays.sort(sorted, comparator);
            }
            if (this.monitor.getVisual() != null) {
                this.monitor.getVisual().feedLine("initial matches: " + this.matchQueue.size());
            }
            Match[] matchArray = sorted;
            int n = sorted.length;
            int n3 = 0;
            while (n3 < n) {
                Match m = matchArray[n3];
                if (m.isValid()) {
                    string = String.valueOf(string) + m.toString() + ", \n";
                    if (this.monitor.getVisual() != null) {
                        this.monitor.getVisual().feedLine(m, "initial match");
                    }
                }
                ++n3;
            }
        }
        string = String.valueOf(string) + "]";
        this.monitor.lf("initial matches []: []-------------------------", new Integer(this.matchQueue.size()), string);
    }

    protected Match addInitialMatch(Edge e, Edge eP, String matchID) {
        Match m = new Match(this.graph, this.pattern, e, eP, matchID);
        for (Match mi : this.matchQueue) {
            if (!mi.isValid()) continue;
            boolean accept = false;
            boolean reject = false;
            this.monitor.incrementEdgeReferenceOperation(2);
            if (new HashSet<Edge>(m.solvedPart.getEdges()).removeAll(mi.solvedPart.getEdges()) || new HashSet<Edge>(m.matchedGraph.getEdges()).removeAll(mi.matchedGraph.getEdges())) {
                reject = true;
            } else {
                for (Map.Entry<Node, AtomicInteger> frontierV : mi.frontier.entrySet()) {
                    if (!m.frontier.containsKey(frontierV.getKey())) continue;
                    if (!accept && m.nodeFunction.get(frontierV.getKey()) == mi.nodeFunction.get(frontierV.getKey())) {
                        accept = true;
                    }
                    if (m.nodeFunction.get(frontierV.getKey()) != mi.nodeFunction.get(frontierV.getKey())) {
                        reject = true;
                        break;
                    }
                    this.monitor.incrementNodeReferenceOperation(2);
                }
            }
            if (reject) continue;
            if (accept) {
                m.mergeCandidates.add(mi);
                mi.mergeCandidates.add(m);
                continue;
            }
            m.mergeOuterCandidates.add(mi);
            mi.mergeOuterCandidates.add(m);
        }
        this.matchQueue.add(m);
        this.allMatches.add(m);
        return m;
    }

    protected boolean isMatch(Edge eP, Edge e) {
        this.monitor.incrementEdgeReferenceOperation();
        Node fromP = eP.getFrom();
        Node toP = eP.getTo();
        boolean fromGeneric = fromP instanceof NodeP && ((NodeP)fromP).isGeneric();
        boolean toGeneric = toP instanceof NodeP && ((NodeP)toP).isGeneric();
        this.monitor.incrementNodeLabelComparison();
        if (!fromGeneric && !fromP.getLabel().equals(e.getFrom().getLabel())) {
            return false;
        }
        this.monitor.incrementNodeLabelComparison();
        if (!toGeneric && !toP.getLabel().equals(e.getTo().getLabel())) {
            return false;
        }
        if (eP.getLabel() == null) {
            return true;
        }
        if (e.getLabel() == null || e.getLabel().equals("")) {
            return true;
        }
        this.monitor.incrementEdgeLabelComparison();
        return e.getLabel() != null && eP.getLabel().equals(e.getLabel());
    }

    protected List<Match> growMatches(int threshold, boolean stopAtFirstMatch) {
        ArrayList<Match> result = new ArrayList<Match>();
        while (!this.matchQueue.isEmpty()) {
            Match m = this.matchQueue.poll();
            if (!m.isValid()) continue;
            Iterator<Match> itm = m.mergeCandidates.iterator();
            while (itm.hasNext()) {
                Match mc = itm.next();
                itm.remove();
                if (!mc.isValid()) continue;
                mc.mergeCandidates.remove(m);
                this.monitor.lf("merging \t []\n \t\t\t and \t\t []", m, mc);
                Match mr = this.addMergeMatch(m, mc);
                if (mr != null) {
                    this.monitor.lf("new match:\t []\n", mr);
                    if (this.monitor.getVisual() != null) {
                        this.monitor.getVisual().feedLine(m, mc, mr, "new match [k=" + mr.k + "]");
                    }
                    this.monitor.incrementMergeCount();
                    this.monitor.incrementMatchCount();
                    if (mr.k > threshold) continue;
                    result.add(mr);
                    if (!stopAtFirstMatch) continue;
                    return result;
                }
                this.monitor.le("merge failed\n", new Object[0]);
                if (this.monitor.getVisual() == null) continue;
                this.monitor.getVisual().feedLine("merge failed");
            }
        }
        return result;
    }

    protected Match addMergeMatch(Match m1, Match m2) {
        Match newM = m1.merge(m2, null, null, this.monitor);
        this.matchQueue.add(newM);
        this.allMatches.add(newM);
        return newM;
    }

    protected void invalidateMatch(Match m) {
        m.invalidate();
    }

    public String toString() {
        return String.valueOf(new TextGraphRepresentation(this.pattern).update().toString()) + "||.";
    }

    public static GraphMatcherQuick getMatcher(Graph graph, GraphPattern pattern, MonitorPack monitoring) {
        if (monitoring == null) {
            throw new IllegalArgumentException();
        }
        if (monitoring.getVisual() != null) {
            monitoring.getVisual().feedLine(graph, null, "the graph");
            monitoring.getVisual().feedLine(pattern, null, "the pattern");
        }
        return new GraphMatcherQuick(graph, pattern).setMonitor(monitoring);
    }

    public static class EdgeComparator
    implements Comparator<Edge> {
        private MonitorPack monitorLink = null;

        public EdgeComparator(MonitorPack monitor) {
            this.monitorLink = monitor;
        }

        @Override
        public int compare(Edge e1, Edge e2) {
            if (e1.getLabel() == null) {
                return -1;
            }
            if (e2.getLabel() == null) {
                return 1;
            }
            this.monitorLink.incrementEdgeLabelComparison();
            if (!e1.getLabel().equals(e2.getLabel())) {
                return e1.getLabel().compareTo(e2.getLabel());
            }
            return e1.hashCode() - e2.hashCode();
        }
    }

    protected static class MatchSingleComparator
    extends Match.MatchComparator {
        private Map<Node, Integer> distances = null;
        private MonitorPack monitorLink = null;

        protected MatchSingleComparator(Map<Node, Integer> vertexDistances, MonitorPack monitor) {
            super(monitor);
            this.distances = vertexDistances;
        }

        @Override
        public int compare(Match m1, Match m2) {
            if (m1.solvedPart.m() == 1 && m2.solvedPart.m() == 1 && this.distances != null) {
                Edge e1 = m1.solvedPart.getEdges().iterator().next();
                Edge e2 = m2.solvedPart.getEdges().iterator().next();
                int result = Math.min(this.distances.get(e1.getFrom()), this.distances.get(e1.getTo())) - Math.min(this.distances.get(e2.getFrom()), this.distances.get(e2.getTo()));
                if (this.monitorLink != null) {
                    this.monitorLink.incrementEdgeReferenceOperation(2);
                }
                if (result != 0) {
                    return result;
                }
            }
            return super.compare(m1, m2);
        }
    }
}

