/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.graph;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.graph.GraphComponent;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.NodeAlphaComparator;
import net.xqhs.graphs.graph.SimpleEdge;
import net.xqhs.graphs.graph.SimpleNode;
import net.xqhs.graphs.pattern.NodeP;
import net.xqhs.util.logging.Unit;
import net.xqhs.util.logging.UnitComponent;

public class SimpleGraph
extends Unit
implements Graph {
    public static char EDGE_SEPARATOR = (char)59;
    public static char EDGE_LINE = (char)45;
    public static char EDGE_TARGET = (char)62;
    protected Map<Node, NodeData> nodes = new HashMap<Node, NodeData>();
    protected Set<Edge> edges = new HashSet<Edge>();

    public String getUnitName() {
        return super.getUnitName();
    }

    @Override
    public SimpleGraph addNode(Node node) {
        return this.add(node);
    }

    @Override
    public SimpleGraph addEdge(Edge edge) {
        return this.add(edge);
    }

    @Override
    public SimpleGraph add(GraphComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("null components not allowed");
        }
        if (component instanceof Node) {
            Node node = (Node)component;
            if (!this.contains(node)) {
                HashSet<Edge> outEdges = new HashSet<Edge>();
                HashSet<Edge> inEdges = new HashSet<Edge>();
                for (Edge e : this.edges) {
                    if (e.getFrom() == node) {
                        outEdges.add(e);
                    }
                    if (e.getTo() != node) continue;
                    inEdges.add(e);
                }
                this.nodes.put(node, new NodeData(inEdges, outEdges));
            } else {
                this.lw("node [] already present. Not re-added.", new Object[]{node});
            }
        } else if (component instanceof Edge) {
            Edge edge = (Edge)component;
            if (!this.contains(edge)) {
                this.edges.add(edge);
                if (this.contains(edge.getFrom())) {
                    this.nodes.get(edge.getFrom()).getOutEdges().add(edge);
                }
                if (this.contains(edge.getTo())) {
                    this.nodes.get(edge.getTo()).getInEdges().add(edge);
                }
            } else {
                this.lw("edge [] already present. Not re-added.", new Object[]{edge});
            }
        } else {
            throw new IllegalArgumentException("Given component is not one of Node, Edge.");
        }
        return this;
    }

    @Override
    public SimpleGraph addAll(Collection<? extends GraphComponent> components) {
        for (GraphComponent graphComponent : components) {
            this.add(graphComponent);
        }
        return this;
    }

    @Override
    public SimpleGraph removeNode(Node node) {
        return this.remove(node);
    }

    @Override
    public SimpleGraph removeEdge(Edge edge) {
        return this.remove(edge);
    }

    @Override
    public SimpleGraph remove(GraphComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("given components is null.");
        }
        if (!this.contains(component)) {
            this.lr(this, "component [] not contained", new Object[]{component});
        }
        if (component instanceof Node) {
            this.nodes.remove(component);
        } else if (component instanceof Edge) {
            Edge edge = (Edge)component;
            if (this.contains(edge.getFrom())) {
                this.nodes.get(edge.getFrom()).getOutEdges().remove(edge);
            }
            if (this.contains(edge.getTo())) {
                this.nodes.get(edge.getTo()).getInEdges().remove(edge);
            }
            this.edges.remove(edge);
        } else {
            throw new IllegalArgumentException("Given component is not one of Node, Edge.");
        }
        return this;
    }

    @Override
    public Graph removeAll(Collection<? extends GraphComponent> components) {
        for (GraphComponent graphComponent : components) {
            this.remove(graphComponent);
        }
        return this;
    }

    @Override
    public int n() {
        return this.nodes.size();
    }

    @Override
    public int m() {
        return this.edges.size();
    }

    @Override
    public int size() {
        return this.n();
    }

    @Override
    public Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.keySet());
    }

    @Override
    public Collection<Edge> getEdges() {
        return Collections.unmodifiableCollection(this.edges);
    }

    @Override
    public Collection<GraphComponent> getComponents() {
        HashSet<GraphComponent> ret = new HashSet<GraphComponent>(this.nodes.keySet());
        ret.addAll(this.edges);
        return ret;
    }

    @Override
    public Collection<Edge> getOutEdges(Node node) {
        if (!this.contains(node)) {
            throw new IllegalArgumentException("node " + node + " is not in graph");
        }
        return Collections.unmodifiableCollection(this.nodes.get(node).getOutEdges());
    }

    @Override
    public Collection<Edge> getInEdges(Node node) {
        if (!this.contains(node)) {
            throw new IllegalArgumentException("node " + node + " is not in graph");
        }
        return Collections.unmodifiableCollection(this.nodes.get(node).getInEdges());
    }

    @Override
    public boolean contains(GraphComponent component) {
        if (component instanceof Node) {
            return this.nodes.containsKey(component);
        }
        if (component instanceof Edge) {
            return this.edges.contains(component);
        }
        throw new IllegalArgumentException("Given component is not one of Node, Edge.");
    }

    @Override
    public Collection<Node> getNodesNamed(String name) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node node : this.nodes.keySet()) {
            if (!node.getLabel().equals(name)) continue;
            ret.add(node);
        }
        return ret;
    }

    public Map<Node, Integer> computeDistancesFromUndirected(Node node) {
        if (!this.contains(node)) {
            throw new IllegalArgumentException("node " + node + " is not in graph");
        }
        HashMap<Node, Integer> dists = new HashMap<Node, Integer>();
        LinkedList<Node> grayNodes = new LinkedList<Node>();
        HashSet<Node> blackNodes = new HashSet<Node>();
        grayNodes.add(node);
        dists.put(node, new Integer(0));
        while (!grayNodes.isEmpty()) {
            Node cNode = (Node)grayNodes.poll();
            if (!this.contains(cNode)) {
                this.lw("Node [] is not in graph.", new Object[]{cNode});
                continue;
            }
            int dist = (Integer)dists.get(cNode);
            blackNodes.add(cNode);
            for (Edge e : this.getOutEdges(cNode)) {
                if (blackNodes.contains(e.getTo())) continue;
                if (!grayNodes.contains(e.getTo())) {
                    grayNodes.add(e.getTo());
                }
                if (dists.containsKey(e.getTo()) && (Integer)dists.get(e.getTo()) <= dist + 1) continue;
                dists.put(e.getTo(), new Integer(dist + 1));
            }
            for (Edge e : this.getInEdges(cNode)) {
                if (blackNodes.contains(e.getFrom())) continue;
                if (!grayNodes.contains(e.getFrom())) {
                    grayNodes.add(e.getFrom());
                }
                if (dists.containsKey(e.getFrom()) && (Integer)dists.get(e.getFrom()) <= dist + 1) continue;
                dists.put(e.getFrom(), new Integer(dist + 1));
            }
        }
        return dists;
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "G[" + this.n() + ", " + this.m() + "] ";
        ArrayList<Node> list = new ArrayList<Node>(this.nodes.keySet());
        Collections.sort(list, new NodeAlphaComparator());
        ret = String.valueOf(ret) + ((Object)list).toString();
        for (Edge e : this.edges) {
            ret = String.valueOf(ret) + "\n" + e.toString();
        }
        return ret;
    }

    public String toDot() {
        String ret = "digraph G {\n";
        for (Edge edge : this.edges) {
            String fromNode = edge.getFrom().toString();
            String toNode = edge.getTo().toString();
            ret = String.valueOf(ret) + "\t";
            ret = String.valueOf(ret) + "\"" + fromNode + "\"";
            ret = String.valueOf(ret) + " -> ";
            ret = String.valueOf(ret) + "\"" + toNode + "\"";
            if (edge.getLabel() != null) {
                ret = String.valueOf(ret) + " [label=\"" + edge.getLabel() + "\"]";
            }
            ret = String.valueOf(ret) + ";\n";
        }
        for (Node node : this.nodes.keySet()) {
            if (!(node instanceof NodeP) || !((NodeP)node).isGeneric()) continue;
            ret = String.valueOf(ret) + "\t\"" + node.toString() + "\" [label=\"" + node.getLabel() + "\"];\n";
        }
        ret = String.valueOf(ret) + "}";
        return ret;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public SimpleGraph readFrom(InputStream input) {
        log = (UnitComponent)new UnitComponent().setLink(this.getUnitName());
        scan = new Scanner(input);
        while (scan.hasNextLine()) {
            line = scan.nextLine();
            var9_9 = edgeReads = line.split(Character.toString(SimpleGraph.EDGE_SEPARATOR));
            var8_8 = edgeReads.length;
            var7_7 = 0;
            while (var7_7 < var8_8) {
                edgeRead = var9_9[var7_7];
                log.lf("new edge: ", new Object[]{edgeRead});
                bidirectional = true;
                parts1 = edgeRead.split(Character.toString(SimpleGraph.EDGE_LINE), 2);
                if (parts1.length >= 2) ** GOTO lbl19
                parts1 = edgeRead.split(Character.toString(SimpleGraph.EDGE_TARGET), 2);
                if (parts1.length < 2) {
                    log.le("input corrupted", new Object[0]);
                } else {
                    bidirectional = false;
lbl19:
                    // 2 sources

                    node1name = parts1[0].trim();
                    node2name = null;
                    edgeName = null;
                    parts2 = parts1[1].split(Character.toString(SimpleGraph.EDGE_TARGET));
                    if (parts2.length < 1 || parts2.length > 2) {
                        log.le("input corrupted", new Object[0]);
                    } else {
                        node1 /* !! */  = null;
                        node2 /* !! */  = null;
                        if (parts2.length == 2) {
                            bidirectional = false;
                            node2name = parts2[1].trim();
                            edgeName = parts2[0].length() > 0 && parts2[0].charAt(parts2[0].length() - 1) == '-' ? parts2[0].substring(0, parts2[0].length() - 1).trim() : parts2[0].trim();
                        } else {
                            idx = parts1[1].lastIndexOf(SimpleGraph.EDGE_LINE);
                            if (idx < 0) {
                                node2name = parts2[0].trim();
                            } else {
                                node2name = parts1[1].substring(idx + 1).trim();
                                edgeName = parts1[1].substring(0, idx).trim();
                            }
                        }
                        if (edgeName != null && edgeName.length() == 0) {
                            edgeName = null;
                        }
                        log.lf("[] [] []", new Object[]{node1name, node2name, edgeName});
                        if (this.getNodesNamed(node1name).isEmpty()) {
                            node1 /* !! */  = new SimpleNode(node1name);
                            this.addNode(node1 /* !! */ );
                        } else {
                            node1 /* !! */  = this.getNodesNamed(node1name).iterator().next();
                        }
                        if (this.getNodesNamed(node2name).isEmpty()) {
                            node2 /* !! */  = new SimpleNode(node2name);
                            this.addNode(node2 /* !! */ );
                        } else {
                            node2 /* !! */  = this.getNodesNamed(node2name).iterator().next();
                        }
                        this.addEdge(new SimpleEdge(node1 /* !! */ , node2 /* !! */ , edgeName));
                        if (bidirectional) {
                            this.addEdge(new SimpleEdge(node2 /* !! */ , node1 /* !! */ , edgeName));
                        }
                    }
                }
                ++var7_7;
            }
        }
        scan.close();
        return this;
    }

    protected static class NodeData {
        Set<Edge> inEdges;
        Set<Edge> outEdges;

        public NodeData(Set<Edge> in, Set<Edge> out) {
            this.inEdges = in;
            this.outEdges = out;
        }

        public Set<Edge> getInEdges() {
            return this.inEdges;
        }

        public Set<Edge> getOutEdges() {
            return this.outEdges;
        }

        public String toString() {
            return "in:" + this.inEdges.toString() + ";out:" + this.outEdges.toString();
        }
    }
}

