/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.context;

public class Instant {
    long time;

    public Instant(long instantTime) {
        this.time = instantTime;
    }

    public Instant offset(Offset offset) {
        return new Instant(this.time + offset.length);
    }

    public boolean before(Instant instant) {
        return this.time < instant.time;
    }

    public boolean after(Instant instant) {
        return this.time > instant.time;
    }

    public static class Offset {
        long length;

        public Offset(long offsetLength) {
            if (offsetLength <= 0L) {
                throw new IllegalArgumentException("Offsets are strictily positive");
            }
            this.length = offsetLength;
        }
    }

    public static interface TickReceiver {
        public void tick(TimeKeeper var1, Instant var2);
    }

    public static interface TimeKeeper {
        public Instant now();

        public void registerTickReceiver(TickReceiver var1, Offset var2);
    }
}

