/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.context;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import net.xqhs.graphs.context.CCMImplementation;
import net.xqhs.graphs.context.Instant;
import net.xqhs.graphs.graph.Edge;
import net.xqhs.graphs.graph.GraphComponent;
import net.xqhs.graphs.graph.Node;
import net.xqhs.graphs.graph.SimpleEdge;
import net.xqhs.graphs.matchingPlatform.GMPImplementation;
import net.xqhs.graphs.matchingPlatform.TrackingGraph;

public class ContextGraph
extends GMPImplementation.PrincipalGraph
implements Instant.TickReceiver {
    Instant.TimeKeeper theTime = null;
    CCMImplementation parent = null;
    PriorityQueue<Map.Entry<Instant, ContextEdge>> validityQueue;

    public ContextGraph(CCMImplementation platform) {
        this.parent = platform;
    }

    public ContextGraph(CCMImplementation platform, Queue<TrackingGraph.Transaction> transactionsLink, int initialSequence, ContextGraph initialGraph) {
        super(transactionsLink, initialSequence, initialGraph);
        this.parent = platform;
    }

    @Override
    public ContextGraph createShadowGraph() {
        return new ContextGraph(this.parent, this.createShadowQueue(), this.getSequence(), this);
    }

    protected ContextGraph setTimeKeeper(Instant.TimeKeeper time) {
        this.theTime = time;
        return this;
    }

    @Override
    protected ContextGraph performOperation(GraphComponent component, TrackingGraph.Operation operation, boolean externalCall) {
        if (this.isShadow && externalCall) {
            throw new UnsupportedOperationException("A shadow graph only takes modifications from its transaction queue.");
        }
        if (component instanceof ContextEdge) {
            switch (operation) {
                case ADD: {
                    this.validityQueue.add(new AbstractMap.SimpleEntry<Instant, ContextEdge>(this.theTime.now().offset(((ContextEdge)component).initialValidity), (ContextEdge)component));
                    break;
                }
                case REMOVE: {
                    Iterator<Map.Entry<Instant, ContextEdge>> it = this.validityQueue.iterator();
                    while (it.hasNext()) {
                        if (it.next().getValue() != component) continue;
                        it.remove();
                    }
                    break;
                }
            }
        }
        super.performOperation(component, operation, externalCall);
        if (this.parent != null && externalCall) {
            this.parent.notifyContextChange();
        }
        return this;
    }

    @Override
    protected void addTransaction(TrackingGraph.Transaction t) {
        super.addTransaction(t);
        if (this.parent != null) {
            this.parent.notifyContextChange();
        }
    }

    @Override
    public void tick(Instant.TimeKeeper ticker, Instant now) {
        HashSet<Edge> removals = new HashSet<Edge>();
        while (this.validityQueue.peek().getKey().before(now)) {
            removals.add(this.validityQueue.poll().getValue());
        }
        this.removeAll(removals);
    }

    public static class ContextEdge
    extends SimpleEdge {
        Instant.Offset initialValidity = null;

        public ContextEdge(Node fromNode, Node toNode, String edgeLabel, Instant.Offset edgeValidity) {
            super(fromNode, toNode, edgeLabel);
            if (edgeValidity != null) {
                throw new IllegalArgumentException("Edge validity must be an instantiated object.");
            }
            this.initialValidity = edgeValidity;
        }
    }
}

