/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.graphs.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.xqhs.graphs.context.ContextGraph;
import net.xqhs.graphs.context.ContextPattern;
import net.xqhs.graphs.context.ContinuousContextMatchingPlatform;
import net.xqhs.graphs.context.ContinuousMatchingProcess;
import net.xqhs.graphs.context.Instant;
import net.xqhs.graphs.graph.Graph;
import net.xqhs.graphs.matcher.Match;
import net.xqhs.graphs.matcher.MonitorPack;
import net.xqhs.graphs.matchingPlatform.GMPImplementation;
import net.xqhs.graphs.matchingPlatform.GraphMatchingPlatform;
import net.xqhs.graphs.pattern.GraphPattern;
import net.xqhs.util.logging.Unit;

public class CCMImplementation
extends Unit
implements ContinuousContextMatchingPlatform {
    Instant.TimeKeeper theTime;
    GraphMatchingPlatform matchingPlatform = new GMPImplementation();
    boolean continuousMatching = false;
    Map<ContextPattern, Set<MatchNotificationTarget>> notificationTargets = new HashMap<ContextPattern, Set<MatchNotificationTarget>>();

    public CCMImplementation(Instant.TimeKeeper time, MonitorPack monitorLink) {
        this.theTime = time;
        if (monitorLink != null) {
            ((GMPImplementation)this.matchingPlatform).setMonitor(monitorLink);
        }
    }

    @Override
    public CCMImplementation setContextGraph(ContextGraph graph) {
        graph.setTimeKeeper(this.theTime);
        this.matchingPlatform.setPrincipalGraph(graph);
        this.getMatching();
        return this;
    }

    @Override
    public CCMImplementation addContextPattern(ContextPattern pattern) {
        this.matchingPlatform.addPattern((GraphPattern)pattern.lock());
        this.getMatching();
        return this;
    }

    @Override
    public CCMImplementation removeContextPattern(ContextPattern pattern) {
        this.matchingPlatform.removePattern(pattern);
        return this;
    }

    @Override
    public CCMImplementation addMatchNotificationTarget(int thresholdK, ContinuousMatchingProcess.MatchNotificationReceiver receiver) {
        if (!this.notificationTargets.containsKey(null)) {
            this.notificationTargets.put(null, new HashSet());
        }
        this.notificationTargets.get(null).add(new MatchNotificationTarget(thresholdK, receiver));
        return this;
    }

    @Override
    public CCMImplementation addMatchNotificationTarget(ContextPattern pattern, ContinuousMatchingProcess.MatchNotificationReceiver receiver) {
        if (!this.notificationTargets.containsKey(pattern)) {
            this.notificationTargets.put(pattern, new HashSet());
        }
        this.notificationTargets.get(pattern).add(new MatchNotificationTarget(-1, receiver));
        return this;
    }

    @Override
    public ContinuousMatchingProcess removeMatchNotificationTarget(ContinuousMatchingProcess.MatchNotificationReceiver receiver) {
        for (Set<MatchNotificationTarget> targetSet : this.notificationTargets.values()) {
            targetSet.remove(receiver);
        }
        return this;
    }

    @Override
    public ContinuousMatchingProcess startMatchingAgainstAllPatterns(Graph graph, int thresholdK, ContinuousMatchingProcess.MatchNotificationReceiver receiver) {
        return null;
    }

    @Override
    public ContinuousMatchingProcess startMatchingAgainstGraph(Graph pattern, int thresholdK, ContinuousMatchingProcess.MatchNotificationReceiver receiver) {
        return null;
    }

    @Override
    public CCMImplementation startContinuousMatching() {
        this.continuousMatching = true;
        this.getMatching();
        return this;
    }

    @Override
    public CCMImplementation stopContinuousMatching() {
        this.continuousMatching = false;
        return null;
    }

    @Override
    public boolean isContinuouslyMatching() {
        return this.continuousMatching;
    }

    protected void getMatching() {
        while (this.matchingPlatform.getMathingSequence() < this.matchingPlatform.getGraphSequence()) {
            Set<Match> matches = this.matchingPlatform.incrementSequence();
            for (Match m : matches) {
                for (Map.Entry<ContextPattern, Set<MatchNotificationTarget>> entry : this.notificationTargets.entrySet()) {
                    if (entry.getKey() != null && entry.getKey() != m.getPattern()) continue;
                    for (MatchNotificationTarget tg : entry.getValue()) {
                        if (tg.k >= 0 && m.getK() > tg.k) continue;
                        tg.receiver.receiveMatchNotification(this, m);
                    }
                }
            }
        }
    }

    protected void notifyContextChange() {
        if (this.continuousMatching) {
            this.getMatching();
        }
    }

    class MatchNotificationTarget {
        int k;
        ContinuousMatchingProcess.MatchNotificationReceiver receiver;

        public MatchNotificationTarget(int maxK, ContinuousMatchingProcess.MatchNotificationReceiver notificationReceiver) {
            this.k = maxK;
            this.receiver = notificationReceiver;
        }
    }
}

