/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.util.logging.wrappers;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.xqhs.util.logging.LoggerSimple;
import net.xqhs.util.logging.logging.LogWrapper;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public class Log4JWrapper
extends LogWrapper {
    protected Logger theLog = null;
    protected Set<Appender> appenders = new HashSet<Appender>();

    public Log4JWrapper(String string) {
        this.theLog = Logger.getLogger((String)string);
    }

    @Override
    public void setLevel(LoggerSimple.Level level) {
        this.theLog.setLevel(Log4JWrapper.toWrapedLevel(level));
    }

    @Override
    public void addDestination(String string, OutputStream outputStream) {
        WriterAppender writerAppender = new WriterAppender((Layout)new PatternLayout(string), outputStream);
        this.theLog.addAppender((Appender)writerAppender);
        this.appenders.add((Appender)writerAppender);
    }

    protected static Level toWrapedLevel(LoggerSimple.Level level) {
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case INFO: {
                return Level.INFO;
            }
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case WARN: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    @Override
    public void l(LoggerSimple.Level level, String string) {
        this.theLog.log((Priority)Log4JWrapper.toWrapedLevel(level), (Object)string);
    }

    @Override
    public void exit() {
        this.theLog.setLevel(Level.OFF);
    }
}

