/*
 * Decompiled with CFR 0.152.
 */
package net.xqhs.util.logging.wrappers;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import net.xqhs.util.logging.LoggerSimple;
import net.xqhs.util.logging.logging.LogWrapper;

public class JavaLogWrapper
extends LogWrapper {
    protected Logger theLog = null;
    protected Set<StreamHandler> handlers = new HashSet<StreamHandler>();

    public JavaLogWrapper(String string) {
        this.theLog = Logger.getLogger(string);
    }

    protected static Level toWrapedLevel(LoggerSimple.Level level) {
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case INFO: {
                return Level.INFO;
            }
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.FINE;
            }
            case WARN: {
                return Level.WARNING;
            }
        }
        return Level.INFO;
    }

    @Override
    public void setLevel(LoggerSimple.Level level) {
        this.theLog.setLevel(JavaLogWrapper.toWrapedLevel(level));
    }

    @Override
    public void addDestination(String string, OutputStream outputStream) {
        StreamHandler streamHandler = new StreamHandler(outputStream, new SimpleFormatter());
        this.handlers.add(streamHandler);
        this.theLog.addHandler(streamHandler);
    }

    @Override
    public void l(LoggerSimple.Level level, String string) {
        this.theLog.log(JavaLogWrapper.toWrapedLevel(level), string);
    }

    @Override
    public void exit() {
        this.theLog.setLevel(Level.OFF);
        for (StreamHandler streamHandler : this.handlers) {
            this.theLog.removeHandler(streamHandler);
        }
    }
}

